/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.V2QueueObservationMetricStats;
import com.mypurecloud.sdk.v2.model.V2QueueObservationObservation;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Observation data for one metric")
public class V2QueueObservationMetricData
implements Serializable {
    private MetricEnum metric = null;
    private List<V2QueueObservationObservation> observations = null;
    private Boolean truncated = null;
    private V2QueueObservationMetricStats stats = null;

    public V2QueueObservationMetricData() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.observations = new ArrayList<V2QueueObservationObservation>();
        }
    }

    public V2QueueObservationMetricData metric(MetricEnum metric) {
        this.metric = metric;
        return this;
    }

    @ApiModelProperty(example="null", value="The observation metric")
    @JsonProperty(value="metric")
    public MetricEnum getMetric() {
        return this.metric;
    }

    public void setMetric(MetricEnum metric) {
        this.metric = metric;
    }

    public V2QueueObservationMetricData observations(List<V2QueueObservationObservation> observations) {
        this.observations = observations;
        return this;
    }

    @ApiModelProperty(example="null", value="List of observations sorted by timestamp in ascending order. This list may be truncated.")
    @JsonProperty(value="observations")
    public List<V2QueueObservationObservation> getObservations() {
        return this.observations;
    }

    public void setObservations(List<V2QueueObservationObservation> observations) {
        this.observations = observations;
    }

    public V2QueueObservationMetricData truncated(Boolean truncated) {
        this.truncated = truncated;
        return this;
    }

    @ApiModelProperty(example="null", value="Flag indicating whether the list of observations was truncated or not")
    @JsonProperty(value="truncated")
    public Boolean getTruncated() {
        return this.truncated;
    }

    public void setTruncated(Boolean truncated) {
        this.truncated = truncated;
    }

    public V2QueueObservationMetricData stats(V2QueueObservationMetricStats stats) {
        this.stats = stats;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="stats")
    public V2QueueObservationMetricStats getStats() {
        return this.stats;
    }

    public void setStats(V2QueueObservationMetricStats stats) {
        this.stats = stats;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2QueueObservationMetricData v2QueueObservationMetricData = (V2QueueObservationMetricData)o;
        return Objects.equals((Object)this.metric, (Object)v2QueueObservationMetricData.metric) && Objects.equals(this.observations, v2QueueObservationMetricData.observations) && Objects.equals(this.truncated, v2QueueObservationMetricData.truncated) && Objects.equals(this.stats, v2QueueObservationMetricData.stats);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.metric, this.observations, this.truncated, this.stats});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V2QueueObservationMetricData {\n");
        sb.append("    metric: ").append(this.toIndentedString((Object)this.metric)).append("\n");
        sb.append("    observations: ").append(this.toIndentedString(this.observations)).append("\n");
        sb.append("    truncated: ").append(this.toIndentedString(this.truncated)).append("\n");
        sb.append("    stats: ").append(this.toIndentedString(this.stats)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=MetricEnumDeserializer.class)
    public static enum MetricEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        OALERTING("oAlerting"),
        OINTERACTING("oInteracting"),
        OWAITING("oWaiting"),
        OFLOW("oFlow"),
        OLONGESTWAITING("oLongestWaiting"),
        OLONGESTINTERACTING("oLongestInteracting");

        private String value;

        private MetricEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MetricEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MetricEnum value : MetricEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MetricEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MetricEnumDeserializer
    extends StdDeserializer<MetricEnum> {
        public MetricEnumDeserializer() {
            super(MetricEnumDeserializer.class);
        }

        public MetricEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MetricEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

