/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class TrustUpdate
implements Serializable {
    private Boolean enabled = null;
    private Date dateExpired = null;

    public TrustUpdate() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public TrustUpdate enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="If disabled no trustee user will have access, even if they were previously added.")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public TrustUpdate dateExpired(Date dateExpired) {
        this.dateExpired = dateExpired;
        return this;
    }

    @ApiModelProperty(example="null", value="The expiration date of the trust. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateExpired")
    public Date getDateExpired() {
        return this.dateExpired;
    }

    public void setDateExpired(Date dateExpired) {
        this.dateExpired = dateExpired;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrustUpdate trustUpdate = (TrustUpdate)o;
        return Objects.equals(this.enabled, trustUpdate.enabled) && Objects.equals(this.dateExpired, trustUpdate.dateExpired);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.dateExpired);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TrustUpdate {\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    dateExpired: ").append(this.toIndentedString(this.dateExpired)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

