/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class ForecastSourceDayPointer
implements Serializable {
    private DayOfWeekEnum dayOfWeek = null;
    private Integer weight = null;
    private String date = null;
    private String fileName = null;
    private String dataKey = null;

    public ForecastSourceDayPointer() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public ForecastSourceDayPointer dayOfWeek(DayOfWeekEnum dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
        return this;
    }

    @ApiModelProperty(example="null", value="The forecast day of week for this source data")
    @JsonProperty(value="dayOfWeek")
    public DayOfWeekEnum getDayOfWeek() {
        return this.dayOfWeek;
    }

    public void setDayOfWeek(DayOfWeekEnum dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
    }

    public ForecastSourceDayPointer weight(Integer weight) {
        this.weight = weight;
        return this;
    }

    @ApiModelProperty(example="null", value="The relative weight to apply to this source data item for weighted averages")
    @JsonProperty(value="weight")
    public Integer getWeight() {
        return this.weight;
    }

    public void setWeight(Integer weight) {
        this.weight = weight;
    }

    public ForecastSourceDayPointer date(String date) {
        this.date = date;
        return this;
    }

    @ApiModelProperty(example="null", value="The date this source data represents, in yyyy-MM-dd format")
    @JsonProperty(value="date")
    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public ForecastSourceDayPointer fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of the source file this data came from if it originated from a data import")
    @JsonProperty(value="fileName")
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public ForecastSourceDayPointer dataKey(String dataKey) {
        this.dataKey = dataKey;
        return this;
    }

    @ApiModelProperty(example="null", value="The key to look up the forecast source data for this source day")
    @JsonProperty(value="dataKey")
    public String getDataKey() {
        return this.dataKey;
    }

    public void setDataKey(String dataKey) {
        this.dataKey = dataKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ForecastSourceDayPointer forecastSourceDayPointer = (ForecastSourceDayPointer)o;
        return Objects.equals((Object)this.dayOfWeek, (Object)forecastSourceDayPointer.dayOfWeek) && Objects.equals(this.weight, forecastSourceDayPointer.weight) && Objects.equals(this.date, forecastSourceDayPointer.date) && Objects.equals(this.fileName, forecastSourceDayPointer.fileName) && Objects.equals(this.dataKey, forecastSourceDayPointer.dataKey);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dayOfWeek, this.weight, this.date, this.fileName, this.dataKey});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ForecastSourceDayPointer {\n");
        sb.append("    dayOfWeek: ").append(this.toIndentedString((Object)this.dayOfWeek)).append("\n");
        sb.append("    weight: ").append(this.toIndentedString(this.weight)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.fileName)).append("\n");
        sb.append("    dataKey: ").append(this.toIndentedString(this.dataKey)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=DayOfWeekEnumDeserializer.class)
    public static enum DayOfWeekEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SUNDAY("Sunday"),
        MONDAY("Monday"),
        TUESDAY("Tuesday"),
        WEDNESDAY("Wednesday"),
        THURSDAY("Thursday"),
        FRIDAY("Friday"),
        SATURDAY("Saturday"),
        EIGHTHDAY("EighthDay");

        private String value;

        private DayOfWeekEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DayOfWeekEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DayOfWeekEnum value : DayOfWeekEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DayOfWeekEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class DayOfWeekEnumDeserializer
    extends StdDeserializer<DayOfWeekEnum> {
        public DayOfWeekEnumDeserializer() {
            super(DayOfWeekEnumDeserializer.class);
        }

        public DayOfWeekEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DayOfWeekEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

