/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

public class FaxStatus
implements Serializable {
    private String direction = null;
    private Long expectedPages = null;
    private Long activePage = null;
    private Long linesTransmitted = null;
    private Long bytesTransmitted = null;
    private Long baudRate = null;
    private Long pageErrors = null;
    private Long lineErrors = null;

    public FaxStatus() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public FaxStatus direction(String direction) {
        this.direction = direction;
        return this;
    }

    @ApiModelProperty(example="null", value="The fax direction, either \"send\" or \"receive\".")
    @JsonProperty(value="direction")
    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public FaxStatus expectedPages(Long expectedPages) {
        this.expectedPages = expectedPages;
        return this;
    }

    @ApiModelProperty(example="null", value="Total number of expected pages, if known.")
    @JsonProperty(value="expectedPages")
    public Long getExpectedPages() {
        return this.expectedPages;
    }

    public void setExpectedPages(Long expectedPages) {
        this.expectedPages = expectedPages;
    }

    public FaxStatus activePage(Long activePage) {
        this.activePage = activePage;
        return this;
    }

    @ApiModelProperty(example="null", value="Active page of the transmission.")
    @JsonProperty(value="activePage")
    public Long getActivePage() {
        return this.activePage;
    }

    public void setActivePage(Long activePage) {
        this.activePage = activePage;
    }

    public FaxStatus linesTransmitted(Long linesTransmitted) {
        this.linesTransmitted = linesTransmitted;
        return this;
    }

    @ApiModelProperty(example="null", value="Number of lines that have completed transmission.")
    @JsonProperty(value="linesTransmitted")
    public Long getLinesTransmitted() {
        return this.linesTransmitted;
    }

    public void setLinesTransmitted(Long linesTransmitted) {
        this.linesTransmitted = linesTransmitted;
    }

    public FaxStatus bytesTransmitted(Long bytesTransmitted) {
        this.bytesTransmitted = bytesTransmitted;
        return this;
    }

    @ApiModelProperty(example="null", value="Number of bytes that have competed transmission.")
    @JsonProperty(value="bytesTransmitted")
    public Long getBytesTransmitted() {
        return this.bytesTransmitted;
    }

    public void setBytesTransmitted(Long bytesTransmitted) {
        this.bytesTransmitted = bytesTransmitted;
    }

    public FaxStatus baudRate(Long baudRate) {
        this.baudRate = baudRate;
        return this;
    }

    @ApiModelProperty(example="null", value="Current signaling rate of transmission, baud rate.")
    @JsonProperty(value="baudRate")
    public Long getBaudRate() {
        return this.baudRate;
    }

    public void setBaudRate(Long baudRate) {
        this.baudRate = baudRate;
    }

    public FaxStatus pageErrors(Long pageErrors) {
        this.pageErrors = pageErrors;
        return this;
    }

    @ApiModelProperty(example="null", value="Number of page errors.")
    @JsonProperty(value="pageErrors")
    public Long getPageErrors() {
        return this.pageErrors;
    }

    public void setPageErrors(Long pageErrors) {
        this.pageErrors = pageErrors;
    }

    public FaxStatus lineErrors(Long lineErrors) {
        this.lineErrors = lineErrors;
        return this;
    }

    @ApiModelProperty(example="null", value="Number of line errors.")
    @JsonProperty(value="lineErrors")
    public Long getLineErrors() {
        return this.lineErrors;
    }

    public void setLineErrors(Long lineErrors) {
        this.lineErrors = lineErrors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FaxStatus faxStatus = (FaxStatus)o;
        return Objects.equals(this.direction, faxStatus.direction) && Objects.equals(this.expectedPages, faxStatus.expectedPages) && Objects.equals(this.activePage, faxStatus.activePage) && Objects.equals(this.linesTransmitted, faxStatus.linesTransmitted) && Objects.equals(this.bytesTransmitted, faxStatus.bytesTransmitted) && Objects.equals(this.baudRate, faxStatus.baudRate) && Objects.equals(this.pageErrors, faxStatus.pageErrors) && Objects.equals(this.lineErrors, faxStatus.lineErrors);
    }

    public int hashCode() {
        return Objects.hash(this.direction, this.expectedPages, this.activePage, this.linesTransmitted, this.bytesTransmitted, this.baudRate, this.pageErrors, this.lineErrors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FaxStatus {\n");
        sb.append("    direction: ").append(this.toIndentedString(this.direction)).append("\n");
        sb.append("    expectedPages: ").append(this.toIndentedString(this.expectedPages)).append("\n");
        sb.append("    activePage: ").append(this.toIndentedString(this.activePage)).append("\n");
        sb.append("    linesTransmitted: ").append(this.toIndentedString(this.linesTransmitted)).append("\n");
        sb.append("    bytesTransmitted: ").append(this.toIndentedString(this.bytesTransmitted)).append("\n");
        sb.append("    baudRate: ").append(this.toIndentedString(this.baudRate)).append("\n");
        sb.append("    pageErrors: ").append(this.toIndentedString(this.pageErrors)).append("\n");
        sb.append("    lineErrors: ").append(this.toIndentedString(this.lineErrors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

