/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.DraftIntents;
import com.mypurecloud.sdk.v2.model.DraftTopics;
import com.mypurecloud.sdk.v2.model.Miner;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class Draft
implements Serializable {
    private String id = null;
    private String name = null;
    private Miner miner = null;
    private List<DraftIntents> intents = null;
    private List<DraftTopics> topics = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private String selfUri = null;

    public Draft() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.intents = new ArrayList<DraftIntents>();
            this.topics = new ArrayList<DraftTopics>();
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public Draft name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Draft name")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(example="null", value="Miner to which the draft belongs.")
    @JsonProperty(value="miner")
    public Miner getMiner() {
        return this.miner;
    }

    @ApiModelProperty(example="null", value="Draft intent object.")
    @JsonProperty(value="intents")
    public List<DraftIntents> getIntents() {
        return this.intents;
    }

    @ApiModelProperty(example="null", value="Draft topic object.")
    @JsonProperty(value="topics")
    public List<DraftTopics> getTopics() {
        return this.topics;
    }

    @ApiModelProperty(example="null", value="Date when the draft was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="Date when the draft was updated. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Draft draft = (Draft)o;
        return Objects.equals(this.id, draft.id) && Objects.equals(this.name, draft.name) && Objects.equals(this.miner, draft.miner) && Objects.equals(this.intents, draft.intents) && Objects.equals(this.topics, draft.topics) && Objects.equals(this.dateCreated, draft.dateCreated) && Objects.equals(this.dateModified, draft.dateModified) && Objects.equals(this.selfUri, draft.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.miner, this.intents, this.topics, this.dateCreated, this.dateModified, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Draft {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    miner: ").append(this.toIndentedString(this.miner)).append("\n");
        sb.append("    intents: ").append(this.toIndentedString(this.intents)).append("\n");
        sb.append("    topics: ").append(this.toIndentedString(this.topics)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

