/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.SettableFuture;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.AsyncApiCallback;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.DeleteEmailsSettingsThreadingRequest;
import com.mypurecloud.sdk.v2.api.request.GetEmailsSettingsRequest;
import com.mypurecloud.sdk.v2.api.request.GetEmailsSettingsThreadingRequest;
import com.mypurecloud.sdk.v2.api.request.PatchEmailsSettingsRequest;
import com.mypurecloud.sdk.v2.api.request.PatchEmailsSettingsThreadingRequest;
import com.mypurecloud.sdk.v2.model.EmailSettings;
import com.mypurecloud.sdk.v2.model.EmailThreadingSettings;
import java.util.concurrent.Future;

public class EmailsApiAsync {
    private final ApiClient pcapiClient;

    public EmailsApiAsync() {
        this(Configuration.getDefaultApiClient());
    }

    public EmailsApiAsync(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public Future<Void> deleteEmailsSettingsThreadingAsync(DeleteEmailsSettingsThreadingRequest request, final AsyncApiCallback<Void> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request.withHttpInfo(), null, new AsyncApiCallback<ApiResponse<Void>>(){

                @Override
                public void onCompleted(ApiResponse<Void> response) {
                    EmailsApiAsync.this.notifySuccess(future, callback, response.getBody());
                }

                @Override
                public void onFailed(Throwable exception) {
                    if (shouldThrowErrors) {
                        EmailsApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        EmailsApiAsync.this.notifySuccess(future, callback, null);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<ApiResponse<Void>> deleteEmailsSettingsThreadingAsync(ApiRequest<Void> request, final AsyncApiCallback<ApiResponse<Void>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request, null, new AsyncApiCallback<ApiResponse<Void>>(){

                @Override
                public void onCompleted(ApiResponse<Void> response) {
                    EmailsApiAsync.this.notifySuccess(future, callback, response);
                }

                @Override
                public void onFailed(Throwable exception) {
                    ApiResponse response;
                    if (exception instanceof ApiException) {
                        response = (ApiResponse)((Object)exception);
                        EmailsApiAsync.this.notifySuccess(future, callback, response);
                    }
                    if (shouldThrowErrors) {
                        EmailsApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        response = new ApiException(exception);
                        EmailsApiAsync.this.notifySuccess(future, callback, response);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<EmailSettings> getEmailsSettingsAsync(GetEmailsSettingsRequest request, final AsyncApiCallback<EmailSettings> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<EmailSettings>(){}, new AsyncApiCallback<ApiResponse<EmailSettings>>(){

                @Override
                public void onCompleted(ApiResponse<EmailSettings> response) {
                    EmailsApiAsync.this.notifySuccess(future, callback, response.getBody());
                }

                @Override
                public void onFailed(Throwable exception) {
                    if (shouldThrowErrors) {
                        EmailsApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        EmailsApiAsync.this.notifySuccess(future, callback, null);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<ApiResponse<EmailSettings>> getEmailsSettingsAsync(ApiRequest<Void> request, final AsyncApiCallback<ApiResponse<EmailSettings>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request, new TypeReference<EmailSettings>(){}, new AsyncApiCallback<ApiResponse<EmailSettings>>(){

                @Override
                public void onCompleted(ApiResponse<EmailSettings> response) {
                    EmailsApiAsync.this.notifySuccess(future, callback, response);
                }

                @Override
                public void onFailed(Throwable exception) {
                    ApiResponse response;
                    if (exception instanceof ApiException) {
                        response = (ApiResponse)((Object)exception);
                        EmailsApiAsync.this.notifySuccess(future, callback, response);
                    }
                    if (shouldThrowErrors) {
                        EmailsApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        response = new ApiException(exception);
                        EmailsApiAsync.this.notifySuccess(future, callback, response);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<EmailThreadingSettings> getEmailsSettingsThreadingAsync(GetEmailsSettingsThreadingRequest request, final AsyncApiCallback<EmailThreadingSettings> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<EmailThreadingSettings>(){}, new AsyncApiCallback<ApiResponse<EmailThreadingSettings>>(){

                @Override
                public void onCompleted(ApiResponse<EmailThreadingSettings> response) {
                    EmailsApiAsync.this.notifySuccess(future, callback, response.getBody());
                }

                @Override
                public void onFailed(Throwable exception) {
                    if (shouldThrowErrors) {
                        EmailsApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        EmailsApiAsync.this.notifySuccess(future, callback, null);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<ApiResponse<EmailThreadingSettings>> getEmailsSettingsThreadingAsync(ApiRequest<Void> request, final AsyncApiCallback<ApiResponse<EmailThreadingSettings>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request, new TypeReference<EmailThreadingSettings>(){}, new AsyncApiCallback<ApiResponse<EmailThreadingSettings>>(){

                @Override
                public void onCompleted(ApiResponse<EmailThreadingSettings> response) {
                    EmailsApiAsync.this.notifySuccess(future, callback, response);
                }

                @Override
                public void onFailed(Throwable exception) {
                    ApiResponse response;
                    if (exception instanceof ApiException) {
                        response = (ApiResponse)((Object)exception);
                        EmailsApiAsync.this.notifySuccess(future, callback, response);
                    }
                    if (shouldThrowErrors) {
                        EmailsApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        response = new ApiException(exception);
                        EmailsApiAsync.this.notifySuccess(future, callback, response);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<EmailSettings> patchEmailsSettingsAsync(PatchEmailsSettingsRequest request, final AsyncApiCallback<EmailSettings> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<EmailSettings>(){}, new AsyncApiCallback<ApiResponse<EmailSettings>>(){

                @Override
                public void onCompleted(ApiResponse<EmailSettings> response) {
                    EmailsApiAsync.this.notifySuccess(future, callback, response.getBody());
                }

                @Override
                public void onFailed(Throwable exception) {
                    if (shouldThrowErrors) {
                        EmailsApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        EmailsApiAsync.this.notifySuccess(future, callback, null);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<ApiResponse<EmailSettings>> patchEmailsSettingsAsync(ApiRequest<EmailSettings> request, final AsyncApiCallback<ApiResponse<EmailSettings>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request, new TypeReference<EmailSettings>(){}, new AsyncApiCallback<ApiResponse<EmailSettings>>(){

                @Override
                public void onCompleted(ApiResponse<EmailSettings> response) {
                    EmailsApiAsync.this.notifySuccess(future, callback, response);
                }

                @Override
                public void onFailed(Throwable exception) {
                    ApiResponse response;
                    if (exception instanceof ApiException) {
                        response = (ApiResponse)((Object)exception);
                        EmailsApiAsync.this.notifySuccess(future, callback, response);
                    }
                    if (shouldThrowErrors) {
                        EmailsApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        response = new ApiException(exception);
                        EmailsApiAsync.this.notifySuccess(future, callback, response);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<EmailThreadingSettings> patchEmailsSettingsThreadingAsync(PatchEmailsSettingsThreadingRequest request, final AsyncApiCallback<EmailThreadingSettings> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<EmailThreadingSettings>(){}, new AsyncApiCallback<ApiResponse<EmailThreadingSettings>>(){

                @Override
                public void onCompleted(ApiResponse<EmailThreadingSettings> response) {
                    EmailsApiAsync.this.notifySuccess(future, callback, response.getBody());
                }

                @Override
                public void onFailed(Throwable exception) {
                    if (shouldThrowErrors) {
                        EmailsApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        EmailsApiAsync.this.notifySuccess(future, callback, null);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<ApiResponse<EmailThreadingSettings>> patchEmailsSettingsThreadingAsync(ApiRequest<EmailThreadingSettings> request, final AsyncApiCallback<ApiResponse<EmailThreadingSettings>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request, new TypeReference<EmailThreadingSettings>(){}, new AsyncApiCallback<ApiResponse<EmailThreadingSettings>>(){

                @Override
                public void onCompleted(ApiResponse<EmailThreadingSettings> response) {
                    EmailsApiAsync.this.notifySuccess(future, callback, response);
                }

                @Override
                public void onFailed(Throwable exception) {
                    ApiResponse response;
                    if (exception instanceof ApiException) {
                        response = (ApiResponse)((Object)exception);
                        EmailsApiAsync.this.notifySuccess(future, callback, response);
                    }
                    if (shouldThrowErrors) {
                        EmailsApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        response = new ApiException(exception);
                        EmailsApiAsync.this.notifySuccess(future, callback, response);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    private <T> void notifySuccess(SettableFuture<T> future, AsyncApiCallback<T> callback, T result) {
        if (callback != null) {
            try {
                callback.onCompleted(result);
                future.set(result);
            }
            catch (Throwable exception) {
                future.setException(exception);
            }
        } else {
            future.set(result);
        }
    }

    private <T> void notifyFailure(SettableFuture<T> future, AsyncApiCallback<T> callback, Throwable exception) {
        if (callback != null) {
            try {
                callback.onFailed(exception);
                future.setException(exception);
            }
            catch (Throwable callbackException) {
                future.setException(callbackException);
            }
        } else {
            future.setException(exception);
        }
    }
}

