/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.GetDownloadRequest;
import com.mypurecloud.sdk.v2.model.UrlResponse;
import java.io.IOException;

public class DownloadsApi {
    private final ApiClient pcapiClient;

    public DownloadsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DownloadsApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public UrlResponse getDownload(String downloadId, String contentDisposition, Boolean issueRedirect, Boolean redirectToAuth) throws IOException, ApiException {
        return this.getDownload(this.createGetDownloadRequest(downloadId, contentDisposition, issueRedirect, redirectToAuth));
    }

    public ApiResponse<UrlResponse> getDownloadWithHttpInfo(String downloadId, String contentDisposition, Boolean issueRedirect, Boolean redirectToAuth) throws IOException {
        return this.getDownload(this.createGetDownloadRequest(downloadId, contentDisposition, issueRedirect, redirectToAuth).withHttpInfo());
    }

    private GetDownloadRequest createGetDownloadRequest(String downloadId, String contentDisposition, Boolean issueRedirect, Boolean redirectToAuth) {
        return GetDownloadRequest.builder().withDownloadId(downloadId).withContentDisposition(contentDisposition).withIssueRedirect(issueRedirect).withRedirectToAuth(redirectToAuth).build();
    }

    public UrlResponse getDownload(GetDownloadRequest request) throws IOException, ApiException {
        try {
            ApiResponse<UrlResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<UrlResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<UrlResponse> getDownload(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<UrlResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

