/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.ListWrapperSecondaryPresence;
import com.mypurecloud.sdk.v2.model.WfmVersionedEntityMetadata;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class UpdateActivityCodeRequest
implements Serializable {
    private String name = null;
    private CategoryEnum category = null;
    private Integer lengthInMinutes = null;
    private Boolean countsAsPaidTime = null;
    private Boolean countsAsWorkTime = null;
    private Boolean agentTimeOffSelectable = null;
    private Boolean countsTowardShrinkage = null;
    private Boolean plannedShrinkage = null;
    private Boolean interruptible = null;
    private ListWrapperSecondaryPresence secondaryPresences = null;
    private WfmVersionedEntityMetadata metadata = null;

    public UpdateActivityCodeRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public UpdateActivityCodeRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of the activity code")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UpdateActivityCodeRequest category(CategoryEnum category) {
        this.category = category;
        return this;
    }

    @ApiModelProperty(example="null", value="The activity code's category. Attempting to change the category of a default activity code will return an error")
    @JsonProperty(value="category")
    public CategoryEnum getCategory() {
        return this.category;
    }

    public void setCategory(CategoryEnum category) {
        this.category = category;
    }

    public UpdateActivityCodeRequest lengthInMinutes(Integer lengthInMinutes) {
        this.lengthInMinutes = lengthInMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="The default length of the activity in minutes")
    @JsonProperty(value="lengthInMinutes")
    public Integer getLengthInMinutes() {
        return this.lengthInMinutes;
    }

    public void setLengthInMinutes(Integer lengthInMinutes) {
        this.lengthInMinutes = lengthInMinutes;
    }

    public UpdateActivityCodeRequest countsAsPaidTime(Boolean countsAsPaidTime) {
        this.countsAsPaidTime = countsAsPaidTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether an agent is paid while performing this activity")
    @JsonProperty(value="countsAsPaidTime")
    public Boolean getCountsAsPaidTime() {
        return this.countsAsPaidTime;
    }

    public void setCountsAsPaidTime(Boolean countsAsPaidTime) {
        this.countsAsPaidTime = countsAsPaidTime;
    }

    public UpdateActivityCodeRequest countsAsWorkTime(Boolean countsAsWorkTime) {
        this.countsAsWorkTime = countsAsWorkTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates whether or not the activity should be counted as work time")
    @JsonProperty(value="countsAsWorkTime")
    public Boolean getCountsAsWorkTime() {
        return this.countsAsWorkTime;
    }

    public void setCountsAsWorkTime(Boolean countsAsWorkTime) {
        this.countsAsWorkTime = countsAsWorkTime;
    }

    public UpdateActivityCodeRequest agentTimeOffSelectable(Boolean agentTimeOffSelectable) {
        this.agentTimeOffSelectable = agentTimeOffSelectable;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether an agent can select this activity code when creating or editing a time off request")
    @JsonProperty(value="agentTimeOffSelectable")
    public Boolean getAgentTimeOffSelectable() {
        return this.agentTimeOffSelectable;
    }

    public void setAgentTimeOffSelectable(Boolean agentTimeOffSelectable) {
        this.agentTimeOffSelectable = agentTimeOffSelectable;
    }

    public UpdateActivityCodeRequest countsTowardShrinkage(Boolean countsTowardShrinkage) {
        this.countsTowardShrinkage = countsTowardShrinkage;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether or not this activity code counts toward shrinkage calculations")
    @JsonProperty(value="countsTowardShrinkage")
    public Boolean getCountsTowardShrinkage() {
        return this.countsTowardShrinkage;
    }

    public void setCountsTowardShrinkage(Boolean countsTowardShrinkage) {
        this.countsTowardShrinkage = countsTowardShrinkage;
    }

    public UpdateActivityCodeRequest plannedShrinkage(Boolean plannedShrinkage) {
        this.plannedShrinkage = plannedShrinkage;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether this activity code is considered planned or unplanned shrinkage")
    @JsonProperty(value="plannedShrinkage")
    public Boolean getPlannedShrinkage() {
        return this.plannedShrinkage;
    }

    public void setPlannedShrinkage(Boolean plannedShrinkage) {
        this.plannedShrinkage = plannedShrinkage;
    }

    public UpdateActivityCodeRequest interruptible(Boolean interruptible) {
        this.interruptible = interruptible;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether this activity code is considered interruptible")
    @JsonProperty(value="interruptible")
    public Boolean getInterruptible() {
        return this.interruptible;
    }

    public void setInterruptible(Boolean interruptible) {
        this.interruptible = interruptible;
    }

    public UpdateActivityCodeRequest secondaryPresences(ListWrapperSecondaryPresence secondaryPresences) {
        this.secondaryPresences = secondaryPresences;
        return this;
    }

    @ApiModelProperty(example="null", value="The secondary presences of this activity code")
    @JsonProperty(value="secondaryPresences")
    public ListWrapperSecondaryPresence getSecondaryPresences() {
        return this.secondaryPresences;
    }

    public void setSecondaryPresences(ListWrapperSecondaryPresence secondaryPresences) {
        this.secondaryPresences = secondaryPresences;
    }

    public UpdateActivityCodeRequest metadata(WfmVersionedEntityMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Version metadata for the associated business unit's list of activity codes")
    @JsonProperty(value="metadata")
    public WfmVersionedEntityMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(WfmVersionedEntityMetadata metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateActivityCodeRequest updateActivityCodeRequest = (UpdateActivityCodeRequest)o;
        return Objects.equals(this.name, updateActivityCodeRequest.name) && Objects.equals((Object)this.category, (Object)updateActivityCodeRequest.category) && Objects.equals(this.lengthInMinutes, updateActivityCodeRequest.lengthInMinutes) && Objects.equals(this.countsAsPaidTime, updateActivityCodeRequest.countsAsPaidTime) && Objects.equals(this.countsAsWorkTime, updateActivityCodeRequest.countsAsWorkTime) && Objects.equals(this.agentTimeOffSelectable, updateActivityCodeRequest.agentTimeOffSelectable) && Objects.equals(this.countsTowardShrinkage, updateActivityCodeRequest.countsTowardShrinkage) && Objects.equals(this.plannedShrinkage, updateActivityCodeRequest.plannedShrinkage) && Objects.equals(this.interruptible, updateActivityCodeRequest.interruptible) && Objects.equals(this.secondaryPresences, updateActivityCodeRequest.secondaryPresences) && Objects.equals(this.metadata, updateActivityCodeRequest.metadata);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.category, this.lengthInMinutes, this.countsAsPaidTime, this.countsAsWorkTime, this.agentTimeOffSelectable, this.countsTowardShrinkage, this.plannedShrinkage, this.interruptible, this.secondaryPresences, this.metadata});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateActivityCodeRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    lengthInMinutes: ").append(this.toIndentedString(this.lengthInMinutes)).append("\n");
        sb.append("    countsAsPaidTime: ").append(this.toIndentedString(this.countsAsPaidTime)).append("\n");
        sb.append("    countsAsWorkTime: ").append(this.toIndentedString(this.countsAsWorkTime)).append("\n");
        sb.append("    agentTimeOffSelectable: ").append(this.toIndentedString(this.agentTimeOffSelectable)).append("\n");
        sb.append("    countsTowardShrinkage: ").append(this.toIndentedString(this.countsTowardShrinkage)).append("\n");
        sb.append("    plannedShrinkage: ").append(this.toIndentedString(this.plannedShrinkage)).append("\n");
        sb.append("    interruptible: ").append(this.toIndentedString(this.interruptible)).append("\n");
        sb.append("    secondaryPresences: ").append(this.toIndentedString(this.secondaryPresences)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=CategoryEnumDeserializer.class)
    public static enum CategoryEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ONQUEUEWORK("OnQueueWork"),
        BREAK("Break"),
        MEAL("Meal"),
        MEETING("Meeting"),
        OFFQUEUEWORK("OffQueueWork"),
        TIMEOFF("TimeOff"),
        TRAINING("Training"),
        UNAVAILABLE("Unavailable"),
        UNSCHEDULED("Unscheduled");

        private String value;

        private CategoryEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CategoryEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (CategoryEnum value : CategoryEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return CategoryEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class CategoryEnumDeserializer
    extends StdDeserializer<CategoryEnum> {
        public CategoryEnumDeserializer() {
            super(CategoryEnumDeserializer.class);
        }

        public CategoryEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return CategoryEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

