/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class ShiftTradeExternalActivityRule
implements Serializable {
    private ExternalActivityTypeEnum externalActivityType = null;
    private ActionEnum action = null;
    private String activityCodeIdReplacement = null;

    public ShiftTradeExternalActivityRule() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public ShiftTradeExternalActivityRule externalActivityType(ExternalActivityTypeEnum externalActivityType) {
        this.externalActivityType = externalActivityType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The external activity type to which to apply this rule")
    @JsonProperty(value="externalActivityType")
    public ExternalActivityTypeEnum getExternalActivityType() {
        return this.externalActivityType;
    }

    public void setExternalActivityType(ExternalActivityTypeEnum externalActivityType) {
        this.externalActivityType = externalActivityType;
    }

    public ShiftTradeExternalActivityRule action(ActionEnum action) {
        this.action = action;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The action this rule invokes")
    @JsonProperty(value="action")
    public ActionEnum getAction() {
        return this.action;
    }

    public void setAction(ActionEnum action) {
        this.action = action;
    }

    public ShiftTradeExternalActivityRule activityCodeIdReplacement(String activityCodeIdReplacement) {
        this.activityCodeIdReplacement = activityCodeIdReplacement;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the activity code with which to replace to replace external activities (required if action == KeepWithAgent, must be a default activity code ID)")
    @JsonProperty(value="activityCodeIdReplacement")
    public String getActivityCodeIdReplacement() {
        return this.activityCodeIdReplacement;
    }

    public void setActivityCodeIdReplacement(String activityCodeIdReplacement) {
        this.activityCodeIdReplacement = activityCodeIdReplacement;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShiftTradeExternalActivityRule shiftTradeExternalActivityRule = (ShiftTradeExternalActivityRule)o;
        return Objects.equals((Object)this.externalActivityType, (Object)shiftTradeExternalActivityRule.externalActivityType) && Objects.equals((Object)this.action, (Object)shiftTradeExternalActivityRule.action) && Objects.equals(this.activityCodeIdReplacement, shiftTradeExternalActivityRule.activityCodeIdReplacement);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.externalActivityType, this.action, this.activityCodeIdReplacement});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShiftTradeExternalActivityRule {\n");
        sb.append("    externalActivityType: ").append(this.toIndentedString((Object)this.externalActivityType)).append("\n");
        sb.append("    action: ").append(this.toIndentedString((Object)this.action)).append("\n");
        sb.append("    activityCodeIdReplacement: ").append(this.toIndentedString(this.activityCodeIdReplacement)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ExternalActivityTypeEnumDeserializer.class)
    public static enum ExternalActivityTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ACTIVITYPLAN("ActivityPlan"),
        COACHING("Coaching"),
        LEARNING("Learning");

        private String value;

        private ExternalActivityTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ExternalActivityTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ExternalActivityTypeEnum value : ExternalActivityTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ExternalActivityTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=ActionEnumDeserializer.class)
    public static enum ActionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        DONOTALLOWTRADE("DoNotAllowTrade"),
        KEEPWITHAGENT("KeepWithAgent");

        private String value;

        private ActionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ActionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ActionEnum value : ActionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ActionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ActionEnumDeserializer
    extends StdDeserializer<ActionEnum> {
        public ActionEnumDeserializer() {
            super(ActionEnumDeserializer.class);
        }

        public ActionEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ActionEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class ExternalActivityTypeEnumDeserializer
    extends StdDeserializer<ExternalActivityTypeEnum> {
        public ExternalActivityTypeEnumDeserializer() {
            super(ExternalActivityTypeEnumDeserializer.class);
        }

        public ExternalActivityTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ExternalActivityTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

