/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AcwSettings;
import com.mypurecloud.sdk.v2.model.AgentOwnedRouting;
import com.mypurecloud.sdk.v2.model.Bullseye;
import com.mypurecloud.sdk.v2.model.CannedResponseLibraries;
import com.mypurecloud.sdk.v2.model.ConditionalGroupRouting;
import com.mypurecloud.sdk.v2.model.DirectRouting;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import com.mypurecloud.sdk.v2.model.MemberGroup;
import com.mypurecloud.sdk.v2.model.QueueEmailAddress;
import com.mypurecloud.sdk.v2.model.QueueMediaSettings;
import com.mypurecloud.sdk.v2.model.QueueMessagingAddresses;
import com.mypurecloud.sdk.v2.model.RoutingRule;
import com.mypurecloud.sdk.v2.model.Script;
import com.mypurecloud.sdk.v2.model.WritableDivision;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class QueueRequest
implements Serializable {
    private String id = null;
    private String name = null;
    private WritableDivision division = null;
    private String description = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private String modifiedBy = null;
    private String createdBy = null;
    private Integer memberCount = null;
    private Integer userMemberCount = null;
    private Integer joinedMemberCount = null;
    private QueueMediaSettings mediaSettings = null;
    private List<RoutingRule> routingRules = null;
    private ConditionalGroupRouting conditionalGroupRouting = null;
    private Bullseye bullseye = null;
    private ScoringMethodEnum scoringMethod = null;
    private LastAgentRoutingModeEnum lastAgentRoutingMode = null;
    private AcwSettings acwSettings = null;
    private SkillEvaluationMethodEnum skillEvaluationMethod = null;
    private List<MemberGroup> memberGroups = null;
    private DomainEntityRef queueFlow = null;
    private DomainEntityRef emailInQueueFlow = null;
    private DomainEntityRef messageInQueueFlow = null;
    private DomainEntityRef whisperPrompt = null;
    private DomainEntityRef onHoldPrompt = null;
    private Boolean autoAnswerOnly = null;
    private CannedResponseLibraries cannedResponseLibraries = null;
    private Boolean enableTranscription = null;
    private Boolean enableAudioMonitoring = null;
    private Boolean enableManualAssignment = null;
    private AgentOwnedRouting agentOwnedRouting = null;
    private DirectRouting directRouting = null;
    private String callingPartyName = null;
    private String callingPartyNumber = null;
    private Map<String, Script> defaultScripts = null;
    private QueueMessagingAddresses outboundMessagingAddresses = null;
    private QueueEmailAddress outboundEmailAddress = null;
    private String peerId = null;
    private Boolean suppressInQueueCallRecording = null;
    private String selfUri = null;

    public QueueRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.routingRules = new ArrayList<RoutingRule>();
            this.memberGroups = new ArrayList<MemberGroup>();
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public QueueRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The queue name")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public QueueRequest division(WritableDivision division) {
        this.division = division;
        return this;
    }

    @ApiModelProperty(example="null", value="The division to which this entity belongs.")
    @JsonProperty(value="division")
    public WritableDivision getDivision() {
        return this.division;
    }

    public void setDivision(WritableDivision division) {
        this.division = division;
    }

    public QueueRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="The queue description.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public QueueRequest dateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    @ApiModelProperty(example="null", value="The date the queue was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public QueueRequest dateModified(Date dateModified) {
        this.dateModified = dateModified;
        return this;
    }

    @ApiModelProperty(example="null", value="The date of the last modification to the queue. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    public QueueRequest modifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the user that last modified the queue.")
    @JsonProperty(value="modifiedBy")
    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public QueueRequest createdBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the user that created the queue.")
    @JsonProperty(value="createdBy")
    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @ApiModelProperty(example="null", value="The total number of members in the queue.")
    @JsonProperty(value="memberCount")
    public Integer getMemberCount() {
        return this.memberCount;
    }

    @ApiModelProperty(example="null", value="The number of user members (i.e., non-group members) in the queue.")
    @JsonProperty(value="userMemberCount")
    public Integer getUserMemberCount() {
        return this.userMemberCount;
    }

    @ApiModelProperty(example="null", value="The number of joined members in the queue.")
    @JsonProperty(value="joinedMemberCount")
    public Integer getJoinedMemberCount() {
        return this.joinedMemberCount;
    }

    public QueueRequest mediaSettings(QueueMediaSettings mediaSettings) {
        this.mediaSettings = mediaSettings;
        return this;
    }

    @ApiModelProperty(example="null", value="The media settings for the queue.")
    @JsonProperty(value="mediaSettings")
    public QueueMediaSettings getMediaSettings() {
        return this.mediaSettings;
    }

    public void setMediaSettings(QueueMediaSettings mediaSettings) {
        this.mediaSettings = mediaSettings;
    }

    public QueueRequest routingRules(List<RoutingRule> routingRules) {
        this.routingRules = routingRules;
        return this;
    }

    @ApiModelProperty(example="null", value="The routing rules for the queue, used for Preferred Agent Routing.")
    @JsonProperty(value="routingRules")
    public List<RoutingRule> getRoutingRules() {
        return this.routingRules;
    }

    public void setRoutingRules(List<RoutingRule> routingRules) {
        this.routingRules = routingRules;
    }

    public QueueRequest conditionalGroupRouting(ConditionalGroupRouting conditionalGroupRouting) {
        this.conditionalGroupRouting = conditionalGroupRouting;
        return this;
    }

    @ApiModelProperty(example="null", value="The Conditional Group Routing settings for the queue.")
    @JsonProperty(value="conditionalGroupRouting")
    public ConditionalGroupRouting getConditionalGroupRouting() {
        return this.conditionalGroupRouting;
    }

    public void setConditionalGroupRouting(ConditionalGroupRouting conditionalGroupRouting) {
        this.conditionalGroupRouting = conditionalGroupRouting;
    }

    public QueueRequest bullseye(Bullseye bullseye) {
        this.bullseye = bullseye;
        return this;
    }

    @ApiModelProperty(example="null", value="The bullseye settings for the queue.")
    @JsonProperty(value="bullseye")
    public Bullseye getBullseye() {
        return this.bullseye;
    }

    public void setBullseye(Bullseye bullseye) {
        this.bullseye = bullseye;
    }

    public QueueRequest scoringMethod(ScoringMethodEnum scoringMethod) {
        this.scoringMethod = scoringMethod;
        return this;
    }

    @ApiModelProperty(example="null", value="The Scoring Method for the queue.")
    @JsonProperty(value="scoringMethod")
    public ScoringMethodEnum getScoringMethod() {
        return this.scoringMethod;
    }

    public void setScoringMethod(ScoringMethodEnum scoringMethod) {
        this.scoringMethod = scoringMethod;
    }

    public QueueRequest lastAgentRoutingMode(LastAgentRoutingModeEnum lastAgentRoutingMode) {
        this.lastAgentRoutingMode = lastAgentRoutingMode;
        return this;
    }

    @ApiModelProperty(example="null", value="The Last Agent Routing Mode for the queue.")
    @JsonProperty(value="lastAgentRoutingMode")
    public LastAgentRoutingModeEnum getLastAgentRoutingMode() {
        return this.lastAgentRoutingMode;
    }

    public void setLastAgentRoutingMode(LastAgentRoutingModeEnum lastAgentRoutingMode) {
        this.lastAgentRoutingMode = lastAgentRoutingMode;
    }

    public QueueRequest acwSettings(AcwSettings acwSettings) {
        this.acwSettings = acwSettings;
        return this;
    }

    @ApiModelProperty(example="null", value="The ACW settings for the queue.")
    @JsonProperty(value="acwSettings")
    public AcwSettings getAcwSettings() {
        return this.acwSettings;
    }

    public void setAcwSettings(AcwSettings acwSettings) {
        this.acwSettings = acwSettings;
    }

    public QueueRequest skillEvaluationMethod(SkillEvaluationMethodEnum skillEvaluationMethod) {
        this.skillEvaluationMethod = skillEvaluationMethod;
        return this;
    }

    @ApiModelProperty(example="null", value="The skill evaluation method to use when routing conversations.")
    @JsonProperty(value="skillEvaluationMethod")
    public SkillEvaluationMethodEnum getSkillEvaluationMethod() {
        return this.skillEvaluationMethod;
    }

    public void setSkillEvaluationMethod(SkillEvaluationMethodEnum skillEvaluationMethod) {
        this.skillEvaluationMethod = skillEvaluationMethod;
    }

    public QueueRequest memberGroups(List<MemberGroup> memberGroups) {
        this.memberGroups = memberGroups;
        return this;
    }

    @ApiModelProperty(example="null", value="The groups of agents associated with the queue, if any.  Queue membership will update to match group membership changes.")
    @JsonProperty(value="memberGroups")
    public List<MemberGroup> getMemberGroups() {
        return this.memberGroups;
    }

    public void setMemberGroups(List<MemberGroup> memberGroups) {
        this.memberGroups = memberGroups;
    }

    public QueueRequest queueFlow(DomainEntityRef queueFlow) {
        this.queueFlow = queueFlow;
        return this;
    }

    @ApiModelProperty(example="null", value="The in-queue flow to use for call conversations waiting in queue.")
    @JsonProperty(value="queueFlow")
    public DomainEntityRef getQueueFlow() {
        return this.queueFlow;
    }

    public void setQueueFlow(DomainEntityRef queueFlow) {
        this.queueFlow = queueFlow;
    }

    public QueueRequest emailInQueueFlow(DomainEntityRef emailInQueueFlow) {
        this.emailInQueueFlow = emailInQueueFlow;
        return this;
    }

    @ApiModelProperty(example="null", value="The in-queue flow to use for email conversations waiting in queue.")
    @JsonProperty(value="emailInQueueFlow")
    public DomainEntityRef getEmailInQueueFlow() {
        return this.emailInQueueFlow;
    }

    public void setEmailInQueueFlow(DomainEntityRef emailInQueueFlow) {
        this.emailInQueueFlow = emailInQueueFlow;
    }

    public QueueRequest messageInQueueFlow(DomainEntityRef messageInQueueFlow) {
        this.messageInQueueFlow = messageInQueueFlow;
        return this;
    }

    @ApiModelProperty(example="null", value="The in-queue flow to use for message conversations waiting in queue.")
    @JsonProperty(value="messageInQueueFlow")
    public DomainEntityRef getMessageInQueueFlow() {
        return this.messageInQueueFlow;
    }

    public void setMessageInQueueFlow(DomainEntityRef messageInQueueFlow) {
        this.messageInQueueFlow = messageInQueueFlow;
    }

    public QueueRequest whisperPrompt(DomainEntityRef whisperPrompt) {
        this.whisperPrompt = whisperPrompt;
        return this;
    }

    @ApiModelProperty(example="null", value="The prompt used for whisper on the queue, if configured.")
    @JsonProperty(value="whisperPrompt")
    public DomainEntityRef getWhisperPrompt() {
        return this.whisperPrompt;
    }

    public void setWhisperPrompt(DomainEntityRef whisperPrompt) {
        this.whisperPrompt = whisperPrompt;
    }

    public QueueRequest onHoldPrompt(DomainEntityRef onHoldPrompt) {
        this.onHoldPrompt = onHoldPrompt;
        return this;
    }

    @ApiModelProperty(example="null", value="The audio to be played when calls on this queue are on hold. If not configured, the default on-hold music will play.")
    @JsonProperty(value="onHoldPrompt")
    public DomainEntityRef getOnHoldPrompt() {
        return this.onHoldPrompt;
    }

    public void setOnHoldPrompt(DomainEntityRef onHoldPrompt) {
        this.onHoldPrompt = onHoldPrompt;
    }

    public QueueRequest autoAnswerOnly(Boolean autoAnswerOnly) {
        this.autoAnswerOnly = autoAnswerOnly;
        return this;
    }

    @ApiModelProperty(example="null", value="Specifies whether the configured whisper should play for all ACD calls, or only for those which are auto-answered.")
    @JsonProperty(value="autoAnswerOnly")
    public Boolean getAutoAnswerOnly() {
        return this.autoAnswerOnly;
    }

    public void setAutoAnswerOnly(Boolean autoAnswerOnly) {
        this.autoAnswerOnly = autoAnswerOnly;
    }

    public QueueRequest cannedResponseLibraries(CannedResponseLibraries cannedResponseLibraries) {
        this.cannedResponseLibraries = cannedResponseLibraries;
        return this;
    }

    @ApiModelProperty(example="null", value="Canned response library IDs and mode with which they are associated with the queue")
    @JsonProperty(value="cannedResponseLibraries")
    public CannedResponseLibraries getCannedResponseLibraries() {
        return this.cannedResponseLibraries;
    }

    public void setCannedResponseLibraries(CannedResponseLibraries cannedResponseLibraries) {
        this.cannedResponseLibraries = cannedResponseLibraries;
    }

    public QueueRequest enableTranscription(Boolean enableTranscription) {
        this.enableTranscription = enableTranscription;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates whether voice transcription is enabled for this queue.")
    @JsonProperty(value="enableTranscription")
    public Boolean getEnableTranscription() {
        return this.enableTranscription;
    }

    public void setEnableTranscription(Boolean enableTranscription) {
        this.enableTranscription = enableTranscription;
    }

    public QueueRequest enableAudioMonitoring(Boolean enableAudioMonitoring) {
        this.enableAudioMonitoring = enableAudioMonitoring;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates whether audio monitoring is enabled for this queue.")
    @JsonProperty(value="enableAudioMonitoring")
    public Boolean getEnableAudioMonitoring() {
        return this.enableAudioMonitoring;
    }

    public void setEnableAudioMonitoring(Boolean enableAudioMonitoring) {
        this.enableAudioMonitoring = enableAudioMonitoring;
    }

    public QueueRequest enableManualAssignment(Boolean enableManualAssignment) {
        this.enableManualAssignment = enableManualAssignment;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates whether manual assignment is enabled for this queue.")
    @JsonProperty(value="enableManualAssignment")
    public Boolean getEnableManualAssignment() {
        return this.enableManualAssignment;
    }

    public void setEnableManualAssignment(Boolean enableManualAssignment) {
        this.enableManualAssignment = enableManualAssignment;
    }

    public QueueRequest agentOwnedRouting(AgentOwnedRouting agentOwnedRouting) {
        this.agentOwnedRouting = agentOwnedRouting;
        return this;
    }

    @ApiModelProperty(example="null", value="The Agent Owned Routing settings for the queue")
    @JsonProperty(value="agentOwnedRouting")
    public AgentOwnedRouting getAgentOwnedRouting() {
        return this.agentOwnedRouting;
    }

    public void setAgentOwnedRouting(AgentOwnedRouting agentOwnedRouting) {
        this.agentOwnedRouting = agentOwnedRouting;
    }

    public QueueRequest directRouting(DirectRouting directRouting) {
        this.directRouting = directRouting;
        return this;
    }

    @ApiModelProperty(example="null", value="The Direct Routing settings for the queue")
    @JsonProperty(value="directRouting")
    public DirectRouting getDirectRouting() {
        return this.directRouting;
    }

    public void setDirectRouting(DirectRouting directRouting) {
        this.directRouting = directRouting;
    }

    public QueueRequest callingPartyName(String callingPartyName) {
        this.callingPartyName = callingPartyName;
        return this;
    }

    @ApiModelProperty(example="null", value="The name to use for caller identification for outbound calls from this queue.")
    @JsonProperty(value="callingPartyName")
    public String getCallingPartyName() {
        return this.callingPartyName;
    }

    public void setCallingPartyName(String callingPartyName) {
        this.callingPartyName = callingPartyName;
    }

    public QueueRequest callingPartyNumber(String callingPartyNumber) {
        this.callingPartyNumber = callingPartyNumber;
        return this;
    }

    @ApiModelProperty(example="null", value="The phone number to use for caller identification for outbound calls from this queue.")
    @JsonProperty(value="callingPartyNumber")
    public String getCallingPartyNumber() {
        return this.callingPartyNumber;
    }

    public void setCallingPartyNumber(String callingPartyNumber) {
        this.callingPartyNumber = callingPartyNumber;
    }

    public QueueRequest defaultScripts(Map<String, Script> defaultScripts) {
        this.defaultScripts = defaultScripts;
        return this;
    }

    @ApiModelProperty(example="null", value="The default script Ids for the communication types.")
    @JsonProperty(value="defaultScripts")
    public Map<String, Script> getDefaultScripts() {
        return this.defaultScripts;
    }

    public void setDefaultScripts(Map<String, Script> defaultScripts) {
        this.defaultScripts = defaultScripts;
    }

    public QueueRequest outboundMessagingAddresses(QueueMessagingAddresses outboundMessagingAddresses) {
        this.outboundMessagingAddresses = outboundMessagingAddresses;
        return this;
    }

    @ApiModelProperty(example="null", value="The messaging addresses for the queue.")
    @JsonProperty(value="outboundMessagingAddresses")
    public QueueMessagingAddresses getOutboundMessagingAddresses() {
        return this.outboundMessagingAddresses;
    }

    public void setOutboundMessagingAddresses(QueueMessagingAddresses outboundMessagingAddresses) {
        this.outboundMessagingAddresses = outboundMessagingAddresses;
    }

    public QueueRequest outboundEmailAddress(QueueEmailAddress outboundEmailAddress) {
        this.outboundEmailAddress = outboundEmailAddress;
        return this;
    }

    @ApiModelProperty(example="null", value="The default email address to use for outbound email from this queue.")
    @JsonProperty(value="outboundEmailAddress")
    public QueueEmailAddress getOutboundEmailAddress() {
        return this.outboundEmailAddress;
    }

    public void setOutboundEmailAddress(QueueEmailAddress outboundEmailAddress) {
        this.outboundEmailAddress = outboundEmailAddress;
    }

    public QueueRequest peerId(String peerId) {
        this.peerId = peerId;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of an associated external queue.")
    @JsonProperty(value="peerId")
    public String getPeerId() {
        return this.peerId;
    }

    public void setPeerId(String peerId) {
        this.peerId = peerId;
    }

    public QueueRequest suppressInQueueCallRecording(Boolean suppressInQueueCallRecording) {
        this.suppressInQueueCallRecording = suppressInQueueCallRecording;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates whether recording in-queue calls is suppressed for this queue.")
    @JsonProperty(value="suppressInQueueCallRecording")
    public Boolean getSuppressInQueueCallRecording() {
        return this.suppressInQueueCallRecording;
    }

    public void setSuppressInQueueCallRecording(Boolean suppressInQueueCallRecording) {
        this.suppressInQueueCallRecording = suppressInQueueCallRecording;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueueRequest queueRequest = (QueueRequest)o;
        return Objects.equals(this.id, queueRequest.id) && Objects.equals(this.name, queueRequest.name) && Objects.equals(this.division, queueRequest.division) && Objects.equals(this.description, queueRequest.description) && Objects.equals(this.dateCreated, queueRequest.dateCreated) && Objects.equals(this.dateModified, queueRequest.dateModified) && Objects.equals(this.modifiedBy, queueRequest.modifiedBy) && Objects.equals(this.createdBy, queueRequest.createdBy) && Objects.equals(this.memberCount, queueRequest.memberCount) && Objects.equals(this.userMemberCount, queueRequest.userMemberCount) && Objects.equals(this.joinedMemberCount, queueRequest.joinedMemberCount) && Objects.equals(this.mediaSettings, queueRequest.mediaSettings) && Objects.equals(this.routingRules, queueRequest.routingRules) && Objects.equals(this.conditionalGroupRouting, queueRequest.conditionalGroupRouting) && Objects.equals(this.bullseye, queueRequest.bullseye) && Objects.equals((Object)this.scoringMethod, (Object)queueRequest.scoringMethod) && Objects.equals((Object)this.lastAgentRoutingMode, (Object)queueRequest.lastAgentRoutingMode) && Objects.equals(this.acwSettings, queueRequest.acwSettings) && Objects.equals((Object)this.skillEvaluationMethod, (Object)queueRequest.skillEvaluationMethod) && Objects.equals(this.memberGroups, queueRequest.memberGroups) && Objects.equals(this.queueFlow, queueRequest.queueFlow) && Objects.equals(this.emailInQueueFlow, queueRequest.emailInQueueFlow) && Objects.equals(this.messageInQueueFlow, queueRequest.messageInQueueFlow) && Objects.equals(this.whisperPrompt, queueRequest.whisperPrompt) && Objects.equals(this.onHoldPrompt, queueRequest.onHoldPrompt) && Objects.equals(this.autoAnswerOnly, queueRequest.autoAnswerOnly) && Objects.equals(this.cannedResponseLibraries, queueRequest.cannedResponseLibraries) && Objects.equals(this.enableTranscription, queueRequest.enableTranscription) && Objects.equals(this.enableAudioMonitoring, queueRequest.enableAudioMonitoring) && Objects.equals(this.enableManualAssignment, queueRequest.enableManualAssignment) && Objects.equals(this.agentOwnedRouting, queueRequest.agentOwnedRouting) && Objects.equals(this.directRouting, queueRequest.directRouting) && Objects.equals(this.callingPartyName, queueRequest.callingPartyName) && Objects.equals(this.callingPartyNumber, queueRequest.callingPartyNumber) && Objects.equals(this.defaultScripts, queueRequest.defaultScripts) && Objects.equals(this.outboundMessagingAddresses, queueRequest.outboundMessagingAddresses) && Objects.equals(this.outboundEmailAddress, queueRequest.outboundEmailAddress) && Objects.equals(this.peerId, queueRequest.peerId) && Objects.equals(this.suppressInQueueCallRecording, queueRequest.suppressInQueueCallRecording) && Objects.equals(this.selfUri, queueRequest.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.division, this.description, this.dateCreated, this.dateModified, this.modifiedBy, this.createdBy, this.memberCount, this.userMemberCount, this.joinedMemberCount, this.mediaSettings, this.routingRules, this.conditionalGroupRouting, this.bullseye, this.scoringMethod, this.lastAgentRoutingMode, this.acwSettings, this.skillEvaluationMethod, this.memberGroups, this.queueFlow, this.emailInQueueFlow, this.messageInQueueFlow, this.whisperPrompt, this.onHoldPrompt, this.autoAnswerOnly, this.cannedResponseLibraries, this.enableTranscription, this.enableAudioMonitoring, this.enableManualAssignment, this.agentOwnedRouting, this.directRouting, this.callingPartyName, this.callingPartyNumber, this.defaultScripts, this.outboundMessagingAddresses, this.outboundEmailAddress, this.peerId, this.suppressInQueueCallRecording, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QueueRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    division: ").append(this.toIndentedString(this.division)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    modifiedBy: ").append(this.toIndentedString(this.modifiedBy)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    memberCount: ").append(this.toIndentedString(this.memberCount)).append("\n");
        sb.append("    userMemberCount: ").append(this.toIndentedString(this.userMemberCount)).append("\n");
        sb.append("    joinedMemberCount: ").append(this.toIndentedString(this.joinedMemberCount)).append("\n");
        sb.append("    mediaSettings: ").append(this.toIndentedString(this.mediaSettings)).append("\n");
        sb.append("    routingRules: ").append(this.toIndentedString(this.routingRules)).append("\n");
        sb.append("    conditionalGroupRouting: ").append(this.toIndentedString(this.conditionalGroupRouting)).append("\n");
        sb.append("    bullseye: ").append(this.toIndentedString(this.bullseye)).append("\n");
        sb.append("    scoringMethod: ").append(this.toIndentedString((Object)this.scoringMethod)).append("\n");
        sb.append("    lastAgentRoutingMode: ").append(this.toIndentedString((Object)this.lastAgentRoutingMode)).append("\n");
        sb.append("    acwSettings: ").append(this.toIndentedString(this.acwSettings)).append("\n");
        sb.append("    skillEvaluationMethod: ").append(this.toIndentedString((Object)this.skillEvaluationMethod)).append("\n");
        sb.append("    memberGroups: ").append(this.toIndentedString(this.memberGroups)).append("\n");
        sb.append("    queueFlow: ").append(this.toIndentedString(this.queueFlow)).append("\n");
        sb.append("    emailInQueueFlow: ").append(this.toIndentedString(this.emailInQueueFlow)).append("\n");
        sb.append("    messageInQueueFlow: ").append(this.toIndentedString(this.messageInQueueFlow)).append("\n");
        sb.append("    whisperPrompt: ").append(this.toIndentedString(this.whisperPrompt)).append("\n");
        sb.append("    onHoldPrompt: ").append(this.toIndentedString(this.onHoldPrompt)).append("\n");
        sb.append("    autoAnswerOnly: ").append(this.toIndentedString(this.autoAnswerOnly)).append("\n");
        sb.append("    cannedResponseLibraries: ").append(this.toIndentedString(this.cannedResponseLibraries)).append("\n");
        sb.append("    enableTranscription: ").append(this.toIndentedString(this.enableTranscription)).append("\n");
        sb.append("    enableAudioMonitoring: ").append(this.toIndentedString(this.enableAudioMonitoring)).append("\n");
        sb.append("    enableManualAssignment: ").append(this.toIndentedString(this.enableManualAssignment)).append("\n");
        sb.append("    agentOwnedRouting: ").append(this.toIndentedString(this.agentOwnedRouting)).append("\n");
        sb.append("    directRouting: ").append(this.toIndentedString(this.directRouting)).append("\n");
        sb.append("    callingPartyName: ").append(this.toIndentedString(this.callingPartyName)).append("\n");
        sb.append("    callingPartyNumber: ").append(this.toIndentedString(this.callingPartyNumber)).append("\n");
        sb.append("    defaultScripts: ").append(this.toIndentedString(this.defaultScripts)).append("\n");
        sb.append("    outboundMessagingAddresses: ").append(this.toIndentedString(this.outboundMessagingAddresses)).append("\n");
        sb.append("    outboundEmailAddress: ").append(this.toIndentedString(this.outboundEmailAddress)).append("\n");
        sb.append("    peerId: ").append(this.toIndentedString(this.peerId)).append("\n");
        sb.append("    suppressInQueueCallRecording: ").append(this.toIndentedString(this.suppressInQueueCallRecording)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ScoringMethodEnumDeserializer.class)
    public static enum ScoringMethodEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        TIMESTAMPANDPRIORITY("TimestampAndPriority"),
        PRIORITYONLY("PriorityOnly");

        private String value;

        private ScoringMethodEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ScoringMethodEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ScoringMethodEnum value : ScoringMethodEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ScoringMethodEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=LastAgentRoutingModeEnumDeserializer.class)
    public static enum LastAgentRoutingModeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        DISABLED("Disabled"),
        QUEUEMEMBERSONLY("QueueMembersOnly"),
        ANYAGENT("AnyAgent");

        private String value;

        private LastAgentRoutingModeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static LastAgentRoutingModeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (LastAgentRoutingModeEnum value : LastAgentRoutingModeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return LastAgentRoutingModeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=SkillEvaluationMethodEnumDeserializer.class)
    public static enum SkillEvaluationMethodEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        NONE("NONE"),
        BEST("BEST"),
        ALL("ALL");

        private String value;

        private SkillEvaluationMethodEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SkillEvaluationMethodEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SkillEvaluationMethodEnum value : SkillEvaluationMethodEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SkillEvaluationMethodEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class SkillEvaluationMethodEnumDeserializer
    extends StdDeserializer<SkillEvaluationMethodEnum> {
        public SkillEvaluationMethodEnumDeserializer() {
            super(SkillEvaluationMethodEnumDeserializer.class);
        }

        public SkillEvaluationMethodEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SkillEvaluationMethodEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class LastAgentRoutingModeEnumDeserializer
    extends StdDeserializer<LastAgentRoutingModeEnum> {
        public LastAgentRoutingModeEnumDeserializer() {
            super(LastAgentRoutingModeEnumDeserializer.class);
        }

        public LastAgentRoutingModeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return LastAgentRoutingModeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class ScoringMethodEnumDeserializer
    extends StdDeserializer<ScoringMethodEnum> {
        public ScoringMethodEnumDeserializer() {
            super(ScoringMethodEnumDeserializer.class);
        }

        public ScoringMethodEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ScoringMethodEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

