/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class MessageMediaAttachment
implements Serializable {
    private String url = null;
    private MediaTypeEnum mediaType = null;
    private Long contentLength = null;
    private String name = null;
    private String id = null;

    public MessageMediaAttachment() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public MessageMediaAttachment url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(example="null", value="The location of the media, useful for retrieving it")
    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public MessageMediaAttachment mediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    @ApiModelProperty(example="null", value="The optional internet media type of the the media object.If null then the media type should be dictated by the url.")
    @JsonProperty(value="mediaType")
    public MediaTypeEnum getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
    }

    public MessageMediaAttachment contentLength(Long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    @ApiModelProperty(example="null", value="The optional content length of the the media object, in bytes.")
    @JsonProperty(value="contentLength")
    public Long getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(Long contentLength) {
        this.contentLength = contentLength;
    }

    public MessageMediaAttachment name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of the media object.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MessageMediaAttachment id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="A globally unique identifier for the media object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageMediaAttachment messageMediaAttachment = (MessageMediaAttachment)o;
        return Objects.equals(this.url, messageMediaAttachment.url) && Objects.equals((Object)this.mediaType, (Object)messageMediaAttachment.mediaType) && Objects.equals(this.contentLength, messageMediaAttachment.contentLength) && Objects.equals(this.name, messageMediaAttachment.name) && Objects.equals(this.id, messageMediaAttachment.id);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.url, this.mediaType, this.contentLength, this.name, this.id});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MessageMediaAttachment {\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    mediaType: ").append(this.toIndentedString((Object)this.mediaType)).append("\n");
        sb.append("    contentLength: ").append(this.toIndentedString(this.contentLength)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=MediaTypeEnumDeserializer.class)
    public static enum MediaTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        IMAGE_PNG("image/png"),
        IMAGE_JPEG("image/jpeg"),
        IMAGE_GIF("image/gif");

        private String value;

        private MediaTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MediaTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MediaTypeEnum value : MediaTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MediaTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MediaTypeEnumDeserializer
    extends StdDeserializer<MediaTypeEnum> {
        public MediaTypeEnumDeserializer() {
            super(MediaTypeEnumDeserializer.class);
        }

        public MediaTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MediaTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

