/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

public class Faq
implements Serializable {
    private String question = null;
    private String answer = null;
    private String sourceUri = null;
    private String documentUrl = null;
    private String documentDisplayName = null;
    private Float confidence = null;

    public Faq() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="Question from the knowledge base that was matched to user request.")
    @JsonProperty(value="question")
    public String getQuestion() {
        return this.question;
    }

    @ApiModelProperty(example="null", value="Answer from the knowledge base corresponding to the identified question.")
    @JsonProperty(value="answer")
    public String getAnswer() {
        return this.answer;
    }

    @ApiModelProperty(example="null", value="A URI uniquely identifying the document, e.g. projects/acme-inc/knowledgeBases/MTAyNjgxNDU1Nzc3NTM1NzU0MjQ/documents/MTI5ODc3NzQzOTQ5MTc5NzgxMTI.")
    @JsonProperty(value="sourceUri")
    public String getSourceUri() {
        return this.sourceUri;
    }

    @ApiModelProperty(example="null", value="URL pointing to a web page if document was sourced from a URL.")
    @JsonProperty(value="documentUrl")
    public String getDocumentUrl() {
        return this.documentUrl;
    }

    @ApiModelProperty(example="null", value="A human-readable description of the document, e.g. 'Sample store FAQ'")
    @JsonProperty(value="documentDisplayName")
    public String getDocumentDisplayName() {
        return this.documentDisplayName;
    }

    @ApiModelProperty(example="null", value="Value between 0 and 1. 1 corresponds to very confident, 0 to not confident at all")
    @JsonProperty(value="confidence")
    public Float getConfidence() {
        return this.confidence;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Faq faq = (Faq)o;
        return Objects.equals(this.question, faq.question) && Objects.equals(this.answer, faq.answer) && Objects.equals(this.sourceUri, faq.sourceUri) && Objects.equals(this.documentUrl, faq.documentUrl) && Objects.equals(this.documentDisplayName, faq.documentDisplayName) && Objects.equals(this.confidence, faq.confidence);
    }

    public int hashCode() {
        return Objects.hash(this.question, this.answer, this.sourceUri, this.documentUrl, this.documentDisplayName, this.confidence);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Faq {\n");
        sb.append("    question: ").append(this.toIndentedString(this.question)).append("\n");
        sb.append("    answer: ").append(this.toIndentedString(this.answer)).append("\n");
        sb.append("    sourceUri: ").append(this.toIndentedString(this.sourceUri)).append("\n");
        sb.append("    documentUrl: ").append(this.toIndentedString(this.documentUrl)).append("\n");
        sb.append("    documentDisplayName: ").append(this.toIndentedString(this.documentDisplayName)).append("\n");
        sb.append("    confidence: ").append(this.toIndentedString(this.confidence)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

