/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.DecisionTableRowEntityRef;
import com.mypurecloud.sdk.v2.model.DecisionTableRowExecutionOutput;
import com.mypurecloud.sdk.v2.model.DecisionTableVersionEntity;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DecisionTableExecutionResponse
implements Serializable {
    private DecisionTableVersionEntity table = null;
    private Integer totalMatchRowCount = null;
    private List<DecisionTableRowEntityRef> topMatchRows = null;
    private List<DecisionTableRowExecutionOutput> rowExecutionOutputs = null;

    public DecisionTableExecutionResponse() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.topMatchRows = new ArrayList<DecisionTableRowEntityRef>();
            this.rowExecutionOutputs = new ArrayList<DecisionTableRowExecutionOutput>();
        }
    }

    public DecisionTableExecutionResponse table(DecisionTableVersionEntity table) {
        this.table = table;
        return this;
    }

    @ApiModelProperty(example="null", value="The decision table version entity that was executed.")
    @JsonProperty(value="table")
    public DecisionTableVersionEntity getTable() {
        return this.table;
    }

    public void setTable(DecisionTableVersionEntity table) {
        this.table = table;
    }

    public DecisionTableExecutionResponse totalMatchRowCount(Integer totalMatchRowCount) {
        this.totalMatchRowCount = totalMatchRowCount;
        return this;
    }

    @ApiModelProperty(example="null", value="Total number of rows that matched execution input and would return results")
    @JsonProperty(value="totalMatchRowCount")
    public Integer getTotalMatchRowCount() {
        return this.totalMatchRowCount;
    }

    public void setTotalMatchRowCount(Integer totalMatchRowCount) {
        this.totalMatchRowCount = totalMatchRowCount;
    }

    public DecisionTableExecutionResponse topMatchRows(List<DecisionTableRowEntityRef> topMatchRows) {
        this.topMatchRows = topMatchRows;
        return this;
    }

    @ApiModelProperty(example="null", value="Top 5 rows matching execution input, excluding the one produced the result.")
    @JsonProperty(value="topMatchRows")
    public List<DecisionTableRowEntityRef> getTopMatchRows() {
        return this.topMatchRows;
    }

    public void setTopMatchRows(List<DecisionTableRowEntityRef> topMatchRows) {
        this.topMatchRows = topMatchRows;
    }

    public DecisionTableExecutionResponse rowExecutionOutputs(List<DecisionTableRowExecutionOutput> rowExecutionOutputs) {
        this.rowExecutionOutputs = rowExecutionOutputs;
        return this;
    }

    @ApiModelProperty(example="null", value="The output data for each executed row for which output is collected.")
    @JsonProperty(value="rowExecutionOutputs")
    public List<DecisionTableRowExecutionOutput> getRowExecutionOutputs() {
        return this.rowExecutionOutputs;
    }

    public void setRowExecutionOutputs(List<DecisionTableRowExecutionOutput> rowExecutionOutputs) {
        this.rowExecutionOutputs = rowExecutionOutputs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecisionTableExecutionResponse decisionTableExecutionResponse = (DecisionTableExecutionResponse)o;
        return Objects.equals(this.table, decisionTableExecutionResponse.table) && Objects.equals(this.totalMatchRowCount, decisionTableExecutionResponse.totalMatchRowCount) && Objects.equals(this.topMatchRows, decisionTableExecutionResponse.topMatchRows) && Objects.equals(this.rowExecutionOutputs, decisionTableExecutionResponse.rowExecutionOutputs);
    }

    public int hashCode() {
        return Objects.hash(this.table, this.totalMatchRowCount, this.topMatchRows, this.rowExecutionOutputs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DecisionTableExecutionResponse {\n");
        sb.append("    table: ").append(this.toIndentedString(this.table)).append("\n");
        sb.append("    totalMatchRowCount: ").append(this.toIndentedString(this.totalMatchRowCount)).append("\n");
        sb.append("    topMatchRows: ").append(this.toIndentedString(this.topMatchRows)).append("\n");
        sb.append("    rowExecutionOutputs: ").append(this.toIndentedString(this.rowExecutionOutputs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

