/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.NamedEntity;
import com.mypurecloud.sdk.v2.model.OrgOAuthClient;
import com.mypurecloud.sdk.v2.model.TokenInfoClonedUser;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class TokenInfo
implements Serializable {
    private NamedEntity organization = null;
    private NamedEntity homeOrganization = null;
    private List<String> authorizedScope = null;
    private TokenInfoClonedUser clonedUser = null;
    private OrgOAuthClient oAuthClient = null;

    public TokenInfo() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.authorizedScope = new ArrayList<String>();
        }
    }

    @ApiModelProperty(example="null", value="The current organization")
    @JsonProperty(value="organization")
    public NamedEntity getOrganization() {
        return this.organization;
    }

    @ApiModelProperty(example="null", value="The token's home organization")
    @JsonProperty(value="homeOrganization")
    public NamedEntity getHomeOrganization() {
        return this.homeOrganization;
    }

    @ApiModelProperty(example="null", value="The list of scopes authorized for the OAuth client")
    @JsonProperty(value="authorizedScope")
    public List<String> getAuthorizedScope() {
        return this.authorizedScope;
    }

    @ApiModelProperty(example="null", value="Only present when a user is a clone of trustee user in the trustor org.")
    @JsonProperty(value="clonedUser")
    public TokenInfoClonedUser getClonedUser() {
        return this.clonedUser;
    }

    public TokenInfo oAuthClient(OrgOAuthClient oAuthClient) {
        this.oAuthClient = oAuthClient;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="OAuthClient")
    public OrgOAuthClient getOAuthClient() {
        return this.oAuthClient;
    }

    public void setOAuthClient(OrgOAuthClient oAuthClient) {
        this.oAuthClient = oAuthClient;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenInfo tokenInfo = (TokenInfo)o;
        return Objects.equals(this.organization, tokenInfo.organization) && Objects.equals(this.homeOrganization, tokenInfo.homeOrganization) && Objects.equals(this.authorizedScope, tokenInfo.authorizedScope) && Objects.equals(this.clonedUser, tokenInfo.clonedUser) && Objects.equals(this.oAuthClient, tokenInfo.oAuthClient);
    }

    public int hashCode() {
        return Objects.hash(this.organization, this.homeOrganization, this.authorizedScope, this.clonedUser, this.oAuthClient);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TokenInfo {\n");
        sb.append("    organization: ").append(this.toIndentedString(this.organization)).append("\n");
        sb.append("    homeOrganization: ").append(this.toIndentedString(this.homeOrganization)).append("\n");
        sb.append("    authorizedScope: ").append(this.toIndentedString(this.authorizedScope)).append("\n");
        sb.append("    clonedUser: ").append(this.toIndentedString(this.clonedUser)).append("\n");
        sb.append("    oAuthClient: ").append(this.toIndentedString(this.oAuthClient)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

