/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

public class SourceConfiguration
implements Serializable {
    private String sourceId = null;
    private String interactionId = null;
    private String tagId = null;

    public SourceConfiguration() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public SourceConfiguration sourceId(String sourceId) {
        this.sourceId = sourceId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Identifies the external platform that is the source of the conversation.")
    @JsonProperty(value="sourceId")
    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public SourceConfiguration interactionId(String interactionId) {
        this.interactionId = interactionId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The customer's unique external identifier associated with the conversation that comes from the external platform.")
    @JsonProperty(value="interactionId")
    public String getInteractionId() {
        return this.interactionId;
    }

    public void setInteractionId(String interactionId) {
        this.interactionId = interactionId;
    }

    public SourceConfiguration tagId(String tagId) {
        this.tagId = tagId;
        return this;
    }

    @ApiModelProperty(example="null", value="The customer's external identifier or tag associated with the conversation. If set, it will be used to tag the conversation.")
    @JsonProperty(value="tagId")
    public String getTagId() {
        return this.tagId;
    }

    public void setTagId(String tagId) {
        this.tagId = tagId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceConfiguration sourceConfiguration = (SourceConfiguration)o;
        return Objects.equals(this.sourceId, sourceConfiguration.sourceId) && Objects.equals(this.interactionId, sourceConfiguration.interactionId) && Objects.equals(this.tagId, sourceConfiguration.tagId);
    }

    public int hashCode() {
        return Objects.hash(this.sourceId, this.interactionId, this.tagId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SourceConfiguration {\n");
        sb.append("    sourceId: ").append(this.toIndentedString(this.sourceId)).append("\n");
        sb.append("    interactionId: ").append(this.toIndentedString(this.interactionId)).append("\n");
        sb.append("    tagId: ").append(this.toIndentedString(this.tagId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

