/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

public class PredictorWorkloadBalancing
implements Serializable {
    private Boolean enabled = null;
    private Integer minimumOccupancy = null;
    private Integer maximumOccupancy = null;

    public PredictorWorkloadBalancing() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public PredictorWorkloadBalancing enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Flag to activate and deactivate workload balancing.")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public PredictorWorkloadBalancing minimumOccupancy(Integer minimumOccupancy) {
        this.minimumOccupancy = minimumOccupancy;
        return this;
    }

    @ApiModelProperty(example="null", value="Desired minimum occupancy threshold of agents. Must be between 0 and 100.")
    @JsonProperty(value="minimumOccupancy")
    public Integer getMinimumOccupancy() {
        return this.minimumOccupancy;
    }

    public void setMinimumOccupancy(Integer minimumOccupancy) {
        this.minimumOccupancy = minimumOccupancy;
    }

    public PredictorWorkloadBalancing maximumOccupancy(Integer maximumOccupancy) {
        this.maximumOccupancy = maximumOccupancy;
        return this;
    }

    @ApiModelProperty(example="null", value="Desired maximum occupancy threshold of agents. Must be between 0 and 100.")
    @JsonProperty(value="maximumOccupancy")
    public Integer getMaximumOccupancy() {
        return this.maximumOccupancy;
    }

    public void setMaximumOccupancy(Integer maximumOccupancy) {
        this.maximumOccupancy = maximumOccupancy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PredictorWorkloadBalancing predictorWorkloadBalancing = (PredictorWorkloadBalancing)o;
        return Objects.equals(this.enabled, predictorWorkloadBalancing.enabled) && Objects.equals(this.minimumOccupancy, predictorWorkloadBalancing.minimumOccupancy) && Objects.equals(this.maximumOccupancy, predictorWorkloadBalancing.maximumOccupancy);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.minimumOccupancy, this.maximumOccupancy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PredictorWorkloadBalancing {\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    minimumOccupancy: ").append(this.toIndentedString(this.minimumOccupancy)).append("\n");
        sb.append("    maximumOccupancy: ").append(this.toIndentedString(this.maximumOccupancy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

