/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.MediaIceStatistics;
import com.mypurecloud.sdk.v2.model.MediaRtpStatistics;
import com.mypurecloud.sdk.v2.model.MediaStatisticsTrunkInfo;
import com.mypurecloud.sdk.v2.model.NamedEntity;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

public class MediaEndpointStatistics
implements Serializable {
    private MediaStatisticsTrunkInfo trunk = null;
    private NamedEntity station = null;
    private NamedEntity user = null;
    private MediaIceStatistics ice = null;
    private MediaRtpStatistics rtp = null;
    private Integer reconnectAttemptCount = null;

    public MediaEndpointStatistics() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public MediaEndpointStatistics trunk(MediaStatisticsTrunkInfo trunk) {
        this.trunk = trunk;
        return this;
    }

    @ApiModelProperty(example="null", value="Trunk information utilized when creating the media endpoint")
    @JsonProperty(value="trunk")
    public MediaStatisticsTrunkInfo getTrunk() {
        return this.trunk;
    }

    public void setTrunk(MediaStatisticsTrunkInfo trunk) {
        this.trunk = trunk;
    }

    public MediaEndpointStatistics station(NamedEntity station) {
        this.station = station;
        return this;
    }

    @ApiModelProperty(example="null", value="Station information associated with media endpoint")
    @JsonProperty(value="station")
    public NamedEntity getStation() {
        return this.station;
    }

    public void setStation(NamedEntity station) {
        this.station = station;
    }

    public MediaEndpointStatistics user(NamedEntity user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(example="null", value="User information associated media endpoint")
    @JsonProperty(value="user")
    public NamedEntity getUser() {
        return this.user;
    }

    public void setUser(NamedEntity user) {
        this.user = user;
    }

    public MediaEndpointStatistics ice(MediaIceStatistics ice) {
        this.ice = ice;
        return this;
    }

    @ApiModelProperty(example="null", value="The ICE protocol statistics and details. Reference: https://www.rfc-editor.org/rfc/rfc5245")
    @JsonProperty(value="ice")
    public MediaIceStatistics getIce() {
        return this.ice;
    }

    public void setIce(MediaIceStatistics ice) {
        this.ice = ice;
    }

    public MediaEndpointStatistics rtp(MediaRtpStatistics rtp) {
        this.rtp = rtp;
        return this;
    }

    @ApiModelProperty(example="null", value="Statistics of sent and received RTP. Reference: https://www.rfc-editor.org/rfc/rfc3550")
    @JsonProperty(value="rtp")
    public MediaRtpStatistics getRtp() {
        return this.rtp;
    }

    public void setRtp(MediaRtpStatistics rtp) {
        this.rtp = rtp;
    }

    public MediaEndpointStatistics reconnectAttemptCount(Integer reconnectAttemptCount) {
        this.reconnectAttemptCount = reconnectAttemptCount;
        return this;
    }

    @ApiModelProperty(example="null", value="Media reconnect attempt count")
    @JsonProperty(value="reconnectAttemptCount")
    public Integer getReconnectAttemptCount() {
        return this.reconnectAttemptCount;
    }

    public void setReconnectAttemptCount(Integer reconnectAttemptCount) {
        this.reconnectAttemptCount = reconnectAttemptCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaEndpointStatistics mediaEndpointStatistics = (MediaEndpointStatistics)o;
        return Objects.equals(this.trunk, mediaEndpointStatistics.trunk) && Objects.equals(this.station, mediaEndpointStatistics.station) && Objects.equals(this.user, mediaEndpointStatistics.user) && Objects.equals(this.ice, mediaEndpointStatistics.ice) && Objects.equals(this.rtp, mediaEndpointStatistics.rtp) && Objects.equals(this.reconnectAttemptCount, mediaEndpointStatistics.reconnectAttemptCount);
    }

    public int hashCode() {
        return Objects.hash(this.trunk, this.station, this.user, this.ice, this.rtp, this.reconnectAttemptCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MediaEndpointStatistics {\n");
        sb.append("    trunk: ").append(this.toIndentedString(this.trunk)).append("\n");
        sb.append("    station: ").append(this.toIndentedString(this.station)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    ice: ").append(this.toIndentedString(this.ice)).append("\n");
        sb.append("    rtp: ").append(this.toIndentedString(this.rtp)).append("\n");
        sb.append("    reconnectAttemptCount: ").append(this.toIndentedString(this.reconnectAttemptCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

