/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AssessmentForm;
import com.mypurecloud.sdk.v2.model.LearningAssessment;
import com.mypurecloud.sdk.v2.model.LearningAssignmentStep;
import com.mypurecloud.sdk.v2.model.LearningModule;
import com.mypurecloud.sdk.v2.model.UserReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Learning module assignment with user information")
public class LearningAssignment
implements Serializable {
    private String id = null;
    private LearningAssessment assessment = null;
    private UserReference createdBy = null;
    private Date dateCreated = null;
    private UserReference modifiedBy = null;
    private Date dateModified = null;
    private Boolean isOverdue = null;
    private Float percentageScore = null;
    private Float assessmentPercentageScore = null;
    private Boolean isRule = null;
    private Boolean isManual = null;
    private Boolean isPassed = null;
    private Boolean isLatest = null;
    private Float assessmentCompletionPercentage = null;
    private Float completionPercentage = null;
    private List<LearningAssignmentStep> steps = null;
    private LearningAssignmentStep nextStep = null;
    private String selfUri = null;
    private StateEnum state = null;
    private Date dateRecommendedForCompletion = null;
    private Integer version = null;
    private LearningModule module = null;
    private UserReference user = null;
    private AssessmentForm assessmentForm = null;
    private Integer lengthInMinutes = null;

    public LearningAssignment() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.steps = new ArrayList<LearningAssignmentStep>();
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public LearningAssignment assessment(LearningAssessment assessment) {
        this.assessment = assessment;
        return this;
    }

    @ApiModelProperty(example="null", value="The assessment associated with this assignment")
    @JsonProperty(value="assessment")
    public LearningAssessment getAssessment() {
        return this.assessment;
    }

    public void setAssessment(LearningAssessment assessment) {
        this.assessment = assessment;
    }

    @ApiModelProperty(example="null", value="The user who created the assignment")
    @JsonProperty(value="createdBy")
    public UserReference getCreatedBy() {
        return this.createdBy;
    }

    @ApiModelProperty(example="null", value="The date when the assignment was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="The user who modified the assignment")
    @JsonProperty(value="modifiedBy")
    public UserReference getModifiedBy() {
        return this.modifiedBy;
    }

    @ApiModelProperty(example="null", value="The date when the assignment was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    @ApiModelProperty(example="null", value="True if the assignment is overdue")
    @JsonProperty(value="isOverdue")
    public Boolean getIsOverdue() {
        return this.isOverdue;
    }

    @ApiModelProperty(example="null", value="The user's percentage score for this assignment")
    @JsonProperty(value="percentageScore")
    public Float getPercentageScore() {
        return this.percentageScore;
    }

    @ApiModelProperty(example="null", value="The user's percentage score for this assignment's assessment")
    @JsonProperty(value="assessmentPercentageScore")
    public Float getAssessmentPercentageScore() {
        return this.assessmentPercentageScore;
    }

    @ApiModelProperty(example="null", value="True if this assignment was created by a Rule")
    @JsonProperty(value="isRule")
    public Boolean getIsRule() {
        return this.isRule;
    }

    @ApiModelProperty(example="null", value="True if this assignment was created manually")
    @JsonProperty(value="isManual")
    public Boolean getIsManual() {
        return this.isManual;
    }

    @ApiModelProperty(example="null", value="True if the assessment was passed")
    @JsonProperty(value="isPassed")
    public Boolean getIsPassed() {
        return this.isPassed;
    }

    @ApiModelProperty(example="null", value="True if the assignment is based on latest module")
    @JsonProperty(value="isLatest")
    public Boolean getIsLatest() {
        return this.isLatest;
    }

    @ApiModelProperty(example="null", value="The assessment completion percentage of assignment")
    @JsonProperty(value="assessmentCompletionPercentage")
    public Float getAssessmentCompletionPercentage() {
        return this.assessmentCompletionPercentage;
    }

    @ApiModelProperty(example="null", value="The overall completion percentage of assignment")
    @JsonProperty(value="completionPercentage")
    public Float getCompletionPercentage() {
        return this.completionPercentage;
    }

    @ApiModelProperty(example="null", value="List of assignment steps")
    @JsonProperty(value="steps")
    public List<LearningAssignmentStep> getSteps() {
        return this.steps;
    }

    @ApiModelProperty(example="null", value="The next assignment step")
    @JsonProperty(value="nextStep")
    public LearningAssignmentStep getNextStep() {
        return this.nextStep;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public LearningAssignment state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="The Learning Assignment state")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public LearningAssignment dateRecommendedForCompletion(Date dateRecommendedForCompletion) {
        this.dateRecommendedForCompletion = dateRecommendedForCompletion;
        return this;
    }

    @ApiModelProperty(example="null", value="The recommended completion date of the assignment. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateRecommendedForCompletion")
    public Date getDateRecommendedForCompletion() {
        return this.dateRecommendedForCompletion;
    }

    public void setDateRecommendedForCompletion(Date dateRecommendedForCompletion) {
        this.dateRecommendedForCompletion = dateRecommendedForCompletion;
    }

    public LearningAssignment version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", value="The version of Learning module assigned")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public LearningAssignment module(LearningModule module) {
        this.module = module;
        return this;
    }

    @ApiModelProperty(example="null", value="The Learning module object associated with this assignment")
    @JsonProperty(value="module")
    public LearningModule getModule() {
        return this.module;
    }

    public void setModule(LearningModule module) {
        this.module = module;
    }

    public LearningAssignment user(UserReference user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(example="null", value="The user to whom the assignment is assigned")
    @JsonProperty(value="user")
    public UserReference getUser() {
        return this.user;
    }

    public void setUser(UserReference user) {
        this.user = user;
    }

    public LearningAssignment assessmentForm(AssessmentForm assessmentForm) {
        this.assessmentForm = assessmentForm;
        return this;
    }

    @ApiModelProperty(example="null", value="The assessment form associated with this assignment")
    @JsonProperty(value="assessmentForm")
    public AssessmentForm getAssessmentForm() {
        return this.assessmentForm;
    }

    public void setAssessmentForm(AssessmentForm assessmentForm) {
        this.assessmentForm = assessmentForm;
    }

    public LearningAssignment lengthInMinutes(Integer lengthInMinutes) {
        this.lengthInMinutes = lengthInMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="The length in minutes of the assignment")
    @JsonProperty(value="lengthInMinutes")
    public Integer getLengthInMinutes() {
        return this.lengthInMinutes;
    }

    public void setLengthInMinutes(Integer lengthInMinutes) {
        this.lengthInMinutes = lengthInMinutes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LearningAssignment learningAssignment = (LearningAssignment)o;
        return Objects.equals(this.id, learningAssignment.id) && Objects.equals(this.assessment, learningAssignment.assessment) && Objects.equals(this.createdBy, learningAssignment.createdBy) && Objects.equals(this.dateCreated, learningAssignment.dateCreated) && Objects.equals(this.modifiedBy, learningAssignment.modifiedBy) && Objects.equals(this.dateModified, learningAssignment.dateModified) && Objects.equals(this.isOverdue, learningAssignment.isOverdue) && Objects.equals(this.percentageScore, learningAssignment.percentageScore) && Objects.equals(this.assessmentPercentageScore, learningAssignment.assessmentPercentageScore) && Objects.equals(this.isRule, learningAssignment.isRule) && Objects.equals(this.isManual, learningAssignment.isManual) && Objects.equals(this.isPassed, learningAssignment.isPassed) && Objects.equals(this.isLatest, learningAssignment.isLatest) && Objects.equals(this.assessmentCompletionPercentage, learningAssignment.assessmentCompletionPercentage) && Objects.equals(this.completionPercentage, learningAssignment.completionPercentage) && Objects.equals(this.steps, learningAssignment.steps) && Objects.equals(this.nextStep, learningAssignment.nextStep) && Objects.equals(this.selfUri, learningAssignment.selfUri) && Objects.equals((Object)this.state, (Object)learningAssignment.state) && Objects.equals(this.dateRecommendedForCompletion, learningAssignment.dateRecommendedForCompletion) && Objects.equals(this.version, learningAssignment.version) && Objects.equals(this.module, learningAssignment.module) && Objects.equals(this.user, learningAssignment.user) && Objects.equals(this.assessmentForm, learningAssignment.assessmentForm) && Objects.equals(this.lengthInMinutes, learningAssignment.lengthInMinutes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.assessment, this.createdBy, this.dateCreated, this.modifiedBy, this.dateModified, this.isOverdue, this.percentageScore, this.assessmentPercentageScore, this.isRule, this.isManual, this.isPassed, this.isLatest, this.assessmentCompletionPercentage, this.completionPercentage, this.steps, this.nextStep, this.selfUri, this.state, this.dateRecommendedForCompletion, this.version, this.module, this.user, this.assessmentForm, this.lengthInMinutes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LearningAssignment {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    assessment: ").append(this.toIndentedString(this.assessment)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    modifiedBy: ").append(this.toIndentedString(this.modifiedBy)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    isOverdue: ").append(this.toIndentedString(this.isOverdue)).append("\n");
        sb.append("    percentageScore: ").append(this.toIndentedString(this.percentageScore)).append("\n");
        sb.append("    assessmentPercentageScore: ").append(this.toIndentedString(this.assessmentPercentageScore)).append("\n");
        sb.append("    isRule: ").append(this.toIndentedString(this.isRule)).append("\n");
        sb.append("    isManual: ").append(this.toIndentedString(this.isManual)).append("\n");
        sb.append("    isPassed: ").append(this.toIndentedString(this.isPassed)).append("\n");
        sb.append("    isLatest: ").append(this.toIndentedString(this.isLatest)).append("\n");
        sb.append("    assessmentCompletionPercentage: ").append(this.toIndentedString(this.assessmentCompletionPercentage)).append("\n");
        sb.append("    completionPercentage: ").append(this.toIndentedString(this.completionPercentage)).append("\n");
        sb.append("    steps: ").append(this.toIndentedString(this.steps)).append("\n");
        sb.append("    nextStep: ").append(this.toIndentedString(this.nextStep)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    dateRecommendedForCompletion: ").append(this.toIndentedString(this.dateRecommendedForCompletion)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    module: ").append(this.toIndentedString(this.module)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    assessmentForm: ").append(this.toIndentedString(this.assessmentForm)).append("\n");
        sb.append("    lengthInMinutes: ").append(this.toIndentedString(this.lengthInMinutes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ASSIGNED("Assigned"),
        INPROGRESS("InProgress"),
        COMPLETED("Completed"),
        DELETED("Deleted"),
        NOTCOMPLETED("NotCompleted"),
        INVALIDSCHEDULE("InvalidSchedule");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

