/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AssessmentScoringSet;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class LearningAssessment
implements Serializable {
    private String assessmentId = null;
    private String contextId = null;
    private String assessmentFormId = null;
    private StatusEnum status = null;
    private AssessmentScoringSet answers = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private Date dateSubmitted = null;

    public LearningAssessment() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="The Id of the assessment")
    @JsonProperty(value="assessmentId")
    public String getAssessmentId() {
        return this.assessmentId;
    }

    @ApiModelProperty(example="null", value="The context Id of the related assessment form")
    @JsonProperty(value="contextId")
    public String getContextId() {
        return this.contextId;
    }

    @ApiModelProperty(example="null", value="The Id of the related assessment form")
    @JsonProperty(value="assessmentFormId")
    public String getAssessmentFormId() {
        return this.assessmentFormId;
    }

    @ApiModelProperty(example="null", value="Status of the assessment")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public LearningAssessment answers(AssessmentScoringSet answers) {
        this.answers = answers;
        return this;
    }

    @ApiModelProperty(example="null", value="Answers for the assessment")
    @JsonProperty(value="answers")
    public AssessmentScoringSet getAnswers() {
        return this.answers;
    }

    public void setAnswers(AssessmentScoringSet answers) {
        this.answers = answers;
    }

    @ApiModelProperty(example="null", value="Date the assessment was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="Date the assessment was last updated. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    @ApiModelProperty(example="null", value="Date the assessment was submitted. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateSubmitted")
    public Date getDateSubmitted() {
        return this.dateSubmitted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LearningAssessment learningAssessment = (LearningAssessment)o;
        return Objects.equals(this.assessmentId, learningAssessment.assessmentId) && Objects.equals(this.contextId, learningAssessment.contextId) && Objects.equals(this.assessmentFormId, learningAssessment.assessmentFormId) && Objects.equals((Object)this.status, (Object)learningAssessment.status) && Objects.equals(this.answers, learningAssessment.answers) && Objects.equals(this.dateCreated, learningAssessment.dateCreated) && Objects.equals(this.dateModified, learningAssessment.dateModified) && Objects.equals(this.dateSubmitted, learningAssessment.dateSubmitted);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.assessmentId, this.contextId, this.assessmentFormId, this.status, this.answers, this.dateCreated, this.dateModified, this.dateSubmitted});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LearningAssessment {\n");
        sb.append("    assessmentId: ").append(this.toIndentedString(this.assessmentId)).append("\n");
        sb.append("    contextId: ").append(this.toIndentedString(this.contextId)).append("\n");
        sb.append("    assessmentFormId: ").append(this.toIndentedString(this.assessmentFormId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    answers: ").append(this.toIndentedString(this.answers)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    dateSubmitted: ").append(this.toIndentedString(this.dateSubmitted)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PENDING("Pending"),
        INPROGRESS("InProgress"),
        FINISHED("Finished");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

