/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class GrammarLanguageFileMetadata
implements Serializable {
    private String fileName = null;
    private Integer fileSizeBytes = null;
    private Date dateUploaded = null;
    private FileTypeEnum fileType = null;

    public GrammarLanguageFileMetadata() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public GrammarLanguageFileMetadata fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of the file as defined by the user")
    @JsonProperty(value="fileName")
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public GrammarLanguageFileMetadata fileSizeBytes(Integer fileSizeBytes) {
        this.fileSizeBytes = fileSizeBytes;
        return this;
    }

    @ApiModelProperty(example="null", value="The size of the file in bytes")
    @JsonProperty(value="fileSizeBytes")
    public Integer getFileSizeBytes() {
        return this.fileSizeBytes;
    }

    public void setFileSizeBytes(Integer fileSizeBytes) {
        this.fileSizeBytes = fileSizeBytes;
    }

    public GrammarLanguageFileMetadata dateUploaded(Date dateUploaded) {
        this.dateUploaded = dateUploaded;
        return this;
    }

    @ApiModelProperty(example="null", value="The date the file was uploaded. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateUploaded")
    public Date getDateUploaded() {
        return this.dateUploaded;
    }

    public void setDateUploaded(Date dateUploaded) {
        this.dateUploaded = dateUploaded;
    }

    public GrammarLanguageFileMetadata fileType(FileTypeEnum fileType) {
        this.fileType = fileType;
        return this;
    }

    @ApiModelProperty(example="null", value="The extension of the file")
    @JsonProperty(value="fileType")
    public FileTypeEnum getFileType() {
        return this.fileType;
    }

    public void setFileType(FileTypeEnum fileType) {
        this.fileType = fileType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrammarLanguageFileMetadata grammarLanguageFileMetadata = (GrammarLanguageFileMetadata)o;
        return Objects.equals(this.fileName, grammarLanguageFileMetadata.fileName) && Objects.equals(this.fileSizeBytes, grammarLanguageFileMetadata.fileSizeBytes) && Objects.equals(this.dateUploaded, grammarLanguageFileMetadata.dateUploaded) && Objects.equals((Object)this.fileType, (Object)grammarLanguageFileMetadata.fileType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fileName, this.fileSizeBytes, this.dateUploaded, this.fileType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GrammarLanguageFileMetadata {\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.fileName)).append("\n");
        sb.append("    fileSizeBytes: ").append(this.toIndentedString(this.fileSizeBytes)).append("\n");
        sb.append("    dateUploaded: ").append(this.toIndentedString(this.dateUploaded)).append("\n");
        sb.append("    fileType: ").append(this.toIndentedString((Object)this.fileType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=FileTypeEnumDeserializer.class)
    public static enum FileTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        GRAM("Gram"),
        GRXML("Grxml");

        private String value;

        private FileTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FileTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (FileTypeEnum value : FileTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return FileTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class FileTypeEnumDeserializer
    extends StdDeserializer<FileTypeEnum> {
        public FileTypeEnumDeserializer() {
            super(FileTypeEnumDeserializer.class);
        }

        public FileTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return FileTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

