/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Describes a link to a record in an external system that contributed data to a Relate record")
public class ExternalDataSource
implements Serializable {
    private PlatformEnum platform = null;
    private String url = null;

    public ExternalDataSource() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public ExternalDataSource platform(PlatformEnum platform) {
        this.platform = platform;
        return this;
    }

    @ApiModelProperty(example="null", value="The platform that was the source of the data.  Example: a CRM like SALESFORCE.")
    @JsonProperty(value="platform")
    public PlatformEnum getPlatform() {
        return this.platform;
    }

    public void setPlatform(PlatformEnum platform) {
        this.platform = platform;
    }

    public ExternalDataSource url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(example="null", value="An URL that links to the source record that contributed data to the associated entity.")
    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalDataSource externalDataSource = (ExternalDataSource)o;
        return Objects.equals((Object)this.platform, (Object)externalDataSource.platform) && Objects.equals(this.url, externalDataSource.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.platform, this.url});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExternalDataSource {\n");
        sb.append("    platform: ").append(this.toIndentedString((Object)this.platform)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=PlatformEnumDeserializer.class)
    public static enum PlatformEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SALESFORCE("SALESFORCE");

        private String value;

        private PlatformEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static PlatformEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (PlatformEnum value : PlatformEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return PlatformEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class PlatformEnumDeserializer
    extends StdDeserializer<PlatformEnum> {
        public PlatformEnumDeserializer() {
            super(PlatformEnumDeserializer.class);
        }

        public PlatformEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return PlatformEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

