/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class EventCondition
implements Serializable {
    private String key = null;
    private List<String> values = null;
    private OperatorEnum operator = null;
    private StreamTypeEnum streamType = null;
    private String sessionType = null;
    private String eventName = null;

    public EventCondition() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.values = new ArrayList<String>();
        }
    }

    public EventCondition key(String key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The event key.")
    @JsonProperty(value="key")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public EventCondition values(List<String> values) {
        this.values = values;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The event values.")
    @JsonProperty(value="values")
    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    public EventCondition operator(OperatorEnum operator) {
        this.operator = operator;
        return this;
    }

    @ApiModelProperty(example="null", value="The comparison operator.")
    @JsonProperty(value="operator")
    public OperatorEnum getOperator() {
        return this.operator;
    }

    public void setOperator(OperatorEnum operator) {
        this.operator = operator;
    }

    public EventCondition streamType(StreamTypeEnum streamType) {
        this.streamType = streamType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The stream type for which this condition can be satisfied.")
    @JsonProperty(value="streamType")
    public StreamTypeEnum getStreamType() {
        return this.streamType;
    }

    public void setStreamType(StreamTypeEnum streamType) {
        this.streamType = streamType;
    }

    public EventCondition sessionType(String sessionType) {
        this.sessionType = sessionType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The session type for which this condition can be satisfied.")
    @JsonProperty(value="sessionType")
    public String getSessionType() {
        return this.sessionType;
    }

    public void setSessionType(String sessionType) {
        this.sessionType = sessionType;
    }

    public EventCondition eventName(String eventName) {
        this.eventName = eventName;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of the event for which this condition can be satisfied.")
    @JsonProperty(value="eventName")
    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventCondition eventCondition = (EventCondition)o;
        return Objects.equals(this.key, eventCondition.key) && Objects.equals(this.values, eventCondition.values) && Objects.equals((Object)this.operator, (Object)eventCondition.operator) && Objects.equals((Object)this.streamType, (Object)eventCondition.streamType) && Objects.equals(this.sessionType, eventCondition.sessionType) && Objects.equals(this.eventName, eventCondition.eventName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.key, this.values, this.operator, this.streamType, this.sessionType, this.eventName});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventCondition {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    values: ").append(this.toIndentedString(this.values)).append("\n");
        sb.append("    operator: ").append(this.toIndentedString((Object)this.operator)).append("\n");
        sb.append("    streamType: ").append(this.toIndentedString((Object)this.streamType)).append("\n");
        sb.append("    sessionType: ").append(this.toIndentedString(this.sessionType)).append("\n");
        sb.append("    eventName: ").append(this.toIndentedString(this.eventName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=OperatorEnumDeserializer.class)
    public static enum OperatorEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CONTAINSALL("containsAll"),
        CONTAINSANY("containsAny"),
        NOTCONTAINSALL("notContainsAll"),
        NOTCONTAINSANY("notContainsAny"),
        EQUAL("equal"),
        NOTEQUAL("notEqual"),
        GREATERTHAN("greaterThan"),
        GREATERTHANOREQUAL("greaterThanOrEqual"),
        LESSTHAN("lessThan"),
        LESSTHANOREQUAL("lessThanOrEqual"),
        STARTSWITH("startsWith"),
        ENDSWITH("endsWith");

        private String value;

        private OperatorEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OperatorEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OperatorEnum value : OperatorEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OperatorEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=StreamTypeEnumDeserializer.class)
    public static enum StreamTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        WEB("Web"),
        CUSTOM("Custom"),
        CONVERSATION("Conversation"),
        APP("App");

        private String value;

        private StreamTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StreamTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StreamTypeEnum value : StreamTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StreamTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StreamTypeEnumDeserializer
    extends StdDeserializer<StreamTypeEnum> {
        public StreamTypeEnumDeserializer() {
            super(StreamTypeEnumDeserializer.class);
        }

        public StreamTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StreamTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class OperatorEnumDeserializer
    extends StdDeserializer<OperatorEnum> {
        public OperatorEnumDeserializer() {
            super(OperatorEnumDeserializer.class);
        }

        public OperatorEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return OperatorEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

