/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.ConversationContentListPickerItem;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="List Picker object for presenting a section of selectable items.")
public class ConversationContentListPickerSection
implements Serializable {
    private String title = null;
    private Boolean multipleSelection = null;
    private List<ConversationContentListPickerItem> items = null;

    public ConversationContentListPickerSection() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.items = new ArrayList<ConversationContentListPickerItem>();
        }
    }

    public ConversationContentListPickerSection title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(example="null", value="Required title for the section.")
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ConversationContentListPickerSection multipleSelection(Boolean multipleSelection) {
        this.multipleSelection = multipleSelection;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether multiple items can be selected in this section.")
    @JsonProperty(value="multipleSelection")
    public Boolean getMultipleSelection() {
        return this.multipleSelection;
    }

    public void setMultipleSelection(Boolean multipleSelection) {
        this.multipleSelection = multipleSelection;
    }

    public ConversationContentListPickerSection items(List<ConversationContentListPickerItem> items) {
        this.items = items;
        return this;
    }

    @ApiModelProperty(example="null", value="List of items to choice from in the section")
    @JsonProperty(value="items")
    public List<ConversationContentListPickerItem> getItems() {
        return this.items;
    }

    public void setItems(List<ConversationContentListPickerItem> items) {
        this.items = items;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationContentListPickerSection conversationContentListPickerSection = (ConversationContentListPickerSection)o;
        return Objects.equals(this.title, conversationContentListPickerSection.title) && Objects.equals(this.multipleSelection, conversationContentListPickerSection.multipleSelection) && Objects.equals(this.items, conversationContentListPickerSection.items);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.multipleSelection, this.items);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationContentListPickerSection {\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    multipleSelection: ").append(this.toIndentedString(this.multipleSelection)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

