/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Represents a selectable item in a list picker.")
public class ConversationContentListPickerItem
implements Serializable {
    private String id = null;
    private String title = null;
    private String subtitle = null;
    private String imageUrl = null;

    public ConversationContentListPickerItem() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public ConversationContentListPickerItem id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="Unique identifier for the list picker item")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ConversationContentListPickerItem title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(example="null", value="The main text displayed for the item.")
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ConversationContentListPickerItem subtitle(String subtitle) {
        this.subtitle = subtitle;
        return this;
    }

    @ApiModelProperty(example="null", value="Additional text providing more details about the item.")
    @JsonProperty(value="subtitle")
    public String getSubtitle() {
        return this.subtitle;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public ConversationContentListPickerItem imageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
        return this;
    }

    @ApiModelProperty(example="null", value="URL of an image to be displayed alongside the item.")
    @JsonProperty(value="imageUrl")
    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationContentListPickerItem conversationContentListPickerItem = (ConversationContentListPickerItem)o;
        return Objects.equals(this.id, conversationContentListPickerItem.id) && Objects.equals(this.title, conversationContentListPickerItem.title) && Objects.equals(this.subtitle, conversationContentListPickerItem.subtitle) && Objects.equals(this.imageUrl, conversationContentListPickerItem.imageUrl);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.title, this.subtitle, this.imageUrl);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationContentListPickerItem {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    subtitle: ").append(this.toIndentedString(this.subtitle)).append("\n");
        sb.append("    imageUrl: ").append(this.toIndentedString(this.imageUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

