/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AlertNotification;
import com.mypurecloud.sdk.v2.model.CommonRuleConditions;
import com.mypurecloud.sdk.v2.model.UserReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class CommonRule
implements Serializable {
    private String id = null;
    private String name = null;
    private String description = null;
    private Boolean enabled = null;
    private List<AlertNotification> notifications = null;
    private Boolean sendExitingAlarmNotifications = null;
    private Long waitBetweenNotificationMs = null;
    private CommonRuleConditions conditions = null;
    private TypeEnum type = null;
    private Boolean inAlarm = null;
    private UserReference user = null;
    private Integer version = null;
    private Date dateCreated = null;
    private Date dateLastModified = null;
    private String selfUri = null;

    public CommonRule() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.notifications = new ArrayList<AlertNotification>();
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public CommonRule name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Name of the rule")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CommonRule description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="The description of the rule.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CommonRule enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates if the rule is enabled.")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public CommonRule notifications(List<AlertNotification> notifications) {
        this.notifications = notifications;
        return this;
    }

    @ApiModelProperty(example="null", value="The alert notification types to trigger when alarm state changes as well as the users they will be sent to.")
    @JsonProperty(value="notifications")
    public List<AlertNotification> getNotifications() {
        return this.notifications;
    }

    public void setNotifications(List<AlertNotification> notifications) {
        this.notifications = notifications;
    }

    public CommonRule sendExitingAlarmNotifications(Boolean sendExitingAlarmNotifications) {
        this.sendExitingAlarmNotifications = sendExitingAlarmNotifications;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates if the alert will send a notification when it is closed.")
    @JsonProperty(value="sendExitingAlarmNotifications")
    public Boolean getSendExitingAlarmNotifications() {
        return this.sendExitingAlarmNotifications;
    }

    public void setSendExitingAlarmNotifications(Boolean sendExitingAlarmNotifications) {
        this.sendExitingAlarmNotifications = sendExitingAlarmNotifications;
    }

    public CommonRule waitBetweenNotificationMs(Long waitBetweenNotificationMs) {
        this.waitBetweenNotificationMs = waitBetweenNotificationMs;
        return this;
    }

    @ApiModelProperty(example="null", value="The amount of time in milliseconds to wait between notification.")
    @JsonProperty(value="waitBetweenNotificationMs")
    public Long getWaitBetweenNotificationMs() {
        return this.waitBetweenNotificationMs;
    }

    public void setWaitBetweenNotificationMs(Long waitBetweenNotificationMs) {
        this.waitBetweenNotificationMs = waitBetweenNotificationMs;
    }

    public CommonRule conditions(CommonRuleConditions conditions) {
        this.conditions = conditions;
        return this;
    }

    @ApiModelProperty(example="null", value="The set of metric conditions that would trigger an alert.")
    @JsonProperty(value="conditions")
    public CommonRuleConditions getConditions() {
        return this.conditions;
    }

    public void setConditions(CommonRuleConditions conditions) {
        this.conditions = conditions;
    }

    public CommonRule type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The type of the rule.")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public CommonRule inAlarm(Boolean inAlarm) {
        this.inAlarm = inAlarm;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates if the rule is in alarm state.")
    @JsonProperty(value="inAlarm")
    public Boolean getInAlarm() {
        return this.inAlarm;
    }

    public void setInAlarm(Boolean inAlarm) {
        this.inAlarm = inAlarm;
    }

    public CommonRule user(UserReference user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(example="null", value="The entity that created the rule.")
    @JsonProperty(value="user")
    public UserReference getUser() {
        return this.user;
    }

    public void setUser(UserReference user) {
        this.user = user;
    }

    public CommonRule version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", value="The current version number of the rule.")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public CommonRule dateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    @ApiModelProperty(example="null", value="The creation date of the rule when the rule was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public CommonRule dateLastModified(Date dateLastModified) {
        this.dateLastModified = dateLastModified;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp of the last update to the rule. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateLastModified")
    public Date getDateLastModified() {
        return this.dateLastModified;
    }

    public void setDateLastModified(Date dateLastModified) {
        this.dateLastModified = dateLastModified;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommonRule commonRule = (CommonRule)o;
        return Objects.equals(this.id, commonRule.id) && Objects.equals(this.name, commonRule.name) && Objects.equals(this.description, commonRule.description) && Objects.equals(this.enabled, commonRule.enabled) && Objects.equals(this.notifications, commonRule.notifications) && Objects.equals(this.sendExitingAlarmNotifications, commonRule.sendExitingAlarmNotifications) && Objects.equals(this.waitBetweenNotificationMs, commonRule.waitBetweenNotificationMs) && Objects.equals(this.conditions, commonRule.conditions) && Objects.equals((Object)this.type, (Object)commonRule.type) && Objects.equals(this.inAlarm, commonRule.inAlarm) && Objects.equals(this.user, commonRule.user) && Objects.equals(this.version, commonRule.version) && Objects.equals(this.dateCreated, commonRule.dateCreated) && Objects.equals(this.dateLastModified, commonRule.dateLastModified) && Objects.equals(this.selfUri, commonRule.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.description, this.enabled, this.notifications, this.sendExitingAlarmNotifications, this.waitBetweenNotificationMs, this.conditions, this.type, this.inAlarm, this.user, this.version, this.dateCreated, this.dateLastModified, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CommonRule {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    notifications: ").append(this.toIndentedString(this.notifications)).append("\n");
        sb.append("    sendExitingAlarmNotifications: ").append(this.toIndentedString(this.sendExitingAlarmNotifications)).append("\n");
        sb.append("    waitBetweenNotificationMs: ").append(this.toIndentedString(this.waitBetweenNotificationMs)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    inAlarm: ").append(this.toIndentedString(this.inAlarm)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateLastModified: ").append(this.toIndentedString(this.dateLastModified)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CONVERSATIONMETRICS("ConversationMetrics"),
        USERPRESENCE("UserPresence"),
        WORKFORCEMANAGEMENT("WorkforceManagement"),
        OPERATIONALCONSOLE("OperationalConsole"),
        UNKNOWN("Unknown");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

