/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.SecondaryPresence;
import com.mypurecloud.sdk.v2.model.WfmVersionedEntityMetadata;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class BusinessUnitActivityCode
implements Serializable {
    private String id = null;
    private String name = null;
    private Boolean active = null;
    private Boolean defaultCode = null;
    private CategoryEnum category = null;
    private Integer lengthInMinutes = null;
    private Boolean countsAsPaidTime = null;
    private Boolean countsAsWorkTime = null;
    private Boolean agentTimeOffSelectable = null;
    private Boolean countsTowardShrinkage = null;
    private Boolean plannedShrinkage = null;
    private Boolean interruptible = null;
    private List<SecondaryPresence> secondaryPresences = null;
    private WfmVersionedEntityMetadata metadata = null;
    private String selfUri = null;

    public BusinessUnitActivityCode() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.secondaryPresences = new ArrayList<SecondaryPresence>();
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public BusinessUnitActivityCode name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BusinessUnitActivityCode active(Boolean active) {
        this.active = active;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether this activity code is active or has been deleted")
    @JsonProperty(value="active")
    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public BusinessUnitActivityCode defaultCode(Boolean defaultCode) {
        this.defaultCode = defaultCode;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether this is a default activity code")
    @JsonProperty(value="defaultCode")
    public Boolean getDefaultCode() {
        return this.defaultCode;
    }

    public void setDefaultCode(Boolean defaultCode) {
        this.defaultCode = defaultCode;
    }

    public BusinessUnitActivityCode category(CategoryEnum category) {
        this.category = category;
        return this;
    }

    @ApiModelProperty(example="null", value="The category of the activity code")
    @JsonProperty(value="category")
    public CategoryEnum getCategory() {
        return this.category;
    }

    public void setCategory(CategoryEnum category) {
        this.category = category;
    }

    public BusinessUnitActivityCode lengthInMinutes(Integer lengthInMinutes) {
        this.lengthInMinutes = lengthInMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="The default length of the activity in minutes")
    @JsonProperty(value="lengthInMinutes")
    public Integer getLengthInMinutes() {
        return this.lengthInMinutes;
    }

    public void setLengthInMinutes(Integer lengthInMinutes) {
        this.lengthInMinutes = lengthInMinutes;
    }

    public BusinessUnitActivityCode countsAsPaidTime(Boolean countsAsPaidTime) {
        this.countsAsPaidTime = countsAsPaidTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether an agent is paid while performing this activity")
    @JsonProperty(value="countsAsPaidTime")
    public Boolean getCountsAsPaidTime() {
        return this.countsAsPaidTime;
    }

    public void setCountsAsPaidTime(Boolean countsAsPaidTime) {
        this.countsAsPaidTime = countsAsPaidTime;
    }

    public BusinessUnitActivityCode countsAsWorkTime(Boolean countsAsWorkTime) {
        this.countsAsWorkTime = countsAsWorkTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates whether or not the activity should be counted as contiguous work time for calculating daily constraints")
    @JsonProperty(value="countsAsWorkTime")
    public Boolean getCountsAsWorkTime() {
        return this.countsAsWorkTime;
    }

    public void setCountsAsWorkTime(Boolean countsAsWorkTime) {
        this.countsAsWorkTime = countsAsWorkTime;
    }

    public BusinessUnitActivityCode agentTimeOffSelectable(Boolean agentTimeOffSelectable) {
        this.agentTimeOffSelectable = agentTimeOffSelectable;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether an agent can select this activity code when creating or editing a time off request. Null if the activity's category is not time off.")
    @JsonProperty(value="agentTimeOffSelectable")
    public Boolean getAgentTimeOffSelectable() {
        return this.agentTimeOffSelectable;
    }

    public void setAgentTimeOffSelectable(Boolean agentTimeOffSelectable) {
        this.agentTimeOffSelectable = agentTimeOffSelectable;
    }

    public BusinessUnitActivityCode countsTowardShrinkage(Boolean countsTowardShrinkage) {
        this.countsTowardShrinkage = countsTowardShrinkage;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether or not this activity code counts toward shrinkage calculations")
    @JsonProperty(value="countsTowardShrinkage")
    public Boolean getCountsTowardShrinkage() {
        return this.countsTowardShrinkage;
    }

    public void setCountsTowardShrinkage(Boolean countsTowardShrinkage) {
        this.countsTowardShrinkage = countsTowardShrinkage;
    }

    public BusinessUnitActivityCode plannedShrinkage(Boolean plannedShrinkage) {
        this.plannedShrinkage = plannedShrinkage;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether this activity code is considered planned or unplanned shrinkage")
    @JsonProperty(value="plannedShrinkage")
    public Boolean getPlannedShrinkage() {
        return this.plannedShrinkage;
    }

    public void setPlannedShrinkage(Boolean plannedShrinkage) {
        this.plannedShrinkage = plannedShrinkage;
    }

    public BusinessUnitActivityCode interruptible(Boolean interruptible) {
        this.interruptible = interruptible;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether this activity code is considered interruptible")
    @JsonProperty(value="interruptible")
    public Boolean getInterruptible() {
        return this.interruptible;
    }

    public void setInterruptible(Boolean interruptible) {
        this.interruptible = interruptible;
    }

    public BusinessUnitActivityCode secondaryPresences(List<SecondaryPresence> secondaryPresences) {
        this.secondaryPresences = secondaryPresences;
        return this;
    }

    @ApiModelProperty(example="null", value="The secondary presences of this activity code")
    @JsonProperty(value="secondaryPresences")
    public List<SecondaryPresence> getSecondaryPresences() {
        return this.secondaryPresences;
    }

    public void setSecondaryPresences(List<SecondaryPresence> secondaryPresences) {
        this.secondaryPresences = secondaryPresences;
    }

    public BusinessUnitActivityCode metadata(WfmVersionedEntityMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(example="null", value="Version metadata of this activity code")
    @JsonProperty(value="metadata")
    public WfmVersionedEntityMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(WfmVersionedEntityMetadata metadata) {
        this.metadata = metadata;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BusinessUnitActivityCode businessUnitActivityCode = (BusinessUnitActivityCode)o;
        return Objects.equals(this.id, businessUnitActivityCode.id) && Objects.equals(this.name, businessUnitActivityCode.name) && Objects.equals(this.active, businessUnitActivityCode.active) && Objects.equals(this.defaultCode, businessUnitActivityCode.defaultCode) && Objects.equals((Object)this.category, (Object)businessUnitActivityCode.category) && Objects.equals(this.lengthInMinutes, businessUnitActivityCode.lengthInMinutes) && Objects.equals(this.countsAsPaidTime, businessUnitActivityCode.countsAsPaidTime) && Objects.equals(this.countsAsWorkTime, businessUnitActivityCode.countsAsWorkTime) && Objects.equals(this.agentTimeOffSelectable, businessUnitActivityCode.agentTimeOffSelectable) && Objects.equals(this.countsTowardShrinkage, businessUnitActivityCode.countsTowardShrinkage) && Objects.equals(this.plannedShrinkage, businessUnitActivityCode.plannedShrinkage) && Objects.equals(this.interruptible, businessUnitActivityCode.interruptible) && Objects.equals(this.secondaryPresences, businessUnitActivityCode.secondaryPresences) && Objects.equals(this.metadata, businessUnitActivityCode.metadata) && Objects.equals(this.selfUri, businessUnitActivityCode.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.active, this.defaultCode, this.category, this.lengthInMinutes, this.countsAsPaidTime, this.countsAsWorkTime, this.agentTimeOffSelectable, this.countsTowardShrinkage, this.plannedShrinkage, this.interruptible, this.secondaryPresences, this.metadata, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BusinessUnitActivityCode {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    defaultCode: ").append(this.toIndentedString(this.defaultCode)).append("\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    lengthInMinutes: ").append(this.toIndentedString(this.lengthInMinutes)).append("\n");
        sb.append("    countsAsPaidTime: ").append(this.toIndentedString(this.countsAsPaidTime)).append("\n");
        sb.append("    countsAsWorkTime: ").append(this.toIndentedString(this.countsAsWorkTime)).append("\n");
        sb.append("    agentTimeOffSelectable: ").append(this.toIndentedString(this.agentTimeOffSelectable)).append("\n");
        sb.append("    countsTowardShrinkage: ").append(this.toIndentedString(this.countsTowardShrinkage)).append("\n");
        sb.append("    plannedShrinkage: ").append(this.toIndentedString(this.plannedShrinkage)).append("\n");
        sb.append("    interruptible: ").append(this.toIndentedString(this.interruptible)).append("\n");
        sb.append("    secondaryPresences: ").append(this.toIndentedString(this.secondaryPresences)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=CategoryEnumDeserializer.class)
    public static enum CategoryEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ONQUEUEWORK("OnQueueWork"),
        BREAK("Break"),
        MEAL("Meal"),
        MEETING("Meeting"),
        OFFQUEUEWORK("OffQueueWork"),
        TIMEOFF("TimeOff"),
        TRAINING("Training"),
        UNAVAILABLE("Unavailable"),
        UNSCHEDULED("Unscheduled");

        private String value;

        private CategoryEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CategoryEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (CategoryEnum value : CategoryEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return CategoryEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class CategoryEnumDeserializer
    extends StdDeserializer<CategoryEnum> {
        public CategoryEnumDeserializer() {
            super(CategoryEnumDeserializer.class);
        }

        public CategoryEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return CategoryEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

