/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GetRoutingEmailDomainRouteRequest {
    private String domainName;
    private String routeId;
    private List<String> expand;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public GetRoutingEmailDomainRouteRequest withDomainName(String domainName) {
        this.setDomainName(domainName);
        return this;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public GetRoutingEmailDomainRouteRequest withRouteId(String routeId) {
        this.setRouteId(routeId);
        return this;
    }

    public List<String> getExpand() {
        return this.expand;
    }

    public void setExpand(List<String> expand) {
        this.expand = expand;
    }

    public GetRoutingEmailDomainRouteRequest withExpand(List<String> expand) {
        this.setExpand(expand);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetRoutingEmailDomainRouteRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.domainName == null) {
            throw new IllegalStateException("Missing the required parameter 'domainName' when building request for GetRoutingEmailDomainRouteRequest.");
        }
        if (this.routeId == null) {
            throw new IllegalStateException("Missing the required parameter 'routeId' when building request for GetRoutingEmailDomainRouteRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/routing/email/domains/{domainName}/routes/{routeId}").withPathParameter("domainName", this.domainName).withPathParameter("routeId", this.routeId).withQueryParameters("expand", "multi", this.expand).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String domainName, String routeId) {
        return new Builder().withRequiredParams(domainName, routeId);
    }

    public static class Builder {
        private final GetRoutingEmailDomainRouteRequest request = new GetRoutingEmailDomainRouteRequest();

        private Builder() {
        }

        public Builder withDomainName(String domainName) {
            this.request.setDomainName(domainName);
            return this;
        }

        public Builder withRouteId(String routeId) {
            this.request.setRouteId(routeId);
            return this;
        }

        public Builder withExpand(List<String> expand) {
            this.request.setExpand(expand);
            return this;
        }

        public Builder withExpandEnumValues(List<expandValues> expand) {
            ArrayList<String> stringList = new ArrayList<String>();
            for (expandValues e : expand) {
                stringList.add(e.toString());
            }
            this.request.setExpand(stringList);
            return this;
        }

        public Builder withRequiredParams(String domainName, String routeId) {
            this.request.setDomainName(domainName);
            this.request.setRouteId(routeId);
            return this;
        }

        public GetRoutingEmailDomainRouteRequest build() {
            if (this.request.domainName == null) {
                throw new IllegalStateException("Missing the required parameter 'domainName' when building request for GetRoutingEmailDomainRouteRequest.");
            }
            if (this.request.routeId == null) {
                throw new IllegalStateException("Missing the required parameter 'routeId' when building request for GetRoutingEmailDomainRouteRequest.");
            }
            return this.request;
        }
    }

    public static enum expandValues {
        IDENTITYRESOLUTION("identityresolution");

        private String value;

        private expandValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static expandValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (expandValues value : expandValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return expandValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

