/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@ApiModel(description="Defines an external media that has been ingested and cached by Genesys Cloud for conversation messaging")
public class CachedMediaItem
implements Serializable {
    private String id = null;
    private String url = null;
    private String downloadUrl = null;
    private String mediaType = null;
    private Integer contentLengthBytes = null;
    private Date dateCreated = null;
    private Date dateExpires = null;
    private String selfUri = null;

    public CachedMediaItem() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="The unique identifier for the cached media.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(example="null", value="The URL that represents the external media that has been cached")
    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    @ApiModelProperty(example="null", value="A URL to fetch the cached media")
    @JsonProperty(value="downloadUrl")
    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    @ApiModelProperty(example="null", value="The media type for the URL")
    @JsonProperty(value="mediaType")
    public String getMediaType() {
        return this.mediaType;
    }

    @ApiModelProperty(example="null", value="The content length of the media represented by the URL, in bytes.")
    @JsonProperty(value="contentLengthBytes")
    public Integer getContentLengthBytes() {
        return this.contentLengthBytes;
    }

    @ApiModelProperty(example="null", value="The date the cached item was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="The date the cached item expires and will be removed from the cache. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateExpires")
    public Date getDateExpires() {
        return this.dateExpires;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CachedMediaItem cachedMediaItem = (CachedMediaItem)o;
        return Objects.equals(this.id, cachedMediaItem.id) && Objects.equals(this.url, cachedMediaItem.url) && Objects.equals(this.downloadUrl, cachedMediaItem.downloadUrl) && Objects.equals(this.mediaType, cachedMediaItem.mediaType) && Objects.equals(this.contentLengthBytes, cachedMediaItem.contentLengthBytes) && Objects.equals(this.dateCreated, cachedMediaItem.dateCreated) && Objects.equals(this.dateExpires, cachedMediaItem.dateExpires) && Objects.equals(this.selfUri, cachedMediaItem.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.url, this.downloadUrl, this.mediaType, this.contentLengthBytes, this.dateCreated, this.dateExpires, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CachedMediaItem {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    downloadUrl: ").append(this.toIndentedString(this.downloadUrl)).append("\n");
        sb.append("    mediaType: ").append(this.toIndentedString(this.mediaType)).append("\n");
        sb.append("    contentLengthBytes: ").append(this.toIndentedString(this.contentLengthBytes)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateExpires: ").append(this.toIndentedString(this.dateExpires)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

