/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.BillingProduct;
import com.mypurecloud.sdk.v2.model.NamedEntity;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class BillingWallet
implements Serializable {
    private String id = null;
    private String name = null;
    private List<NamedEntity> organizations = null;
    private BillingProduct product = null;
    private BigDecimal startingBalance = null;
    private BigDecimal endingBalance = null;
    private BigDecimal balanceIncrease = null;
    private BigDecimal balanceDecrease = null;
    private BigDecimal balanceConsumption = null;
    private BigDecimal balanceOverage = null;
    private BigDecimal balanceOverageRate = null;
    private BigDecimal balanceOverageCharge = null;
    private String balanceOverageCurrency = null;
    private UnitOfMeasureEnum unitOfMeasure = null;

    public BillingWallet() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.organizations = new ArrayList<NamedEntity>();
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(example="null", value="The name of the object.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public BillingWallet organizations(List<NamedEntity> organizations) {
        this.organizations = organizations;
        return this;
    }

    @ApiModelProperty(example="null", value="A Genesys Cloud Organization and it's related plans.")
    @JsonProperty(value="organizations")
    public List<NamedEntity> getOrganizations() {
        return this.organizations;
    }

    public void setOrganizations(List<NamedEntity> organizations) {
        this.organizations = organizations;
    }

    public BillingWallet product(BillingProduct product) {
        this.product = product;
        return this;
    }

    @ApiModelProperty(example="null", value="Represents the details of a product.")
    @JsonProperty(value="product")
    public BillingProduct getProduct() {
        return this.product;
    }

    public void setProduct(BillingProduct product) {
        this.product = product;
    }

    public BillingWallet startingBalance(BigDecimal startingBalance) {
        this.startingBalance = startingBalance;
        return this;
    }

    @ApiModelProperty(example="null", value="The initial balance in the wallet.")
    @JsonProperty(value="startingBalance")
    public BigDecimal getStartingBalance() {
        return this.startingBalance;
    }

    public void setStartingBalance(BigDecimal startingBalance) {
        this.startingBalance = startingBalance;
    }

    public BillingWallet endingBalance(BigDecimal endingBalance) {
        this.endingBalance = endingBalance;
        return this;
    }

    @ApiModelProperty(example="null", value="The final balance in the wallet after transactions.")
    @JsonProperty(value="endingBalance")
    public BigDecimal getEndingBalance() {
        return this.endingBalance;
    }

    public void setEndingBalance(BigDecimal endingBalance) {
        this.endingBalance = endingBalance;
    }

    public BillingWallet balanceIncrease(BigDecimal balanceIncrease) {
        this.balanceIncrease = balanceIncrease;
        return this;
    }

    @ApiModelProperty(example="null", value="Total amount added to the wallet.")
    @JsonProperty(value="balanceIncrease")
    public BigDecimal getBalanceIncrease() {
        return this.balanceIncrease;
    }

    public void setBalanceIncrease(BigDecimal balanceIncrease) {
        this.balanceIncrease = balanceIncrease;
    }

    public BillingWallet balanceDecrease(BigDecimal balanceDecrease) {
        this.balanceDecrease = balanceDecrease;
        return this;
    }

    @ApiModelProperty(example="null", value="The amount removed from the wallet due to a contract change.")
    @JsonProperty(value="balanceDecrease")
    public BigDecimal getBalanceDecrease() {
        return this.balanceDecrease;
    }

    public void setBalanceDecrease(BigDecimal balanceDecrease) {
        this.balanceDecrease = balanceDecrease;
    }

    public BillingWallet balanceConsumption(BigDecimal balanceConsumption) {
        this.balanceConsumption = balanceConsumption;
        return this;
    }

    @ApiModelProperty(example="null", value="Total consumption deducted from the wallet.")
    @JsonProperty(value="balanceConsumption")
    public BigDecimal getBalanceConsumption() {
        return this.balanceConsumption;
    }

    public void setBalanceConsumption(BigDecimal balanceConsumption) {
        this.balanceConsumption = balanceConsumption;
    }

    public BillingWallet balanceOverage(BigDecimal balanceOverage) {
        this.balanceOverage = balanceOverage;
        return this;
    }

    @ApiModelProperty(example="null", value="The amount exceeding a predefined balance threshold.")
    @JsonProperty(value="balanceOverage")
    public BigDecimal getBalanceOverage() {
        return this.balanceOverage;
    }

    public void setBalanceOverage(BigDecimal balanceOverage) {
        this.balanceOverage = balanceOverage;
    }

    public BillingWallet balanceOverageRate(BigDecimal balanceOverageRate) {
        this.balanceOverageRate = balanceOverageRate;
        return this;
    }

    @ApiModelProperty(example="null", value="The rate charged for an overage..")
    @JsonProperty(value="balanceOverageRate")
    public BigDecimal getBalanceOverageRate() {
        return this.balanceOverageRate;
    }

    public void setBalanceOverageRate(BigDecimal balanceOverageRate) {
        this.balanceOverageRate = balanceOverageRate;
    }

    public BillingWallet balanceOverageCharge(BigDecimal balanceOverageCharge) {
        this.balanceOverageCharge = balanceOverageCharge;
        return this;
    }

    @ApiModelProperty(example="null", value="The amount to be charged.")
    @JsonProperty(value="balanceOverageCharge")
    public BigDecimal getBalanceOverageCharge() {
        return this.balanceOverageCharge;
    }

    public void setBalanceOverageCharge(BigDecimal balanceOverageCharge) {
        this.balanceOverageCharge = balanceOverageCharge;
    }

    public BillingWallet balanceOverageCurrency(String balanceOverageCurrency) {
        this.balanceOverageCurrency = balanceOverageCurrency;
        return this;
    }

    @ApiModelProperty(example="null", value="The currency in which the overage charge is invoiced.")
    @JsonProperty(value="balanceOverageCurrency")
    public String getBalanceOverageCurrency() {
        return this.balanceOverageCurrency;
    }

    public void setBalanceOverageCurrency(String balanceOverageCurrency) {
        this.balanceOverageCurrency = balanceOverageCurrency;
    }

    public BillingWallet unitOfMeasure(UnitOfMeasureEnum unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
        return this;
    }

    @ApiModelProperty(example="null", value="The unit of measure for the wallet.")
    @JsonProperty(value="unitOfMeasure")
    public UnitOfMeasureEnum getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public void setUnitOfMeasure(UnitOfMeasureEnum unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BillingWallet billingWallet = (BillingWallet)o;
        return Objects.equals(this.id, billingWallet.id) && Objects.equals(this.name, billingWallet.name) && Objects.equals(this.organizations, billingWallet.organizations) && Objects.equals(this.product, billingWallet.product) && Objects.equals(this.startingBalance, billingWallet.startingBalance) && Objects.equals(this.endingBalance, billingWallet.endingBalance) && Objects.equals(this.balanceIncrease, billingWallet.balanceIncrease) && Objects.equals(this.balanceDecrease, billingWallet.balanceDecrease) && Objects.equals(this.balanceConsumption, billingWallet.balanceConsumption) && Objects.equals(this.balanceOverage, billingWallet.balanceOverage) && Objects.equals(this.balanceOverageRate, billingWallet.balanceOverageRate) && Objects.equals(this.balanceOverageCharge, billingWallet.balanceOverageCharge) && Objects.equals(this.balanceOverageCurrency, billingWallet.balanceOverageCurrency) && Objects.equals((Object)this.unitOfMeasure, (Object)billingWallet.unitOfMeasure);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.organizations, this.product, this.startingBalance, this.endingBalance, this.balanceIncrease, this.balanceDecrease, this.balanceConsumption, this.balanceOverage, this.balanceOverageRate, this.balanceOverageCharge, this.balanceOverageCurrency, this.unitOfMeasure});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BillingWallet {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    organizations: ").append(this.toIndentedString(this.organizations)).append("\n");
        sb.append("    product: ").append(this.toIndentedString(this.product)).append("\n");
        sb.append("    startingBalance: ").append(this.toIndentedString(this.startingBalance)).append("\n");
        sb.append("    endingBalance: ").append(this.toIndentedString(this.endingBalance)).append("\n");
        sb.append("    balanceIncrease: ").append(this.toIndentedString(this.balanceIncrease)).append("\n");
        sb.append("    balanceDecrease: ").append(this.toIndentedString(this.balanceDecrease)).append("\n");
        sb.append("    balanceConsumption: ").append(this.toIndentedString(this.balanceConsumption)).append("\n");
        sb.append("    balanceOverage: ").append(this.toIndentedString(this.balanceOverage)).append("\n");
        sb.append("    balanceOverageRate: ").append(this.toIndentedString(this.balanceOverageRate)).append("\n");
        sb.append("    balanceOverageCharge: ").append(this.toIndentedString(this.balanceOverageCharge)).append("\n");
        sb.append("    balanceOverageCurrency: ").append(this.toIndentedString(this.balanceOverageCurrency)).append("\n");
        sb.append("    unitOfMeasure: ").append(this.toIndentedString((Object)this.unitOfMeasure)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=UnitOfMeasureEnumDeserializer.class)
    public static enum UnitOfMeasureEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CALL("Call"),
        CHARACTER("Character"),
        CONVERSATION("Conversation"),
        COURSE("Course"),
        DAY("Day"),
        EACH("Each"),
        EMPLOYEE("Employee"),
        ENGAGEMENT("Engagement"),
        EVENT("Event"),
        EXAM("Exam"),
        GB("GB"),
        HOUR("Hour"),
        INSTANCE("Instance"),
        INTERACTION("Interaction"),
        INVOCATION("Invocation"),
        MESSAGE("Message"),
        MILLIONCHARACTERS("MillionCharacters"),
        MINUTE("Minute"),
        PERSON("Person"),
        PHONENUMBER("PhoneNumber"),
        PORT("Port"),
        SEGMENT("Segment"),
        SESSION("Session"),
        STREAM("Stream"),
        TOKEN("Token"),
        TRANSACTION("Transaction"),
        TURN("Turn"),
        UNIT("Unit"),
        USER("User");

        private String value;

        private UnitOfMeasureEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static UnitOfMeasureEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (UnitOfMeasureEnum value : UnitOfMeasureEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return UnitOfMeasureEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class UnitOfMeasureEnumDeserializer
    extends StdDeserializer<UnitOfMeasureEnum> {
        public UnitOfMeasureEnumDeserializer() {
            super(UnitOfMeasureEnumDeserializer.class);
        }

        public UnitOfMeasureEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return UnitOfMeasureEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

