/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.PermissionDetails;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AvailableTopic
implements Serializable {
    private String description = null;
    private String id = null;
    private List<PermissionDetails> permissionDetails = null;
    private List<String> requiresPermissions = null;
    private Boolean requiresDivisionPermissions = null;
    private Boolean requiresAnyValidator = null;
    private Boolean enforced = null;
    private VisibilityEnum visibility = null;
    private Map<String, Object> schema = null;
    private Boolean requiresCurrentUser = null;
    private Boolean requiresCurrentUserOrPermission = null;
    private List<TransportsEnum> transports = null;
    private List<String> publicApiTemplateUriPaths = null;
    private List<String> topicParameters = null;

    public AvailableTopic() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.permissionDetails = new ArrayList<PermissionDetails>();
            this.requiresPermissions = new ArrayList<String>();
            this.transports = new ArrayList<TransportsEnum>();
            this.publicApiTemplateUriPaths = new ArrayList<String>();
            this.topicParameters = new ArrayList<String>();
        }
    }

    public AvailableTopic description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public AvailableTopic id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AvailableTopic permissionDetails(List<PermissionDetails> permissionDetails) {
        this.permissionDetails = permissionDetails;
        return this;
    }

    @ApiModelProperty(example="null", value="Full detailed permissions required to subscribe to the topic")
    @JsonProperty(value="permissionDetails")
    public List<PermissionDetails> getPermissionDetails() {
        return this.permissionDetails;
    }

    public void setPermissionDetails(List<PermissionDetails> permissionDetails) {
        this.permissionDetails = permissionDetails;
    }

    public AvailableTopic requiresPermissions(List<String> requiresPermissions) {
        this.requiresPermissions = requiresPermissions;
        return this;
    }

    @ApiModelProperty(example="null", value="Permissions required to subscribe to the topic")
    @JsonProperty(value="requiresPermissions")
    public List<String> getRequiresPermissions() {
        return this.requiresPermissions;
    }

    public void setRequiresPermissions(List<String> requiresPermissions) {
        this.requiresPermissions = requiresPermissions;
    }

    public AvailableTopic requiresDivisionPermissions(Boolean requiresDivisionPermissions) {
        this.requiresDivisionPermissions = requiresDivisionPermissions;
        return this;
    }

    @ApiModelProperty(example="null", value="True if the subscribing user must belong to the same division as the topic object ID")
    @JsonProperty(value="requiresDivisionPermissions")
    public Boolean getRequiresDivisionPermissions() {
        return this.requiresDivisionPermissions;
    }

    public void setRequiresDivisionPermissions(Boolean requiresDivisionPermissions) {
        this.requiresDivisionPermissions = requiresDivisionPermissions;
    }

    public AvailableTopic requiresAnyValidator(Boolean requiresAnyValidator) {
        this.requiresAnyValidator = requiresAnyValidator;
        return this;
    }

    @ApiModelProperty(example="null", value="If multiple permissions are required for this topic, such as both requiresCurrentUser and requiresDivisionPermissions, then true here indicates that meeting any one condition will satisfy the requirements; false indicates all conditions must be met.")
    @JsonProperty(value="requiresAnyValidator")
    public Boolean getRequiresAnyValidator() {
        return this.requiresAnyValidator;
    }

    public void setRequiresAnyValidator(Boolean requiresAnyValidator) {
        this.requiresAnyValidator = requiresAnyValidator;
    }

    public AvailableTopic enforced(Boolean enforced) {
        this.enforced = enforced;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether or not the permissions on this topic are enforced")
    @JsonProperty(value="enforced")
    public Boolean getEnforced() {
        return this.enforced;
    }

    public void setEnforced(Boolean enforced) {
        this.enforced = enforced;
    }

    public AvailableTopic visibility(VisibilityEnum visibility) {
        this.visibility = visibility;
        return this;
    }

    @ApiModelProperty(example="null", value="Visibility of this topic (Public or Preview)")
    @JsonProperty(value="visibility")
    public VisibilityEnum getVisibility() {
        return this.visibility;
    }

    public void setVisibility(VisibilityEnum visibility) {
        this.visibility = visibility;
    }

    public AvailableTopic schema(Map<String, Object> schema) {
        this.schema = schema;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="schema")
    public Map<String, Object> getSchema() {
        return this.schema;
    }

    public void setSchema(Map<String, Object> schema) {
        this.schema = schema;
    }

    public AvailableTopic requiresCurrentUser(Boolean requiresCurrentUser) {
        this.requiresCurrentUser = requiresCurrentUser;
        return this;
    }

    @ApiModelProperty(example="null", value="True if the topic user ID is required to match the subscribing user ID")
    @JsonProperty(value="requiresCurrentUser")
    public Boolean getRequiresCurrentUser() {
        return this.requiresCurrentUser;
    }

    public void setRequiresCurrentUser(Boolean requiresCurrentUser) {
        this.requiresCurrentUser = requiresCurrentUser;
    }

    public AvailableTopic requiresCurrentUserOrPermission(Boolean requiresCurrentUserOrPermission) {
        this.requiresCurrentUserOrPermission = requiresCurrentUserOrPermission;
        return this;
    }

    @ApiModelProperty(example="null", value="True if permissions are only required when the topic user ID does not match the subscribing user ID")
    @JsonProperty(value="requiresCurrentUserOrPermission")
    public Boolean getRequiresCurrentUserOrPermission() {
        return this.requiresCurrentUserOrPermission;
    }

    public void setRequiresCurrentUserOrPermission(Boolean requiresCurrentUserOrPermission) {
        this.requiresCurrentUserOrPermission = requiresCurrentUserOrPermission;
    }

    public AvailableTopic transports(List<TransportsEnum> transports) {
        this.transports = transports;
        return this;
    }

    @ApiModelProperty(example="null", value="Transports that support events for the topic")
    @JsonProperty(value="transports")
    public List<TransportsEnum> getTransports() {
        return this.transports;
    }

    public void setTransports(List<TransportsEnum> transports) {
        this.transports = transports;
    }

    public AvailableTopic publicApiTemplateUriPaths(List<String> publicApiTemplateUriPaths) {
        this.publicApiTemplateUriPaths = publicApiTemplateUriPaths;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="publicApiTemplateUriPaths")
    public List<String> getPublicApiTemplateUriPaths() {
        return this.publicApiTemplateUriPaths;
    }

    public void setPublicApiTemplateUriPaths(List<String> publicApiTemplateUriPaths) {
        this.publicApiTemplateUriPaths = publicApiTemplateUriPaths;
    }

    public AvailableTopic topicParameters(List<String> topicParameters) {
        this.topicParameters = topicParameters;
        return this;
    }

    @ApiModelProperty(example="null", value="Parameters in the topic name that can be substituted, in the order they appear in the topic name")
    @JsonProperty(value="topicParameters")
    public List<String> getTopicParameters() {
        return this.topicParameters;
    }

    public void setTopicParameters(List<String> topicParameters) {
        this.topicParameters = topicParameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AvailableTopic availableTopic = (AvailableTopic)o;
        return Objects.equals(this.description, availableTopic.description) && Objects.equals(this.id, availableTopic.id) && Objects.equals(this.permissionDetails, availableTopic.permissionDetails) && Objects.equals(this.requiresPermissions, availableTopic.requiresPermissions) && Objects.equals(this.requiresDivisionPermissions, availableTopic.requiresDivisionPermissions) && Objects.equals(this.requiresAnyValidator, availableTopic.requiresAnyValidator) && Objects.equals(this.enforced, availableTopic.enforced) && Objects.equals((Object)this.visibility, (Object)availableTopic.visibility) && Objects.equals(this.schema, availableTopic.schema) && Objects.equals(this.requiresCurrentUser, availableTopic.requiresCurrentUser) && Objects.equals(this.requiresCurrentUserOrPermission, availableTopic.requiresCurrentUserOrPermission) && Objects.equals(this.transports, availableTopic.transports) && Objects.equals(this.publicApiTemplateUriPaths, availableTopic.publicApiTemplateUriPaths) && Objects.equals(this.topicParameters, availableTopic.topicParameters);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.description, this.id, this.permissionDetails, this.requiresPermissions, this.requiresDivisionPermissions, this.requiresAnyValidator, this.enforced, this.visibility, this.schema, this.requiresCurrentUser, this.requiresCurrentUserOrPermission, this.transports, this.publicApiTemplateUriPaths, this.topicParameters});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AvailableTopic {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    permissionDetails: ").append(this.toIndentedString(this.permissionDetails)).append("\n");
        sb.append("    requiresPermissions: ").append(this.toIndentedString(this.requiresPermissions)).append("\n");
        sb.append("    requiresDivisionPermissions: ").append(this.toIndentedString(this.requiresDivisionPermissions)).append("\n");
        sb.append("    requiresAnyValidator: ").append(this.toIndentedString(this.requiresAnyValidator)).append("\n");
        sb.append("    enforced: ").append(this.toIndentedString(this.enforced)).append("\n");
        sb.append("    visibility: ").append(this.toIndentedString((Object)this.visibility)).append("\n");
        sb.append("    schema: ").append(this.toIndentedString(this.schema)).append("\n");
        sb.append("    requiresCurrentUser: ").append(this.toIndentedString(this.requiresCurrentUser)).append("\n");
        sb.append("    requiresCurrentUserOrPermission: ").append(this.toIndentedString(this.requiresCurrentUserOrPermission)).append("\n");
        sb.append("    transports: ").append(this.toIndentedString(this.transports)).append("\n");
        sb.append("    publicApiTemplateUriPaths: ").append(this.toIndentedString(this.publicApiTemplateUriPaths)).append("\n");
        sb.append("    topicParameters: ").append(this.toIndentedString(this.topicParameters)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=VisibilityEnumDeserializer.class)
    public static enum VisibilityEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PUBLIC("Public"),
        PREVIEW("Preview");

        private String value;

        private VisibilityEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static VisibilityEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (VisibilityEnum value : VisibilityEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return VisibilityEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=TransportsEnumDeserializer.class)
    public static enum TransportsEnum {
        ALL("All"),
        WEBSOCKET("Websocket"),
        EVENTBRIDGE("EventBridge"),
        PROCESSAUTOMATION("ProcessAutomation");

        private String value;

        private TransportsEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TransportsEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TransportsEnum value : TransportsEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TransportsEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TransportsEnumDeserializer
    extends StdDeserializer<TransportsEnum> {
        public TransportsEnumDeserializer() {
            super(TransportsEnumDeserializer.class);
        }

        public TransportsEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TransportsEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class VisibilityEnumDeserializer
    extends StdDeserializer<VisibilityEnum> {
        public VisibilityEnumDeserializer() {
            super(VisibilityEnumDeserializer.class);
        }

        public VisibilityEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return VisibilityEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

