/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AgentStateSessionFilter;
import com.mypurecloud.sdk.v2.model.AgentStateUserFilter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class AgentStateQueryRequest
implements Serializable {
    private AgentStateUserFilter userFilter = null;
    private AgentStateSessionFilter sessionFilter = null;
    private UserOrderByEnum userOrderBy = null;
    private UserOrderEnum userOrder = null;
    private SessionOrderByEnum sessionOrderBy = null;
    private SessionOrderEnum sessionOrder = null;

    public AgentStateQueryRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public AgentStateQueryRequest userFilter(AgentStateUserFilter userFilter) {
        this.userFilter = userFilter;
        return this;
    }

    @ApiModelProperty(example="null", value="Filters that target user-level data")
    @JsonProperty(value="userFilter")
    public AgentStateUserFilter getUserFilter() {
        return this.userFilter;
    }

    public void setUserFilter(AgentStateUserFilter userFilter) {
        this.userFilter = userFilter;
    }

    public AgentStateQueryRequest sessionFilter(AgentStateSessionFilter sessionFilter) {
        this.sessionFilter = sessionFilter;
        return this;
    }

    @ApiModelProperty(example="null", value="Filters that target session-level data")
    @JsonProperty(value="sessionFilter")
    public AgentStateSessionFilter getSessionFilter() {
        return this.sessionFilter;
    }

    public void setSessionFilter(AgentStateSessionFilter sessionFilter) {
        this.sessionFilter = sessionFilter;
    }

    public AgentStateQueryRequest userOrderBy(UserOrderByEnum userOrderBy) {
        this.userOrderBy = userOrderBy;
        return this;
    }

    @ApiModelProperty(example="null", value="Search user order dimension names; default to userName")
    @JsonProperty(value="userOrderBy")
    public UserOrderByEnum getUserOrderBy() {
        return this.userOrderBy;
    }

    public void setUserOrderBy(UserOrderByEnum userOrderBy) {
        this.userOrderBy = userOrderBy;
    }

    public AgentStateQueryRequest userOrder(UserOrderEnum userOrder) {
        this.userOrder = userOrder;
        return this;
    }

    @ApiModelProperty(example="null", value="Search user order direction; default to asc")
    @JsonProperty(value="userOrder")
    public UserOrderEnum getUserOrder() {
        return this.userOrder;
    }

    public void setUserOrder(UserOrderEnum userOrder) {
        this.userOrder = userOrder;
    }

    public AgentStateQueryRequest sessionOrderBy(SessionOrderByEnum sessionOrderBy) {
        this.sessionOrderBy = sessionOrderBy;
        return this;
    }

    @ApiModelProperty(example="null", value="Search session order dimension names; default to segmentStart")
    @JsonProperty(value="sessionOrderBy")
    public SessionOrderByEnum getSessionOrderBy() {
        return this.sessionOrderBy;
    }

    public void setSessionOrderBy(SessionOrderByEnum sessionOrderBy) {
        this.sessionOrderBy = sessionOrderBy;
    }

    public AgentStateQueryRequest sessionOrder(SessionOrderEnum sessionOrder) {
        this.sessionOrder = sessionOrder;
        return this;
    }

    @ApiModelProperty(example="null", value="Search session order direction; default to asc")
    @JsonProperty(value="sessionOrder")
    public SessionOrderEnum getSessionOrder() {
        return this.sessionOrder;
    }

    public void setSessionOrder(SessionOrderEnum sessionOrder) {
        this.sessionOrder = sessionOrder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgentStateQueryRequest agentStateQueryRequest = (AgentStateQueryRequest)o;
        return Objects.equals(this.userFilter, agentStateQueryRequest.userFilter) && Objects.equals(this.sessionFilter, agentStateQueryRequest.sessionFilter) && Objects.equals((Object)this.userOrderBy, (Object)agentStateQueryRequest.userOrderBy) && Objects.equals((Object)this.userOrder, (Object)agentStateQueryRequest.userOrder) && Objects.equals((Object)this.sessionOrderBy, (Object)agentStateQueryRequest.sessionOrderBy) && Objects.equals((Object)this.sessionOrder, (Object)agentStateQueryRequest.sessionOrder);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.userFilter, this.sessionFilter, this.userOrderBy, this.userOrder, this.sessionOrderBy, this.sessionOrder});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AgentStateQueryRequest {\n");
        sb.append("    userFilter: ").append(this.toIndentedString(this.userFilter)).append("\n");
        sb.append("    sessionFilter: ").append(this.toIndentedString(this.sessionFilter)).append("\n");
        sb.append("    userOrderBy: ").append(this.toIndentedString((Object)this.userOrderBy)).append("\n");
        sb.append("    userOrder: ").append(this.toIndentedString((Object)this.userOrder)).append("\n");
        sb.append("    sessionOrderBy: ").append(this.toIndentedString((Object)this.sessionOrderBy)).append("\n");
        sb.append("    sessionOrder: ").append(this.toIndentedString((Object)this.sessionOrder)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=UserOrderByEnumDeserializer.class)
    public static enum UserOrderByEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        USERNAME("userName"),
        SEGMENTSTART("segmentStart"),
        SESSIONSTART("sessionStart");

        private String value;

        private UserOrderByEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static UserOrderByEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (UserOrderByEnum value : UserOrderByEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return UserOrderByEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=UserOrderEnumDeserializer.class)
    public static enum UserOrderEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ASC("asc"),
        DESC("desc");

        private String value;

        private UserOrderEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static UserOrderEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (UserOrderEnum value : UserOrderEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return UserOrderEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=SessionOrderByEnumDeserializer.class)
    public static enum SessionOrderByEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SEGMENTSTART("segmentStart"),
        SESSIONSTART("sessionStart");

        private String value;

        private SessionOrderByEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SessionOrderByEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SessionOrderByEnum value : SessionOrderByEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SessionOrderByEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=SessionOrderEnumDeserializer.class)
    public static enum SessionOrderEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ASC("asc"),
        DESC("desc");

        private String value;

        private SessionOrderEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SessionOrderEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SessionOrderEnum value : SessionOrderEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SessionOrderEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class SessionOrderEnumDeserializer
    extends StdDeserializer<SessionOrderEnum> {
        public SessionOrderEnumDeserializer() {
            super(SessionOrderEnumDeserializer.class);
        }

        public SessionOrderEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SessionOrderEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class SessionOrderByEnumDeserializer
    extends StdDeserializer<SessionOrderByEnum> {
        public SessionOrderByEnumDeserializer() {
            super(SessionOrderByEnumDeserializer.class);
        }

        public SessionOrderByEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SessionOrderByEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class UserOrderEnumDeserializer
    extends StdDeserializer<UserOrderEnum> {
        public UserOrderEnumDeserializer() {
            super(UserOrderEnumDeserializer.class);
        }

        public UserOrderEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return UserOrderEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class UserOrderByEnumDeserializer
    extends StdDeserializer<UserOrderByEnum> {
        public UserOrderByEnumDeserializer() {
            super(UserOrderByEnumDeserializer.class);
        }

        public UserOrderByEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return UserOrderByEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

