/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AutoStatusTransitionDetail;
import com.mypurecloud.sdk.v2.model.Division;
import com.mypurecloud.sdk.v2.model.ExternalContactReference;
import com.mypurecloud.sdk.v2.model.LanguageReference;
import com.mypurecloud.sdk.v2.model.RoutingSkillReference;
import com.mypurecloud.sdk.v2.model.UserReference;
import com.mypurecloud.sdk.v2.model.UserReferenceWithName;
import com.mypurecloud.sdk.v2.model.WorkbinReference;
import com.mypurecloud.sdk.v2.model.WorkitemQueueReference;
import com.mypurecloud.sdk.v2.model.WorkitemSchema;
import com.mypurecloud.sdk.v2.model.WorkitemScoredAgent;
import com.mypurecloud.sdk.v2.model.WorkitemScriptReference;
import com.mypurecloud.sdk.v2.model.WorkitemStatusReference;
import com.mypurecloud.sdk.v2.model.WorkitemUtilizationLabelReference;
import com.mypurecloud.sdk.v2.model.WorktypeReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class WorkitemVersion
implements Serializable {
    private String id = null;
    private String name = null;
    private Division division = null;
    private WorktypeReference type = null;
    private String description = null;
    private LanguageReference language = null;
    private WorkitemUtilizationLabelReference utilizationLabel = null;
    private Integer priority = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private Date dateDue = null;
    private Date dateExpires = null;
    private Integer durationSeconds = null;
    private Integer ttl = null;
    private WorkitemStatusReference status = null;
    private StatusCategoryEnum statusCategory = null;
    private Date dateStatusChanged = null;
    private Date dateClosed = null;
    private WorkbinReference workbin = null;
    private UserReferenceWithName reporter = null;
    private UserReferenceWithName assignee = null;
    private ExternalContactReference externalContact = null;
    private String externalTag = null;
    private UserReference modifiedBy = null;
    private WorkitemQueueReference queue = null;
    private AssignmentStateEnum assignmentState = null;
    private Date dateAssignmentStateChanged = null;
    private Integer alertTimeoutSeconds = null;
    private List<RoutingSkillReference> skills = null;
    private List<UserReference> preferredAgents = null;
    private Boolean autoStatusTransition = null;
    private WorkitemSchema schema = null;
    private Map<String, Object> customFields = null;
    private AutoStatusTransitionDetail autoStatusTransitionDetail = null;
    private List<WorkitemScoredAgent> scoredAgents = null;
    private WorkitemScriptReference script = null;
    private Integer version = null;
    private String selfUri = null;

    public WorkitemVersion() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.skills = new ArrayList<RoutingSkillReference>();
            this.preferredAgents = new ArrayList<UserReference>();
            this.scoredAgents = new ArrayList<WorkitemScoredAgent>();
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public WorkitemVersion name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of the Workitem.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WorkitemVersion division(Division division) {
        this.division = division;
        return this;
    }

    @ApiModelProperty(example="null", value="The division to which this entity belongs.")
    @JsonProperty(value="division")
    public Division getDivision() {
        return this.division;
    }

    public void setDivision(Division division) {
        this.division = division;
    }

    public WorkitemVersion type(WorktypeReference type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="The Worktype of the Workitem.")
    @JsonProperty(value="type")
    public WorktypeReference getType() {
        return this.type;
    }

    public void setType(WorktypeReference type) {
        this.type = type;
    }

    public WorkitemVersion description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="The description of the Workitem.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public WorkitemVersion language(LanguageReference language) {
        this.language = language;
        return this;
    }

    @ApiModelProperty(example="null", value="The language of the Workitem.")
    @JsonProperty(value="language")
    public LanguageReference getLanguage() {
        return this.language;
    }

    public void setLanguage(LanguageReference language) {
        this.language = language;
    }

    public WorkitemVersion utilizationLabel(WorkitemUtilizationLabelReference utilizationLabel) {
        this.utilizationLabel = utilizationLabel;
        return this;
    }

    @ApiModelProperty(example="null", value="The utilization label of the Workitem.")
    @JsonProperty(value="utilizationLabel")
    public WorkitemUtilizationLabelReference getUtilizationLabel() {
        return this.utilizationLabel;
    }

    public void setUtilizationLabel(WorkitemUtilizationLabelReference utilizationLabel) {
        this.utilizationLabel = utilizationLabel;
    }

    public WorkitemVersion priority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @ApiModelProperty(example="null", value="The priority of the Workitem. The valid range is between -25,000,000 and 25,000,000.")
    @JsonProperty(value="priority")
    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public WorkitemVersion dateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    @ApiModelProperty(example="null", value="The creation date of the Workitem. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public WorkitemVersion dateModified(Date dateModified) {
        this.dateModified = dateModified;
        return this;
    }

    @ApiModelProperty(example="null", value="The modified date of the Workitem. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    public WorkitemVersion dateDue(Date dateDue) {
        this.dateDue = dateDue;
        return this;
    }

    @ApiModelProperty(example="null", value="The due date of the Workitem. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateDue")
    public Date getDateDue() {
        return this.dateDue;
    }

    public void setDateDue(Date dateDue) {
        this.dateDue = dateDue;
    }

    public WorkitemVersion dateExpires(Date dateExpires) {
        this.dateExpires = dateExpires;
        return this;
    }

    @ApiModelProperty(example="null", value="The expiry date of the Workitem. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateExpires")
    public Date getDateExpires() {
        return this.dateExpires;
    }

    public void setDateExpires(Date dateExpires) {
        this.dateExpires = dateExpires;
    }

    public WorkitemVersion durationSeconds(Integer durationSeconds) {
        this.durationSeconds = durationSeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="The estimated duration in seconds to complete the workitem.")
    @JsonProperty(value="durationSeconds")
    public Integer getDurationSeconds() {
        return this.durationSeconds;
    }

    public void setDurationSeconds(Integer durationSeconds) {
        this.durationSeconds = durationSeconds;
    }

    public WorkitemVersion ttl(Integer ttl) {
        this.ttl = ttl;
        return this;
    }

    @ApiModelProperty(example="null", value="The time to live of the Workitem in seconds.")
    @JsonProperty(value="ttl")
    public Integer getTtl() {
        return this.ttl;
    }

    public void setTtl(Integer ttl) {
        this.ttl = ttl;
    }

    public WorkitemVersion status(WorkitemStatusReference status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="The current Status of the Workitem.")
    @JsonProperty(value="status")
    public WorkitemStatusReference getStatus() {
        return this.status;
    }

    public void setStatus(WorkitemStatusReference status) {
        this.status = status;
    }

    public WorkitemVersion statusCategory(StatusCategoryEnum statusCategory) {
        this.statusCategory = statusCategory;
        return this;
    }

    @ApiModelProperty(example="null", value="The Category of the current Status of the Workitem.")
    @JsonProperty(value="statusCategory")
    public StatusCategoryEnum getStatusCategory() {
        return this.statusCategory;
    }

    public void setStatusCategory(StatusCategoryEnum statusCategory) {
        this.statusCategory = statusCategory;
    }

    public WorkitemVersion dateStatusChanged(Date dateStatusChanged) {
        this.dateStatusChanged = dateStatusChanged;
        return this;
    }

    @ApiModelProperty(example="null", value="The State change date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateStatusChanged")
    public Date getDateStatusChanged() {
        return this.dateStatusChanged;
    }

    public void setDateStatusChanged(Date dateStatusChanged) {
        this.dateStatusChanged = dateStatusChanged;
    }

    public WorkitemVersion dateClosed(Date dateClosed) {
        this.dateClosed = dateClosed;
        return this;
    }

    @ApiModelProperty(example="null", value="The date the Workitem was closed. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateClosed")
    public Date getDateClosed() {
        return this.dateClosed;
    }

    public void setDateClosed(Date dateClosed) {
        this.dateClosed = dateClosed;
    }

    public WorkitemVersion workbin(WorkbinReference workbin) {
        this.workbin = workbin;
        return this;
    }

    @ApiModelProperty(example="null", value="The Workbin that contains the Workitem.")
    @JsonProperty(value="workbin")
    public WorkbinReference getWorkbin() {
        return this.workbin;
    }

    public void setWorkbin(WorkbinReference workbin) {
        this.workbin = workbin;
    }

    public WorkitemVersion reporter(UserReferenceWithName reporter) {
        this.reporter = reporter;
        return this;
    }

    @ApiModelProperty(example="null", value="The reporter of the Workitem.")
    @JsonProperty(value="reporter")
    public UserReferenceWithName getReporter() {
        return this.reporter;
    }

    public void setReporter(UserReferenceWithName reporter) {
        this.reporter = reporter;
    }

    public WorkitemVersion assignee(UserReferenceWithName assignee) {
        this.assignee = assignee;
        return this;
    }

    @ApiModelProperty(example="null", value="The assignee of the Workitem.")
    @JsonProperty(value="assignee")
    public UserReferenceWithName getAssignee() {
        return this.assignee;
    }

    public void setAssignee(UserReferenceWithName assignee) {
        this.assignee = assignee;
    }

    public WorkitemVersion externalContact(ExternalContactReference externalContact) {
        this.externalContact = externalContact;
        return this;
    }

    @ApiModelProperty(example="null", value="The external contact of the Workitem.")
    @JsonProperty(value="externalContact")
    public ExternalContactReference getExternalContact() {
        return this.externalContact;
    }

    public void setExternalContact(ExternalContactReference externalContact) {
        this.externalContact = externalContact;
    }

    public WorkitemVersion externalTag(String externalTag) {
        this.externalTag = externalTag;
        return this;
    }

    @ApiModelProperty(example="null", value="The external tag of the Workitem.")
    @JsonProperty(value="externalTag")
    public String getExternalTag() {
        return this.externalTag;
    }

    public void setExternalTag(String externalTag) {
        this.externalTag = externalTag;
    }

    public WorkitemVersion modifiedBy(UserReference modifiedBy) {
        this.modifiedBy = modifiedBy;
        return this;
    }

    @ApiModelProperty(example="null", value="The User who modified the Workitem.")
    @JsonProperty(value="modifiedBy")
    public UserReference getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(UserReference modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public WorkitemVersion queue(WorkitemQueueReference queue) {
        this.queue = queue;
        return this;
    }

    @ApiModelProperty(example="null", value="The Workitems queue.")
    @JsonProperty(value="queue")
    public WorkitemQueueReference getQueue() {
        return this.queue;
    }

    public void setQueue(WorkitemQueueReference queue) {
        this.queue = queue;
    }

    public WorkitemVersion assignmentState(AssignmentStateEnum assignmentState) {
        this.assignmentState = assignmentState;
        return this;
    }

    @ApiModelProperty(example="null", value="The assignment state of the workitem.")
    @JsonProperty(value="assignmentState")
    public AssignmentStateEnum getAssignmentState() {
        return this.assignmentState;
    }

    public void setAssignmentState(AssignmentStateEnum assignmentState) {
        this.assignmentState = assignmentState;
    }

    public WorkitemVersion dateAssignmentStateChanged(Date dateAssignmentStateChanged) {
        this.dateAssignmentStateChanged = dateAssignmentStateChanged;
        return this;
    }

    @ApiModelProperty(example="null", value="The assignment state change date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateAssignmentStateChanged")
    public Date getDateAssignmentStateChanged() {
        return this.dateAssignmentStateChanged;
    }

    public void setDateAssignmentStateChanged(Date dateAssignmentStateChanged) {
        this.dateAssignmentStateChanged = dateAssignmentStateChanged;
    }

    public WorkitemVersion alertTimeoutSeconds(Integer alertTimeoutSeconds) {
        this.alertTimeoutSeconds = alertTimeoutSeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="The duration in seconds before an alert will timeout.")
    @JsonProperty(value="alertTimeoutSeconds")
    public Integer getAlertTimeoutSeconds() {
        return this.alertTimeoutSeconds;
    }

    public void setAlertTimeoutSeconds(Integer alertTimeoutSeconds) {
        this.alertTimeoutSeconds = alertTimeoutSeconds;
    }

    public WorkitemVersion skills(List<RoutingSkillReference> skills) {
        this.skills = skills;
        return this;
    }

    @ApiModelProperty(example="null", value="The skills of the Workitem.")
    @JsonProperty(value="skills")
    public List<RoutingSkillReference> getSkills() {
        return this.skills;
    }

    public void setSkills(List<RoutingSkillReference> skills) {
        this.skills = skills;
    }

    public WorkitemVersion preferredAgents(List<UserReference> preferredAgents) {
        this.preferredAgents = preferredAgents;
        return this;
    }

    @ApiModelProperty(example="null", value="The preferred agents of the Workitem.")
    @JsonProperty(value="preferredAgents")
    public List<UserReference> getPreferredAgents() {
        return this.preferredAgents;
    }

    public void setPreferredAgents(List<UserReference> preferredAgents) {
        this.preferredAgents = preferredAgents;
    }

    public WorkitemVersion autoStatusTransition(Boolean autoStatusTransition) {
        this.autoStatusTransition = autoStatusTransition;
        return this;
    }

    @ApiModelProperty(example="null", value="Set it to false to disable auto status transition. By default, it is enabled.")
    @JsonProperty(value="autoStatusTransition")
    public Boolean getAutoStatusTransition() {
        return this.autoStatusTransition;
    }

    public void setAutoStatusTransition(Boolean autoStatusTransition) {
        this.autoStatusTransition = autoStatusTransition;
    }

    public WorkitemVersion schema(WorkitemSchema schema) {
        this.schema = schema;
        return this;
    }

    @ApiModelProperty(example="null", value="The schema defining the custom fields of the Workitem. The schema is inherited from the Workitems Worktype at creation time.")
    @JsonProperty(value="schema")
    public WorkitemSchema getSchema() {
        return this.schema;
    }

    public void setSchema(WorkitemSchema schema) {
        this.schema = schema;
    }

    public WorkitemVersion customFields(Map<String, Object> customFields) {
        this.customFields = customFields;
        return this;
    }

    @ApiModelProperty(example="null", value="Custom fields defined in the schema referenced by the Workitem.")
    @JsonProperty(value="customFields")
    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, Object> customFields) {
        this.customFields = customFields;
    }

    public WorkitemVersion autoStatusTransitionDetail(AutoStatusTransitionDetail autoStatusTransitionDetail) {
        this.autoStatusTransitionDetail = autoStatusTransitionDetail;
        return this;
    }

    @ApiModelProperty(example="null", value="Auto status transition details of Workitem.")
    @JsonProperty(value="autoStatusTransitionDetail")
    public AutoStatusTransitionDetail getAutoStatusTransitionDetail() {
        return this.autoStatusTransitionDetail;
    }

    public void setAutoStatusTransitionDetail(AutoStatusTransitionDetail autoStatusTransitionDetail) {
        this.autoStatusTransitionDetail = autoStatusTransitionDetail;
    }

    public WorkitemVersion scoredAgents(List<WorkitemScoredAgent> scoredAgents) {
        this.scoredAgents = scoredAgents;
        return this;
    }

    @ApiModelProperty(example="null", value="A list of scored agents for the Workitem.")
    @JsonProperty(value="scoredAgents")
    public List<WorkitemScoredAgent> getScoredAgents() {
        return this.scoredAgents;
    }

    public void setScoredAgents(List<WorkitemScoredAgent> scoredAgents) {
        this.scoredAgents = scoredAgents;
    }

    public WorkitemVersion script(WorkitemScriptReference script) {
        this.script = script;
        return this;
    }

    @ApiModelProperty(example="null", value="The script that will be executed for the Workitem.")
    @JsonProperty(value="script")
    public WorkitemScriptReference getScript() {
        return this.script;
    }

    public void setScript(WorkitemScriptReference script) {
        this.script = script;
    }

    public WorkitemVersion version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", value="Version")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkitemVersion workitemVersion = (WorkitemVersion)o;
        return Objects.equals(this.id, workitemVersion.id) && Objects.equals(this.name, workitemVersion.name) && Objects.equals(this.division, workitemVersion.division) && Objects.equals(this.type, workitemVersion.type) && Objects.equals(this.description, workitemVersion.description) && Objects.equals(this.language, workitemVersion.language) && Objects.equals(this.utilizationLabel, workitemVersion.utilizationLabel) && Objects.equals(this.priority, workitemVersion.priority) && Objects.equals(this.dateCreated, workitemVersion.dateCreated) && Objects.equals(this.dateModified, workitemVersion.dateModified) && Objects.equals(this.dateDue, workitemVersion.dateDue) && Objects.equals(this.dateExpires, workitemVersion.dateExpires) && Objects.equals(this.durationSeconds, workitemVersion.durationSeconds) && Objects.equals(this.ttl, workitemVersion.ttl) && Objects.equals(this.status, workitemVersion.status) && Objects.equals((Object)this.statusCategory, (Object)workitemVersion.statusCategory) && Objects.equals(this.dateStatusChanged, workitemVersion.dateStatusChanged) && Objects.equals(this.dateClosed, workitemVersion.dateClosed) && Objects.equals(this.workbin, workitemVersion.workbin) && Objects.equals(this.reporter, workitemVersion.reporter) && Objects.equals(this.assignee, workitemVersion.assignee) && Objects.equals(this.externalContact, workitemVersion.externalContact) && Objects.equals(this.externalTag, workitemVersion.externalTag) && Objects.equals(this.modifiedBy, workitemVersion.modifiedBy) && Objects.equals(this.queue, workitemVersion.queue) && Objects.equals((Object)this.assignmentState, (Object)workitemVersion.assignmentState) && Objects.equals(this.dateAssignmentStateChanged, workitemVersion.dateAssignmentStateChanged) && Objects.equals(this.alertTimeoutSeconds, workitemVersion.alertTimeoutSeconds) && Objects.equals(this.skills, workitemVersion.skills) && Objects.equals(this.preferredAgents, workitemVersion.preferredAgents) && Objects.equals(this.autoStatusTransition, workitemVersion.autoStatusTransition) && Objects.equals(this.schema, workitemVersion.schema) && Objects.equals(this.customFields, workitemVersion.customFields) && Objects.equals(this.autoStatusTransitionDetail, workitemVersion.autoStatusTransitionDetail) && Objects.equals(this.scoredAgents, workitemVersion.scoredAgents) && Objects.equals(this.script, workitemVersion.script) && Objects.equals(this.version, workitemVersion.version) && Objects.equals(this.selfUri, workitemVersion.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.division, this.type, this.description, this.language, this.utilizationLabel, this.priority, this.dateCreated, this.dateModified, this.dateDue, this.dateExpires, this.durationSeconds, this.ttl, this.status, this.statusCategory, this.dateStatusChanged, this.dateClosed, this.workbin, this.reporter, this.assignee, this.externalContact, this.externalTag, this.modifiedBy, this.queue, this.assignmentState, this.dateAssignmentStateChanged, this.alertTimeoutSeconds, this.skills, this.preferredAgents, this.autoStatusTransition, this.schema, this.customFields, this.autoStatusTransitionDetail, this.scoredAgents, this.script, this.version, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkitemVersion {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    division: ").append(this.toIndentedString(this.division)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    utilizationLabel: ").append(this.toIndentedString(this.utilizationLabel)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    dateDue: ").append(this.toIndentedString(this.dateDue)).append("\n");
        sb.append("    dateExpires: ").append(this.toIndentedString(this.dateExpires)).append("\n");
        sb.append("    durationSeconds: ").append(this.toIndentedString(this.durationSeconds)).append("\n");
        sb.append("    ttl: ").append(this.toIndentedString(this.ttl)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    statusCategory: ").append(this.toIndentedString((Object)this.statusCategory)).append("\n");
        sb.append("    dateStatusChanged: ").append(this.toIndentedString(this.dateStatusChanged)).append("\n");
        sb.append("    dateClosed: ").append(this.toIndentedString(this.dateClosed)).append("\n");
        sb.append("    workbin: ").append(this.toIndentedString(this.workbin)).append("\n");
        sb.append("    reporter: ").append(this.toIndentedString(this.reporter)).append("\n");
        sb.append("    assignee: ").append(this.toIndentedString(this.assignee)).append("\n");
        sb.append("    externalContact: ").append(this.toIndentedString(this.externalContact)).append("\n");
        sb.append("    externalTag: ").append(this.toIndentedString(this.externalTag)).append("\n");
        sb.append("    modifiedBy: ").append(this.toIndentedString(this.modifiedBy)).append("\n");
        sb.append("    queue: ").append(this.toIndentedString(this.queue)).append("\n");
        sb.append("    assignmentState: ").append(this.toIndentedString((Object)this.assignmentState)).append("\n");
        sb.append("    dateAssignmentStateChanged: ").append(this.toIndentedString(this.dateAssignmentStateChanged)).append("\n");
        sb.append("    alertTimeoutSeconds: ").append(this.toIndentedString(this.alertTimeoutSeconds)).append("\n");
        sb.append("    skills: ").append(this.toIndentedString(this.skills)).append("\n");
        sb.append("    preferredAgents: ").append(this.toIndentedString(this.preferredAgents)).append("\n");
        sb.append("    autoStatusTransition: ").append(this.toIndentedString(this.autoStatusTransition)).append("\n");
        sb.append("    schema: ").append(this.toIndentedString(this.schema)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    autoStatusTransitionDetail: ").append(this.toIndentedString(this.autoStatusTransitionDetail)).append("\n");
        sb.append("    scoredAgents: ").append(this.toIndentedString(this.scoredAgents)).append("\n");
        sb.append("    script: ").append(this.toIndentedString(this.script)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StatusCategoryEnumDeserializer.class)
    public static enum StatusCategoryEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        OPEN("Open"),
        INPROGRESS("InProgress"),
        WAITING("Waiting"),
        CLOSED("Closed"),
        UNKNOWN("Unknown");

        private String value;

        private StatusCategoryEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusCategoryEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusCategoryEnum value : StatusCategoryEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusCategoryEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=AssignmentStateEnumDeserializer.class)
    public static enum AssignmentStateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        UNKNOWN("Unknown"),
        ACDSTARTED("AcdStarted"),
        ALERTING("Alerting"),
        ALERTTIMEOUT("AlertTimeout"),
        ACDCANCELLED("AcdCancelled"),
        TERMINATED("Terminated"),
        IDLE("Idle"),
        DECLINED("Declined"),
        CONNECTED("Connected"),
        DISCONNECTED("Disconnected"),
        PARKED("Parked"),
        HELD("Held"),
        ACDEXPIRED("AcdExpired");

        private String value;

        private AssignmentStateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AssignmentStateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (AssignmentStateEnum value : AssignmentStateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return AssignmentStateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class AssignmentStateEnumDeserializer
    extends StdDeserializer<AssignmentStateEnum> {
        public AssignmentStateEnumDeserializer() {
            super(AssignmentStateEnumDeserializer.class);
        }

        public AssignmentStateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return AssignmentStateEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class StatusCategoryEnumDeserializer
    extends StdDeserializer<StatusCategoryEnum> {
        public StatusCategoryEnumDeserializer() {
            super(StatusCategoryEnumDeserializer.class);
        }

        public StatusCategoryEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusCategoryEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

