/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class RuleSetDiagnostic
implements Serializable {
    private DomainEntityRef ruleSet = null;
    private List<WarningsEnum> warnings = null;

    public RuleSetDiagnostic() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.warnings = new ArrayList<WarningsEnum>();
        }
    }

    @ApiModelProperty(example="null", value="A campaign rule set")
    @JsonProperty(value="ruleSet")
    public DomainEntityRef getRuleSet() {
        return this.ruleSet;
    }

    @ApiModelProperty(example="null", value="Diagnostic warnings for the rule set")
    @JsonProperty(value="warnings")
    public List<WarningsEnum> getWarnings() {
        return this.warnings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuleSetDiagnostic ruleSetDiagnostic = (RuleSetDiagnostic)o;
        return Objects.equals(this.ruleSet, ruleSetDiagnostic.ruleSet) && Objects.equals(this.warnings, ruleSetDiagnostic.warnings);
    }

    public int hashCode() {
        return Objects.hash(this.ruleSet, this.warnings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RuleSetDiagnostic {\n");
        sb.append("    ruleSet: ").append(this.toIndentedString(this.ruleSet)).append("\n");
        sb.append("    warnings: ").append(this.toIndentedString(this.warnings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=WarningsEnumDeserializer.class)
    public static enum WarningsEnum {
        WRAPUP_CODE_NOT_IN_QUEUE("WRAPUP_CODE_NOT_IN_QUEUE"),
        CONTACT_ATTRIBUTE_NOT_IN_CONTACT_LIST("CONTACT_ATTRIBUTE_NOT_IN_CONTACT_LIST"),
        NO_DNC_LIST_FOR_APPEND("NO_DNC_LIST_FOR_APPEND"),
        PHONE_CONDITIONS_WITH_MULTICOLUMN_PREVIEW("PHONE_CONDITIONS_WITH_MULTICOLUMN_PREVIEW");

        private String value;

        private WarningsEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static WarningsEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (WarningsEnum value : WarningsEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return WarningsEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class WarningsEnumDeserializer
    extends StdDeserializer<WarningsEnum> {
        public WarningsEnumDeserializer() {
            super(WarningsEnumDeserializer.class);
        }

        public WarningsEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return WarningsEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

