/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.ContentReaction;
import com.mypurecloud.sdk.v2.model.EventCoBrowse;
import com.mypurecloud.sdk.v2.model.EventPresence;
import com.mypurecloud.sdk.v2.model.EventTyping;
import com.mypurecloud.sdk.v2.model.EventVideo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Message event element.  Examples include: system messages, typing indicators, cobrowse offerings.")
public class MessageEvent
implements Serializable {
    private EventTypeEnum eventType = null;
    private EventCoBrowse coBrowse = null;
    private EventTyping typing = null;
    private EventPresence presence = null;
    private EventVideo video = null;
    private List<ContentReaction> reactions = null;

    public MessageEvent() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.reactions = new ArrayList<ContentReaction>();
        }
    }

    public MessageEvent eventType(EventTypeEnum eventType) {
        this.eventType = eventType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Type of this event element")
    @JsonProperty(value="eventType")
    public EventTypeEnum getEventType() {
        return this.eventType;
    }

    public void setEventType(EventTypeEnum eventType) {
        this.eventType = eventType;
    }

    public MessageEvent coBrowse(EventCoBrowse coBrowse) {
        this.coBrowse = coBrowse;
        return this;
    }

    @ApiModelProperty(example="null", value="CoBrowse event.")
    @JsonProperty(value="coBrowse")
    public EventCoBrowse getCoBrowse() {
        return this.coBrowse;
    }

    public void setCoBrowse(EventCoBrowse coBrowse) {
        this.coBrowse = coBrowse;
    }

    public MessageEvent typing(EventTyping typing) {
        this.typing = typing;
        return this;
    }

    @ApiModelProperty(example="null", value="Typing event.")
    @JsonProperty(value="typing")
    public EventTyping getTyping() {
        return this.typing;
    }

    public void setTyping(EventTyping typing) {
        this.typing = typing;
    }

    public MessageEvent presence(EventPresence presence) {
        this.presence = presence;
        return this;
    }

    @ApiModelProperty(example="null", value="Presence event.")
    @JsonProperty(value="presence")
    public EventPresence getPresence() {
        return this.presence;
    }

    public void setPresence(EventPresence presence) {
        this.presence = presence;
    }

    public MessageEvent video(EventVideo video) {
        this.video = video;
        return this;
    }

    @ApiModelProperty(example="null", value="Video event.")
    @JsonProperty(value="video")
    public EventVideo getVideo() {
        return this.video;
    }

    public void setVideo(EventVideo video) {
        this.video = video;
    }

    public MessageEvent reactions(List<ContentReaction> reactions) {
        this.reactions = reactions;
        return this;
    }

    @ApiModelProperty(example="null", value="A list of reactions to a message.")
    @JsonProperty(value="reactions")
    public List<ContentReaction> getReactions() {
        return this.reactions;
    }

    public void setReactions(List<ContentReaction> reactions) {
        this.reactions = reactions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageEvent messageEvent = (MessageEvent)o;
        return Objects.equals((Object)this.eventType, (Object)messageEvent.eventType) && Objects.equals(this.coBrowse, messageEvent.coBrowse) && Objects.equals(this.typing, messageEvent.typing) && Objects.equals(this.presence, messageEvent.presence) && Objects.equals(this.video, messageEvent.video) && Objects.equals(this.reactions, messageEvent.reactions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.eventType, this.coBrowse, this.typing, this.presence, this.video, this.reactions});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MessageEvent {\n");
        sb.append("    eventType: ").append(this.toIndentedString((Object)this.eventType)).append("\n");
        sb.append("    coBrowse: ").append(this.toIndentedString(this.coBrowse)).append("\n");
        sb.append("    typing: ").append(this.toIndentedString(this.typing)).append("\n");
        sb.append("    presence: ").append(this.toIndentedString(this.presence)).append("\n");
        sb.append("    video: ").append(this.toIndentedString(this.video)).append("\n");
        sb.append("    reactions: ").append(this.toIndentedString(this.reactions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=EventTypeEnumDeserializer.class)
    public static enum EventTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        COBROWSE("CoBrowse"),
        TYPING("Typing"),
        PRESENCE("Presence"),
        VIDEO("Video"),
        REACTIONS("Reactions");

        private String value;

        private EventTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static EventTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (EventTypeEnum value : EventTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return EventTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class EventTypeEnumDeserializer
    extends StdDeserializer<EventTypeEnum> {
        public EventTypeEnumDeserializer() {
            super(EventTypeEnumDeserializer.class);
        }

        public EventTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return EventTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

