/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import com.mypurecloud.sdk.v2.model.EmailErrorInfo;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class GraphApiSettings
implements Serializable {
    private DomainEntityRef integration = null;
    private StatusEnum status = null;
    private EmailErrorInfo errorInfo = null;

    public GraphApiSettings() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public GraphApiSettings integration(DomainEntityRef integration) {
        this.integration = integration;
        return this;
    }

    @ApiModelProperty(example="null", value="The Graph API server integration to use for emails.")
    @JsonProperty(value="integration")
    public DomainEntityRef getIntegration() {
        return this.integration;
    }

    public void setIntegration(DomainEntityRef integration) {
        this.integration = integration;
    }

    @ApiModelProperty(example="null", value="Graph API Server Status")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    @ApiModelProperty(example="null", value="Additional Graph API Server error information")
    @JsonProperty(value="errorInfo")
    public EmailErrorInfo getErrorInfo() {
        return this.errorInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphApiSettings graphApiSettings = (GraphApiSettings)o;
        return Objects.equals(this.integration, graphApiSettings.integration) && Objects.equals((Object)this.status, (Object)graphApiSettings.status) && Objects.equals(this.errorInfo, graphApiSettings.errorInfo);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.integration, this.status, this.errorInfo});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GraphApiSettings {\n");
        sb.append("    integration: ").append(this.toIndentedString(this.integration)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    errorInfo: ").append(this.toIndentedString(this.errorInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ACTIVE("Active"),
        ERROR("Error"),
        INACTIVE("Inactive"),
        INTEGRATIONDELETED("IntegrationDeleted"),
        UNKNOWN("Unknown");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

