/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Format
implements Serializable {
    private List<FlagsEnum> flags = null;

    public Format() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.flags = new ArrayList<FlagsEnum>();
        }
    }

    public Format flags(List<FlagsEnum> flags) {
        this.flags = flags;
        return this;
    }

    @ApiModelProperty(example="null", value="The Set of prompt segment format flags i.e. each entry is a part of describing the overall format. E.g. \"format\": { \"flags\": [StringPlayChars] }")
    @JsonProperty(value="flags")
    public List<FlagsEnum> getFlags() {
        return this.flags;
    }

    public void setFlags(List<FlagsEnum> flags) {
        this.flags = flags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Format format = (Format)o;
        return Objects.equals(this.flags, format.flags);
    }

    public int hashCode() {
        return Objects.hash(this.flags);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Format {\n");
        sb.append("    flags: ").append(this.toIndentedString(this.flags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=FlagsEnumDeserializer.class)
    public static enum FlagsEnum {
        BOOLPLAYYESNO("BoolPlayYesNo"),
        CURRENCYASMINORUNITS("CurrencyAsMinorUnits"),
        CURRENCYMAJORUNITSONLY("CurrencyMajorUnitsOnly"),
        CURRENCYMINORUNITSONLY("CurrencyMinorUnitsOnly"),
        CURRENCYPLAYDIGITS("CurrencyPlayDigits"),
        DATELONGYEAR("DateLongYear"),
        DATESHORTYEAR("DateShortYear"),
        DATESHORTMONTHANDDAY("DateShortMonthAndDay"),
        DATEDAYOFWEEKONLY("DateDayOfWeekOnly"),
        DATEDAYONLY("DateDayOnly"),
        DATEMONTHONLY("DateMonthOnly"),
        DATESHORTYEARONLY("DateShortYearOnly"),
        DATELONGYEARONLY("DateLongYearOnly"),
        TIMETWENTYFOURHOURS("TimeTwentyFourHours"),
        TIMETWELVEHOURS("TimeTwelveHours"),
        TIMEPARTDAYS("TimePartDays"),
        TIMEPARTHOURS("TimePartHours"),
        TIMEPARTMINUTES("TimePartMinutes"),
        TIMEPARTSECONDS("TimePartSeconds"),
        STRINGPLAYCHARS("StringPlayChars"),
        NUMBERPLAYDIGITS("NumberPlayDigits"),
        NUMBERORDINAL("NumberOrdinal"),
        LANGUAGECASEARTICLE("LanguageCaseArticle"),
        LANGUAGECASEACCUSATIVE("LanguageCaseAccusative"),
        LANGUAGECASEDATIVE("LanguageCaseDative"),
        LANGUAGECASEGENITIVE("LanguageCaseGenitive"),
        LANGUAGECASENOMINATIVE("LanguageCaseNominative"),
        LANGUAGEQUANTITYPLURAL("LanguageQuantityPlural"),
        LANGUAGEQUANTITYSINGULAR("LanguageQuantitySingular"),
        LANGUAGEGENDERCOMMON("LanguageGenderCommon"),
        LANGUAGEGENDERFEMININE("LanguageGenderFeminine"),
        LANGUAGEGENDERMASCULINE("LanguageGenderMasculine"),
        LANGUAGEGENDERNEUTER("LanguageGenderNeuter"),
        CASEARTICLE("CaseArticle"),
        CASEACCUSATIVE("CaseAccusative"),
        CASEDATIVE("CaseDative"),
        CASEGENITIVE("CaseGenitive"),
        CASENOMINATIVE("CaseNominative"),
        QUANTITYPLURAL("QuantityPlural"),
        QUANTITYSINGULAR("QuantitySingular"),
        GENDERCOMMON("GenderCommon"),
        GENDERFEMININE("GenderFeminine"),
        GENDERMASCULINE("GenderMasculine"),
        GENDERNEUTER("GenderNeuter");

        private String value;

        private FlagsEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FlagsEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (FlagsEnum value : FlagsEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return FlagsEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class FlagsEnumDeserializer
    extends StdDeserializer<FlagsEnum> {
        public FlagsEnumDeserializer() {
            super(FlagsEnumDeserializer.class);
        }

        public FlagsEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return FlagsEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

