/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class CommonRulePredicateEntity
implements Serializable {
    private EntityTypeEnum entityType = null;
    private AddressableEntityRef user = null;
    private AddressableEntityRef group = null;
    private AddressableEntityRef queue = null;
    private AddressableEntityRef team = null;

    public CommonRulePredicateEntity() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public CommonRulePredicateEntity entityType(EntityTypeEnum entityType) {
        this.entityType = entityType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Specifies the type of entity being evaluated")
    @JsonProperty(value="entityType")
    public EntityTypeEnum getEntityType() {
        return this.entityType;
    }

    public void setEntityType(EntityTypeEnum entityType) {
        this.entityType = entityType;
    }

    public CommonRulePredicateEntity user(AddressableEntityRef user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(example="null", value="User id of the entity being monitored")
    @JsonProperty(value="user")
    public AddressableEntityRef getUser() {
        return this.user;
    }

    public void setUser(AddressableEntityRef user) {
        this.user = user;
    }

    public CommonRulePredicateEntity group(AddressableEntityRef group) {
        this.group = group;
        return this;
    }

    @ApiModelProperty(example="null", value="Group id of the entity being monitored")
    @JsonProperty(value="group")
    public AddressableEntityRef getGroup() {
        return this.group;
    }

    public void setGroup(AddressableEntityRef group) {
        this.group = group;
    }

    public CommonRulePredicateEntity queue(AddressableEntityRef queue) {
        this.queue = queue;
        return this;
    }

    @ApiModelProperty(example="null", value="Queue id of the entity being monitored")
    @JsonProperty(value="queue")
    public AddressableEntityRef getQueue() {
        return this.queue;
    }

    public void setQueue(AddressableEntityRef queue) {
        this.queue = queue;
    }

    public CommonRulePredicateEntity team(AddressableEntityRef team) {
        this.team = team;
        return this;
    }

    @ApiModelProperty(example="null", value="Team id of the entity being monitored")
    @JsonProperty(value="team")
    public AddressableEntityRef getTeam() {
        return this.team;
    }

    public void setTeam(AddressableEntityRef team) {
        this.team = team;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommonRulePredicateEntity commonRulePredicateEntity = (CommonRulePredicateEntity)o;
        return Objects.equals((Object)this.entityType, (Object)commonRulePredicateEntity.entityType) && Objects.equals(this.user, commonRulePredicateEntity.user) && Objects.equals(this.group, commonRulePredicateEntity.group) && Objects.equals(this.queue, commonRulePredicateEntity.queue) && Objects.equals(this.team, commonRulePredicateEntity.team);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.entityType, this.user, this.group, this.queue, this.team});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CommonRulePredicateEntity {\n");
        sb.append("    entityType: ").append(this.toIndentedString((Object)this.entityType)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    group: ").append(this.toIndentedString(this.group)).append("\n");
        sb.append("    queue: ").append(this.toIndentedString(this.queue)).append("\n");
        sb.append("    team: ").append(this.toIndentedString(this.team)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=EntityTypeEnumDeserializer.class)
    public static enum EntityTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        USER("User"),
        GROUP("Group"),
        QUEUE("Queue"),
        TEAM("Team"),
        TEAMMEMBERS("TeamMembers");

        private String value;

        private EntityTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static EntityTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (EntityTypeEnum value : EntityTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return EntityTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class EntityTypeEnumDeserializer
    extends StdDeserializer<EntityTypeEnum> {
        public EntityTypeEnumDeserializer() {
            super(EntityTypeEnumDeserializer.class);
        }

        public EntityTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return EntityTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

