/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.ConversationMessageContent;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class PostTextMessage
implements Serializable {
    private TypeEnum type = null;
    private String text = null;
    private List<ConversationMessageContent> content = null;

    public PostTextMessage() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.content = new ArrayList<ConversationMessageContent>();
        }
    }

    public PostTextMessage type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Message type")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public PostTextMessage text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(example="null", value="Message text. If type is structured, used as fallback for clients that do not support particular structured content")
    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public PostTextMessage content(List<ConversationMessageContent> content) {
        this.content = content;
        return this;
    }

    @ApiModelProperty(example="null", value="A list of content elements in message")
    @JsonProperty(value="content")
    public List<ConversationMessageContent> getContent() {
        return this.content;
    }

    public void setContent(List<ConversationMessageContent> content) {
        this.content = content;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostTextMessage postTextMessage = (PostTextMessage)o;
        return Objects.equals((Object)this.type, (Object)postTextMessage.type) && Objects.equals(this.text, postTextMessage.text) && Objects.equals(this.content, postTextMessage.content);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.text, this.content});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostTextMessage {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        TEXT("Text"),
        STRUCTURED("Structured"),
        RECEIPT("Receipt"),
        EVENT("Event"),
        MESSAGE("Message"),
        UNKNOWN("Unknown");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

