/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.Miner;
import com.mypurecloud.sdk.v2.model.Utterance;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class MinerIntent
implements Serializable {
    private String id = null;
    private String name = null;
    private Miner miner = null;
    private List<Utterance> utterances = null;
    private Double analyticVolumePercent = null;
    private String selfUri = null;

    public MinerIntent() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.utterances = new ArrayList<Utterance>();
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public MinerIntent name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="pay bill.", value="Intent name.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MinerIntent miner(Miner miner) {
        this.miner = miner;
        return this;
    }

    @ApiModelProperty(example="null", value="The miner to which the intent belongs.")
    @JsonProperty(value="miner")
    public Miner getMiner() {
        return this.miner;
    }

    public void setMiner(Miner miner) {
        this.miner = miner;
    }

    public MinerIntent utterances(List<Utterance> utterances) {
        this.utterances = utterances;
        return this;
    }

    @ApiModelProperty(example="null", value="The utterances that are extracted for an Intent.")
    @JsonProperty(value="utterances")
    public List<Utterance> getUtterances() {
        return this.utterances;
    }

    public void setUtterances(List<Utterance> utterances) {
        this.utterances = utterances;
    }

    public MinerIntent analyticVolumePercent(Double analyticVolumePercent) {
        this.analyticVolumePercent = analyticVolumePercent;
        return this;
    }

    @ApiModelProperty(example="21.5", value="Percentage of conversations belonging to the intent.")
    @JsonProperty(value="analyticVolumePercent")
    public Double getAnalyticVolumePercent() {
        return this.analyticVolumePercent;
    }

    public void setAnalyticVolumePercent(Double analyticVolumePercent) {
        this.analyticVolumePercent = analyticVolumePercent;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MinerIntent minerIntent = (MinerIntent)o;
        return Objects.equals(this.id, minerIntent.id) && Objects.equals(this.name, minerIntent.name) && Objects.equals(this.miner, minerIntent.miner) && Objects.equals(this.utterances, minerIntent.utterances) && Objects.equals(this.analyticVolumePercent, minerIntent.analyticVolumePercent) && Objects.equals(this.selfUri, minerIntent.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.miner, this.utterances, this.analyticVolumePercent, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MinerIntent {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    miner: ").append(this.toIndentedString(this.miner)).append("\n");
        sb.append("    utterances: ").append(this.toIndentedString(this.utterances)).append("\n");
        sb.append("    analyticVolumePercent: ").append(this.toIndentedString(this.analyticVolumePercent)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

