/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AssessmentForm;
import com.mypurecloud.sdk.v2.model.LearningModuleCoverArtRequest;
import com.mypurecloud.sdk.v2.model.LearningModuleInformStepRequest;
import com.mypurecloud.sdk.v2.model.ReviewAssessmentResults;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Learning module request")
public class LearningModuleRequest
implements Serializable {
    private String name = null;
    private String description = null;
    private Integer completionTimeInDays = null;
    private List<LearningModuleInformStepRequest> informSteps = null;
    private TypeEnum type = null;
    private AssessmentForm assessmentForm = null;
    private LearningModuleCoverArtRequest coverArt = null;
    private Integer lengthInMinutes = null;
    private Boolean excludedFromCatalog = null;
    private String externalId = null;
    private Boolean enforceContentOrder = null;
    private ReviewAssessmentResults reviewAssessmentResults = null;

    public LearningModuleRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.informSteps = new ArrayList<LearningModuleInformStepRequest>();
        }
    }

    public LearningModuleRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of learning module")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LearningModuleRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="The description of learning module")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public LearningModuleRequest completionTimeInDays(Integer completionTimeInDays) {
        this.completionTimeInDays = completionTimeInDays;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The completion time of learning module in days")
    @JsonProperty(value="completionTimeInDays")
    public Integer getCompletionTimeInDays() {
        return this.completionTimeInDays;
    }

    public void setCompletionTimeInDays(Integer completionTimeInDays) {
        this.completionTimeInDays = completionTimeInDays;
    }

    public LearningModuleRequest informSteps(List<LearningModuleInformStepRequest> informSteps) {
        this.informSteps = informSteps;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of inform steps in a learning module")
    @JsonProperty(value="informSteps")
    public List<LearningModuleInformStepRequest> getInformSteps() {
        return this.informSteps;
    }

    public void setInformSteps(List<LearningModuleInformStepRequest> informSteps) {
        this.informSteps = informSteps;
    }

    public LearningModuleRequest type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="The type for the learning module. Informational, AssessedContent and Assessment are deprecated")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public LearningModuleRequest assessmentForm(AssessmentForm assessmentForm) {
        this.assessmentForm = assessmentForm;
        return this;
    }

    @ApiModelProperty(example="null", value="The assessment form for learning module")
    @JsonProperty(value="assessmentForm")
    public AssessmentForm getAssessmentForm() {
        return this.assessmentForm;
    }

    public void setAssessmentForm(AssessmentForm assessmentForm) {
        this.assessmentForm = assessmentForm;
    }

    public LearningModuleRequest coverArt(LearningModuleCoverArtRequest coverArt) {
        this.coverArt = coverArt;
        return this;
    }

    @ApiModelProperty(example="null", value="The cover art for the learning module")
    @JsonProperty(value="coverArt")
    public LearningModuleCoverArtRequest getCoverArt() {
        return this.coverArt;
    }

    public void setCoverArt(LearningModuleCoverArtRequest coverArt) {
        this.coverArt = coverArt;
    }

    public LearningModuleRequest lengthInMinutes(Integer lengthInMinutes) {
        this.lengthInMinutes = lengthInMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="The recommended time in minutes to complete the module")
    @JsonProperty(value="lengthInMinutes")
    public Integer getLengthInMinutes() {
        return this.lengthInMinutes;
    }

    public void setLengthInMinutes(Integer lengthInMinutes) {
        this.lengthInMinutes = lengthInMinutes;
    }

    public LearningModuleRequest excludedFromCatalog(Boolean excludedFromCatalog) {
        this.excludedFromCatalog = excludedFromCatalog;
        return this;
    }

    @ApiModelProperty(example="null", value="If true, learning module is excluded when retrieving modules for manual assignment")
    @JsonProperty(value="excludedFromCatalog")
    public Boolean getExcludedFromCatalog() {
        return this.excludedFromCatalog;
    }

    public void setExcludedFromCatalog(Boolean excludedFromCatalog) {
        this.excludedFromCatalog = excludedFromCatalog;
    }

    public LearningModuleRequest externalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    @ApiModelProperty(example="null", value="The external ID of the learning module. Maximum length: 50 characters.")
    @JsonProperty(value="externalId")
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public LearningModuleRequest enforceContentOrder(Boolean enforceContentOrder) {
        this.enforceContentOrder = enforceContentOrder;
        return this;
    }

    @ApiModelProperty(example="null", value="If true, learning module content should be viewed one by one in order")
    @JsonProperty(value="enforceContentOrder")
    public Boolean getEnforceContentOrder() {
        return this.enforceContentOrder;
    }

    public void setEnforceContentOrder(Boolean enforceContentOrder) {
        this.enforceContentOrder = enforceContentOrder;
    }

    public LearningModuleRequest reviewAssessmentResults(ReviewAssessmentResults reviewAssessmentResults) {
        this.reviewAssessmentResults = reviewAssessmentResults;
        return this;
    }

    @ApiModelProperty(example="null", value="Allows to view Assessment results in detail")
    @JsonProperty(value="reviewAssessmentResults")
    public ReviewAssessmentResults getReviewAssessmentResults() {
        return this.reviewAssessmentResults;
    }

    public void setReviewAssessmentResults(ReviewAssessmentResults reviewAssessmentResults) {
        this.reviewAssessmentResults = reviewAssessmentResults;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LearningModuleRequest learningModuleRequest = (LearningModuleRequest)o;
        return Objects.equals(this.name, learningModuleRequest.name) && Objects.equals(this.description, learningModuleRequest.description) && Objects.equals(this.completionTimeInDays, learningModuleRequest.completionTimeInDays) && Objects.equals(this.informSteps, learningModuleRequest.informSteps) && Objects.equals((Object)this.type, (Object)learningModuleRequest.type) && Objects.equals(this.assessmentForm, learningModuleRequest.assessmentForm) && Objects.equals(this.coverArt, learningModuleRequest.coverArt) && Objects.equals(this.lengthInMinutes, learningModuleRequest.lengthInMinutes) && Objects.equals(this.excludedFromCatalog, learningModuleRequest.excludedFromCatalog) && Objects.equals(this.externalId, learningModuleRequest.externalId) && Objects.equals(this.enforceContentOrder, learningModuleRequest.enforceContentOrder) && Objects.equals(this.reviewAssessmentResults, learningModuleRequest.reviewAssessmentResults);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.description, this.completionTimeInDays, this.informSteps, this.type, this.assessmentForm, this.coverArt, this.lengthInMinutes, this.excludedFromCatalog, this.externalId, this.enforceContentOrder, this.reviewAssessmentResults});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LearningModuleRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    completionTimeInDays: ").append(this.toIndentedString(this.completionTimeInDays)).append("\n");
        sb.append("    informSteps: ").append(this.toIndentedString(this.informSteps)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    assessmentForm: ").append(this.toIndentedString(this.assessmentForm)).append("\n");
        sb.append("    coverArt: ").append(this.toIndentedString(this.coverArt)).append("\n");
        sb.append("    lengthInMinutes: ").append(this.toIndentedString(this.lengthInMinutes)).append("\n");
        sb.append("    excludedFromCatalog: ").append(this.toIndentedString(this.excludedFromCatalog)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    enforceContentOrder: ").append(this.toIndentedString(this.enforceContentOrder)).append("\n");
        sb.append("    reviewAssessmentResults: ").append(this.toIndentedString(this.reviewAssessmentResults)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INFORMATIONAL("Informational"),
        ASSESSEDCONTENT("AssessedContent"),
        ASSESSMENT("Assessment"),
        EXTERNAL("External"),
        NATIVE("Native");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

