/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import com.mypurecloud.sdk.v2.model.ImportStatus;
import com.mypurecloud.sdk.v2.model.SplittingInformation;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class ImportTemplate
implements Serializable {
    private String id = null;
    private String name = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private Integer version = null;
    private DomainEntityRef contactListTemplate = null;
    private DomainEntityRef contactListFilter = null;
    private Boolean useSplittingCriteria = null;
    private SplittingInformation splittingInformation = null;
    private ListNameFormatEnum listNameFormat = null;
    private String customListNameFormatValue = null;
    private ImportStatus importStatus = null;
    private String selfUri = null;

    public ImportTemplate() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public ImportTemplate name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of the import template.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(example="null", value="Creation time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="Last modified time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public ImportTemplate version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", value="Required for updates, must match the version number of the most recent update")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public ImportTemplate contactListTemplate(DomainEntityRef contactListTemplate) {
        this.contactListTemplate = contactListTemplate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="ContactListTemplate for this ImportTemplate.")
    @JsonProperty(value="contactListTemplate")
    public DomainEntityRef getContactListTemplate() {
        return this.contactListTemplate;
    }

    public void setContactListTemplate(DomainEntityRef contactListTemplate) {
        this.contactListTemplate = contactListTemplate;
    }

    public ImportTemplate contactListFilter(DomainEntityRef contactListFilter) {
        this.contactListFilter = contactListFilter;
        return this;
    }

    @ApiModelProperty(example="null", value="ContactListFilter for this ImportTemplate.")
    @JsonProperty(value="contactListFilter")
    public DomainEntityRef getContactListFilter() {
        return this.contactListFilter;
    }

    public void setContactListFilter(DomainEntityRef contactListFilter) {
        this.contactListFilter = contactListFilter;
    }

    public ImportTemplate useSplittingCriteria(Boolean useSplittingCriteria) {
        this.useSplittingCriteria = useSplittingCriteria;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether or not to use splitting criteria. Default is false.")
    @JsonProperty(value="useSplittingCriteria")
    public Boolean getUseSplittingCriteria() {
        return this.useSplittingCriteria;
    }

    public void setUseSplittingCriteria(Boolean useSplittingCriteria) {
        this.useSplittingCriteria = useSplittingCriteria;
    }

    public ImportTemplate splittingInformation(SplittingInformation splittingInformation) {
        this.splittingInformation = splittingInformation;
        return this;
    }

    @ApiModelProperty(example="null", value="How to split contact records, required if useSplittingCriteria is true.")
    @JsonProperty(value="splittingInformation")
    public SplittingInformation getSplittingInformation() {
        return this.splittingInformation;
    }

    public void setSplittingInformation(SplittingInformation splittingInformation) {
        this.splittingInformation = splittingInformation;
    }

    public ImportTemplate listNameFormat(ListNameFormatEnum listNameFormat) {
        this.listNameFormat = listNameFormat;
        return this;
    }

    @ApiModelProperty(example="null", value="The list name format for target ContactLists. When Custom is provided, customListNameFormatValue is required.")
    @JsonProperty(value="listNameFormat")
    public ListNameFormatEnum getListNameFormat() {
        return this.listNameFormat;
    }

    public void setListNameFormat(ListNameFormatEnum listNameFormat) {
        this.listNameFormat = listNameFormat;
    }

    public ImportTemplate customListNameFormatValue(String customListNameFormatValue) {
        this.customListNameFormatValue = customListNameFormatValue;
        return this;
    }

    @ApiModelProperty(example="null", value="Custom value for the list name format, at least %N is required. Any character other than the specified tokens will be used as is. Available tokens: %N: ListNamePrefix; %P: Part number; %F: Filter name; %C: Column value; YYYY: year; MM: month; DD: day; hh: hour; mm: minute; ss: second.")
    @JsonProperty(value="customListNameFormatValue")
    public String getCustomListNameFormatValue() {
        return this.customListNameFormatValue;
    }

    public void setCustomListNameFormatValue(String customListNameFormatValue) {
        this.customListNameFormatValue = customListNameFormatValue;
    }

    @ApiModelProperty(example="null", value="The status of the import process.")
    @JsonProperty(value="importStatus")
    public ImportStatus getImportStatus() {
        return this.importStatus;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImportTemplate importTemplate = (ImportTemplate)o;
        return Objects.equals(this.id, importTemplate.id) && Objects.equals(this.name, importTemplate.name) && Objects.equals(this.dateCreated, importTemplate.dateCreated) && Objects.equals(this.dateModified, importTemplate.dateModified) && Objects.equals(this.version, importTemplate.version) && Objects.equals(this.contactListTemplate, importTemplate.contactListTemplate) && Objects.equals(this.contactListFilter, importTemplate.contactListFilter) && Objects.equals(this.useSplittingCriteria, importTemplate.useSplittingCriteria) && Objects.equals(this.splittingInformation, importTemplate.splittingInformation) && Objects.equals((Object)this.listNameFormat, (Object)importTemplate.listNameFormat) && Objects.equals(this.customListNameFormatValue, importTemplate.customListNameFormatValue) && Objects.equals(this.importStatus, importTemplate.importStatus) && Objects.equals(this.selfUri, importTemplate.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.dateCreated, this.dateModified, this.version, this.contactListTemplate, this.contactListFilter, this.useSplittingCriteria, this.splittingInformation, this.listNameFormat, this.customListNameFormatValue, this.importStatus, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImportTemplate {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    contactListTemplate: ").append(this.toIndentedString(this.contactListTemplate)).append("\n");
        sb.append("    contactListFilter: ").append(this.toIndentedString(this.contactListFilter)).append("\n");
        sb.append("    useSplittingCriteria: ").append(this.toIndentedString(this.useSplittingCriteria)).append("\n");
        sb.append("    splittingInformation: ").append(this.toIndentedString(this.splittingInformation)).append("\n");
        sb.append("    listNameFormat: ").append(this.toIndentedString((Object)this.listNameFormat)).append("\n");
        sb.append("    customListNameFormatValue: ").append(this.toIndentedString(this.customListNameFormatValue)).append("\n");
        sb.append("    importStatus: ").append(this.toIndentedString(this.importStatus)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ListNameFormatEnumDeserializer.class)
    public static enum ListNameFormatEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        LISTNAMEPREFIX("ListNamePrefix"),
        LISTNAMEPREFIXMONTHDAYYEAR("ListNamePrefixMonthDayYear"),
        LISTNAMEPREFIXMONTHDAYYEARHOURMINUTESECOND("ListNamePrefixMonthDayYearHourMinuteSecond"),
        LISTNAMEPREFIXPART("ListNamePrefixPart"),
        LISTNAMEPREFIXMONTHDAYYEARPART("ListNamePrefixMonthDayYearPart"),
        LISTNAMEPREFIXMONTHDAYYEARHOURMINUTESECONDPART("ListNamePrefixMonthDayYearHourMinuteSecondPart"),
        CUSTOM("Custom");

        private String value;

        private ListNameFormatEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ListNameFormatEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ListNameFormatEnum value : ListNameFormatEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ListNameFormatEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ListNameFormatEnumDeserializer
    extends StdDeserializer<ListNameFormatEnum> {
        public ListNameFormatEnumDeserializer() {
            super(ListNameFormatEnumDeserializer.class);
        }

        public ListNameFormatEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ListNameFormatEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

