/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import com.mypurecloud.sdk.v2.model.FlowLogLevel;
import com.mypurecloud.sdk.v2.model.UserReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@ApiModel(description="This is a table of settings per a loglevel that define what will be logged in executionData when enabled (true)")
public class FlowSettingsResponse
implements Serializable {
    private String id = null;
    private String name = null;
    private TypeEnum type = null;
    private UserReference modifiedBy = null;
    private DomainEntityRef modifiedByClient = null;
    private Date dateModified = null;
    private FlowLogLevel logLevelCharacteristics = null;
    private String selfUri = null;

    public FlowSettingsResponse() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public FlowSettingsResponse name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FlowSettingsResponse type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="The Flow Type")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public FlowSettingsResponse modifiedBy(UserReference modifiedBy) {
        this.modifiedBy = modifiedBy;
        return this;
    }

    @ApiModelProperty(example="null", value="User that last changed the log level setting.")
    @JsonProperty(value="modifiedBy")
    public UserReference getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(UserReference modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public FlowSettingsResponse modifiedByClient(DomainEntityRef modifiedByClient) {
        this.modifiedByClient = modifiedByClient;
        return this;
    }

    @ApiModelProperty(example="null", value="OAuth client that last changed the log level setting.")
    @JsonProperty(value="modifiedByClient")
    public DomainEntityRef getModifiedByClient() {
        return this.modifiedByClient;
    }

    public void setModifiedByClient(DomainEntityRef modifiedByClient) {
        this.modifiedByClient = modifiedByClient;
    }

    public FlowSettingsResponse dateModified(Date dateModified) {
        this.dateModified = dateModified;
        return this;
    }

    @ApiModelProperty(example="null", value="The time this log level was set. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    public FlowSettingsResponse logLevelCharacteristics(FlowLogLevel logLevelCharacteristics) {
        this.logLevelCharacteristics = logLevelCharacteristics;
        return this;
    }

    @ApiModelProperty(example="null", value="The log level set for this flow")
    @JsonProperty(value="logLevelCharacteristics")
    public FlowLogLevel getLogLevelCharacteristics() {
        return this.logLevelCharacteristics;
    }

    public void setLogLevelCharacteristics(FlowLogLevel logLevelCharacteristics) {
        this.logLevelCharacteristics = logLevelCharacteristics;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlowSettingsResponse flowSettingsResponse = (FlowSettingsResponse)o;
        return Objects.equals(this.id, flowSettingsResponse.id) && Objects.equals(this.name, flowSettingsResponse.name) && Objects.equals((Object)this.type, (Object)flowSettingsResponse.type) && Objects.equals(this.modifiedBy, flowSettingsResponse.modifiedBy) && Objects.equals(this.modifiedByClient, flowSettingsResponse.modifiedByClient) && Objects.equals(this.dateModified, flowSettingsResponse.dateModified) && Objects.equals(this.logLevelCharacteristics, flowSettingsResponse.logLevelCharacteristics) && Objects.equals(this.selfUri, flowSettingsResponse.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.type, this.modifiedBy, this.modifiedByClient, this.dateModified, this.logLevelCharacteristics, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FlowSettingsResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    modifiedBy: ").append(this.toIndentedString(this.modifiedBy)).append("\n");
        sb.append("    modifiedByClient: ").append(this.toIndentedString(this.modifiedByClient)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    logLevelCharacteristics: ").append(this.toIndentedString(this.logLevelCharacteristics)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        BOT("bot"),
        COMMONMODULE("commonmodule"),
        DIGITALBOT("digitalbot"),
        INBOUNDCALL("inboundcall"),
        INBOUNDCHAT("inboundchat"),
        INBOUNDEMAIL("inboundemail"),
        INBOUNDSHORTMESSAGE("inboundshortmessage"),
        INQUEUECALL("inqueuecall"),
        INQUEUESHORTMESSAGE("inqueueshortmessage"),
        INQUEUEEMAIL("inqueueemail"),
        OUTBOUNDCALL("outboundcall"),
        SECURECALL("securecall"),
        SURVEYINVITE("surveyinvite"),
        VOICE("voice"),
        VOICEMAIL("voicemail"),
        VOICESURVEY("voicesurvey"),
        WORKFLOW("workflow"),
        WORKITEM("workitem");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

