/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.DocumentationV2SearchAggregation;
import com.mypurecloud.sdk.v2.model.DocumentationV2SearchCriteria;
import com.mypurecloud.sdk.v2.model.SearchSort;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DocumentationV2SearchRequest
implements Serializable {
    private SortOrderEnum sortOrder = null;
    private String sortBy = null;
    private Integer pageSize = null;
    private Integer pageNumber = null;
    private List<SearchSort> sort = null;
    private List<String> types = null;
    private List<DocumentationV2SearchCriteria> query = null;
    private List<DocumentationV2SearchAggregation> aggregations = null;

    public DocumentationV2SearchRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.sort = new ArrayList<SearchSort>();
            this.types = new ArrayList<String>();
            this.query = new ArrayList<DocumentationV2SearchCriteria>();
            this.aggregations = new ArrayList<DocumentationV2SearchAggregation>();
        }
    }

    public DocumentationV2SearchRequest sortOrder(SortOrderEnum sortOrder) {
        this.sortOrder = sortOrder;
        return this;
    }

    @ApiModelProperty(example="null", value="The sort order for results")
    @JsonProperty(value="sortOrder")
    public SortOrderEnum getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(SortOrderEnum sortOrder) {
        this.sortOrder = sortOrder;
    }

    public DocumentationV2SearchRequest sortBy(String sortBy) {
        this.sortBy = sortBy;
        return this;
    }

    @ApiModelProperty(example="null", value="The field in the resource that you want to sort the results by")
    @JsonProperty(value="sortBy")
    public String getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public DocumentationV2SearchRequest pageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of results per page")
    @JsonProperty(value="pageSize")
    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public DocumentationV2SearchRequest pageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    @ApiModelProperty(example="null", value="The page of resources you want to retrieve")
    @JsonProperty(value="pageNumber")
    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public DocumentationV2SearchRequest sort(List<SearchSort> sort) {
        this.sort = sort;
        return this;
    }

    @ApiModelProperty(example="null", value="Multi-value sort order, list of multiple sort values")
    @JsonProperty(value="sort")
    public List<SearchSort> getSort() {
        return this.sort;
    }

    public void setSort(List<SearchSort> sort) {
        this.sort = sort;
    }

    public DocumentationV2SearchRequest types(List<String> types) {
        this.types = types;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Resource domain type to search")
    @JsonProperty(value="types")
    public List<String> getTypes() {
        return this.types;
    }

    public void setTypes(List<String> types) {
        this.types = types;
    }

    public DocumentationV2SearchRequest query(List<DocumentationV2SearchCriteria> query) {
        this.query = query;
        return this;
    }

    @ApiModelProperty(example="null", value="The search criteria")
    @JsonProperty(value="query")
    public List<DocumentationV2SearchCriteria> getQuery() {
        return this.query;
    }

    public void setQuery(List<DocumentationV2SearchCriteria> query) {
        this.query = query;
    }

    public DocumentationV2SearchRequest aggregations(List<DocumentationV2SearchAggregation> aggregations) {
        this.aggregations = aggregations;
        return this;
    }

    @ApiModelProperty(example="null", value="Aggregation criteria")
    @JsonProperty(value="aggregations")
    public List<DocumentationV2SearchAggregation> getAggregations() {
        return this.aggregations;
    }

    public void setAggregations(List<DocumentationV2SearchAggregation> aggregations) {
        this.aggregations = aggregations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentationV2SearchRequest documentationV2SearchRequest = (DocumentationV2SearchRequest)o;
        return Objects.equals((Object)this.sortOrder, (Object)documentationV2SearchRequest.sortOrder) && Objects.equals(this.sortBy, documentationV2SearchRequest.sortBy) && Objects.equals(this.pageSize, documentationV2SearchRequest.pageSize) && Objects.equals(this.pageNumber, documentationV2SearchRequest.pageNumber) && Objects.equals(this.sort, documentationV2SearchRequest.sort) && Objects.equals(this.types, documentationV2SearchRequest.types) && Objects.equals(this.query, documentationV2SearchRequest.query) && Objects.equals(this.aggregations, documentationV2SearchRequest.aggregations);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sortOrder, this.sortBy, this.pageSize, this.pageNumber, this.sort, this.types, this.query, this.aggregations});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentationV2SearchRequest {\n");
        sb.append("    sortOrder: ").append(this.toIndentedString((Object)this.sortOrder)).append("\n");
        sb.append("    sortBy: ").append(this.toIndentedString(this.sortBy)).append("\n");
        sb.append("    pageSize: ").append(this.toIndentedString(this.pageSize)).append("\n");
        sb.append("    pageNumber: ").append(this.toIndentedString(this.pageNumber)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    types: ").append(this.toIndentedString(this.types)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    aggregations: ").append(this.toIndentedString(this.aggregations)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=SortOrderEnumDeserializer.class)
    public static enum SortOrderEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ASC("ASC"),
        DESC("DESC"),
        SCORE("SCORE");

        private String value;

        private SortOrderEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SortOrderEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SortOrderEnum value : SortOrderEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SortOrderEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class SortOrderEnumDeserializer
    extends StdDeserializer<SortOrderEnum> {
        public SortOrderEnumDeserializer() {
            super(SortOrderEnumDeserializer.class);
        }

        public SortOrderEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SortOrderEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

