/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class DnsRecordEntry
implements Serializable {
    private String host = null;
    private String recordContents = null;
    private VerificationStatusEnum verificationStatus = null;

    public DnsRecordEntry() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public DnsRecordEntry host(String host) {
        this.host = host;
        return this;
    }

    @ApiModelProperty(example="null", value="the hostname of the DNS entry")
    @JsonProperty(value="host")
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public DnsRecordEntry recordContents(String recordContents) {
        this.recordContents = recordContents;
        return this;
    }

    @ApiModelProperty(example="null", value="the payload of the DNS entry")
    @JsonProperty(value="recordContents")
    public String getRecordContents() {
        return this.recordContents;
    }

    public void setRecordContents(String recordContents) {
        this.recordContents = recordContents;
    }

    public DnsRecordEntry verificationStatus(VerificationStatusEnum verificationStatus) {
        this.verificationStatus = verificationStatus;
        return this;
    }

    @ApiModelProperty(example="null", value="the current status of the related verification process")
    @JsonProperty(value="verificationStatus")
    public VerificationStatusEnum getVerificationStatus() {
        return this.verificationStatus;
    }

    public void setVerificationStatus(VerificationStatusEnum verificationStatus) {
        this.verificationStatus = verificationStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DnsRecordEntry dnsRecordEntry = (DnsRecordEntry)o;
        return Objects.equals(this.host, dnsRecordEntry.host) && Objects.equals(this.recordContents, dnsRecordEntry.recordContents) && Objects.equals((Object)this.verificationStatus, (Object)dnsRecordEntry.verificationStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.host, this.recordContents, this.verificationStatus});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DnsRecordEntry {\n");
        sb.append("    host: ").append(this.toIndentedString(this.host)).append("\n");
        sb.append("    recordContents: ").append(this.toIndentedString(this.recordContents)).append("\n");
        sb.append("    verificationStatus: ").append(this.toIndentedString((Object)this.verificationStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=VerificationStatusEnumDeserializer.class)
    public static enum VerificationStatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PENDING("Pending"),
        VERIFIED("Verified"),
        FAILED("Failed"),
        UNKNOWN("Unknown");

        private String value;

        private VerificationStatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static VerificationStatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (VerificationStatusEnum value : VerificationStatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return VerificationStatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class VerificationStatusEnumDeserializer
    extends StdDeserializer<VerificationStatusEnum> {
        public VerificationStatusEnumDeserializer() {
            super(VerificationStatusEnumDeserializer.class);
        }

        public VerificationStatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return VerificationStatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

