/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.DirectRoutingMediaSettings;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

public class DirectRouting
implements Serializable {
    private DirectRoutingMediaSettings callMediaSettings = null;
    private DirectRoutingMediaSettings emailMediaSettings = null;
    private DirectRoutingMediaSettings messageMediaSettings = null;
    private String backupQueueId = null;
    private Boolean waitForAgent = null;
    private Integer agentWaitSeconds = null;

    public DirectRouting() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public DirectRouting callMediaSettings(DirectRoutingMediaSettings callMediaSettings) {
        this.callMediaSettings = callMediaSettings;
        return this;
    }

    @ApiModelProperty(example="null", value="Direct Routing Settings specific to Call media.")
    @JsonProperty(value="callMediaSettings")
    public DirectRoutingMediaSettings getCallMediaSettings() {
        return this.callMediaSettings;
    }

    public void setCallMediaSettings(DirectRoutingMediaSettings callMediaSettings) {
        this.callMediaSettings = callMediaSettings;
    }

    public DirectRouting emailMediaSettings(DirectRoutingMediaSettings emailMediaSettings) {
        this.emailMediaSettings = emailMediaSettings;
        return this;
    }

    @ApiModelProperty(example="null", value="Direct Routing Settings specific to Email media.")
    @JsonProperty(value="emailMediaSettings")
    public DirectRoutingMediaSettings getEmailMediaSettings() {
        return this.emailMediaSettings;
    }

    public void setEmailMediaSettings(DirectRoutingMediaSettings emailMediaSettings) {
        this.emailMediaSettings = emailMediaSettings;
    }

    public DirectRouting messageMediaSettings(DirectRoutingMediaSettings messageMediaSettings) {
        this.messageMediaSettings = messageMediaSettings;
        return this;
    }

    @ApiModelProperty(example="null", value="Direct Routing Settings specific to Message media.")
    @JsonProperty(value="messageMediaSettings")
    public DirectRoutingMediaSettings getMessageMediaSettings() {
        return this.messageMediaSettings;
    }

    public void setMessageMediaSettings(DirectRoutingMediaSettings messageMediaSettings) {
        this.messageMediaSettings = messageMediaSettings;
    }

    public DirectRouting backupQueueId(String backupQueueId) {
        this.backupQueueId = backupQueueId;
        return this;
    }

    @ApiModelProperty(example="null", value="ID of another queue to be used as the default backup if an agent does not have their Backup Settings configured. If not set, the current queue will be used as backup, but with Direct Routing criteria removed from the conversation.")
    @JsonProperty(value="backupQueueId")
    public String getBackupQueueId() {
        return this.backupQueueId;
    }

    public void setBackupQueueId(String backupQueueId) {
        this.backupQueueId = backupQueueId;
    }

    public DirectRouting waitForAgent(Boolean waitForAgent) {
        this.waitForAgent = waitForAgent;
        return this;
    }

    @ApiModelProperty(example="null", value="Flag indicating if Direct Routing interactions should wait for Direct Routing agent or go immediately to selected backup.")
    @JsonProperty(value="waitForAgent")
    public Boolean getWaitForAgent() {
        return this.waitForAgent;
    }

    public void setWaitForAgent(Boolean waitForAgent) {
        this.waitForAgent = waitForAgent;
    }

    public DirectRouting agentWaitSeconds(Integer agentWaitSeconds) {
        this.agentWaitSeconds = agentWaitSeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="Time (in seconds) that a Direct Routing interaction will wait for Direct Routing agent before going to selected backup. Valid range [60, 864000].")
    @JsonProperty(value="agentWaitSeconds")
    public Integer getAgentWaitSeconds() {
        return this.agentWaitSeconds;
    }

    public void setAgentWaitSeconds(Integer agentWaitSeconds) {
        this.agentWaitSeconds = agentWaitSeconds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DirectRouting directRouting = (DirectRouting)o;
        return Objects.equals(this.callMediaSettings, directRouting.callMediaSettings) && Objects.equals(this.emailMediaSettings, directRouting.emailMediaSettings) && Objects.equals(this.messageMediaSettings, directRouting.messageMediaSettings) && Objects.equals(this.backupQueueId, directRouting.backupQueueId) && Objects.equals(this.waitForAgent, directRouting.waitForAgent) && Objects.equals(this.agentWaitSeconds, directRouting.agentWaitSeconds);
    }

    public int hashCode() {
        return Objects.hash(this.callMediaSettings, this.emailMediaSettings, this.messageMediaSettings, this.backupQueueId, this.waitForAgent, this.agentWaitSeconds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DirectRouting {\n");
        sb.append("    callMediaSettings: ").append(this.toIndentedString(this.callMediaSettings)).append("\n");
        sb.append("    emailMediaSettings: ").append(this.toIndentedString(this.emailMediaSettings)).append("\n");
        sb.append("    messageMediaSettings: ").append(this.toIndentedString(this.messageMediaSettings)).append("\n");
        sb.append("    backupQueueId: ").append(this.toIndentedString(this.backupQueueId)).append("\n");
        sb.append("    waitForAgent: ").append(this.toIndentedString(this.waitForAgent)).append("\n");
        sb.append("    agentWaitSeconds: ").append(this.toIndentedString(this.agentWaitSeconds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

