/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.WfmScheduleReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Create coaching appointment request")
public class CreateCoachingAppointmentRequest
implements Serializable {
    private String name = null;
    private String description = null;
    private Date dateStart = null;
    private Integer lengthInMinutes = null;
    private String facilitatorId = null;
    private List<String> attendeeIds = null;
    private List<String> conversationIds = null;
    private List<String> documentIds = null;
    private WfmScheduleReference wfmSchedule = null;
    private List<String> externalLinks = null;
    private String location = null;
    private Boolean shareInsightsData = null;

    public CreateCoachingAppointmentRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.attendeeIds = new ArrayList<String>();
            this.conversationIds = new ArrayList<String>();
            this.documentIds = new ArrayList<String>();
            this.externalLinks = new ArrayList<String>();
        }
    }

    public CreateCoachingAppointmentRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of coaching appointment.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateCoachingAppointmentRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The description of coaching appointment.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CreateCoachingAppointmentRequest dateStart(Date dateStart) {
        this.dateStart = dateStart;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The date/time the coaching appointment starts. Times will be rounded down to the minute. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateStart")
    public Date getDateStart() {
        return this.dateStart;
    }

    public void setDateStart(Date dateStart) {
        this.dateStart = dateStart;
    }

    public CreateCoachingAppointmentRequest lengthInMinutes(Integer lengthInMinutes) {
        this.lengthInMinutes = lengthInMinutes;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The duration of coaching appointment in minutes.")
    @JsonProperty(value="lengthInMinutes")
    public Integer getLengthInMinutes() {
        return this.lengthInMinutes;
    }

    public void setLengthInMinutes(Integer lengthInMinutes) {
        this.lengthInMinutes = lengthInMinutes;
    }

    public CreateCoachingAppointmentRequest facilitatorId(String facilitatorId) {
        this.facilitatorId = facilitatorId;
        return this;
    }

    @ApiModelProperty(example="null", value="The facilitator ID of coaching appointment.")
    @JsonProperty(value="facilitatorId")
    public String getFacilitatorId() {
        return this.facilitatorId;
    }

    public void setFacilitatorId(String facilitatorId) {
        this.facilitatorId = facilitatorId;
    }

    public CreateCoachingAppointmentRequest attendeeIds(List<String> attendeeIds) {
        this.attendeeIds = attendeeIds;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="IDs of attendees in the coaching appointment.")
    @JsonProperty(value="attendeeIds")
    public List<String> getAttendeeIds() {
        return this.attendeeIds;
    }

    public void setAttendeeIds(List<String> attendeeIds) {
        this.attendeeIds = attendeeIds;
    }

    public CreateCoachingAppointmentRequest conversationIds(List<String> conversationIds) {
        this.conversationIds = conversationIds;
        return this;
    }

    @ApiModelProperty(example="null", value="IDs of conversations associated with this coaching appointment.")
    @JsonProperty(value="conversationIds")
    public List<String> getConversationIds() {
        return this.conversationIds;
    }

    public void setConversationIds(List<String> conversationIds) {
        this.conversationIds = conversationIds;
    }

    public CreateCoachingAppointmentRequest documentIds(List<String> documentIds) {
        this.documentIds = documentIds;
        return this;
    }

    @ApiModelProperty(example="null", value="IDs of documents associated with this coaching appointment.")
    @JsonProperty(value="documentIds")
    public List<String> getDocumentIds() {
        return this.documentIds;
    }

    public void setDocumentIds(List<String> documentIds) {
        this.documentIds = documentIds;
    }

    public CreateCoachingAppointmentRequest wfmSchedule(WfmScheduleReference wfmSchedule) {
        this.wfmSchedule = wfmSchedule;
        return this;
    }

    @ApiModelProperty(example="null", value="The Workforce Management schedule the appointment is associated with.")
    @JsonProperty(value="wfmSchedule")
    public WfmScheduleReference getWfmSchedule() {
        return this.wfmSchedule;
    }

    public void setWfmSchedule(WfmScheduleReference wfmSchedule) {
        this.wfmSchedule = wfmSchedule;
    }

    public CreateCoachingAppointmentRequest externalLinks(List<String> externalLinks) {
        this.externalLinks = externalLinks;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of external links related to the appointment")
    @JsonProperty(value="externalLinks")
    public List<String> getExternalLinks() {
        return this.externalLinks;
    }

    public void setExternalLinks(List<String> externalLinks) {
        this.externalLinks = externalLinks;
    }

    public CreateCoachingAppointmentRequest location(String location) {
        this.location = location;
        return this;
    }

    @ApiModelProperty(example="null", value="The location of the appointment")
    @JsonProperty(value="location")
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public CreateCoachingAppointmentRequest shareInsightsData(Boolean shareInsightsData) {
        this.shareInsightsData = shareInsightsData;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether to share the insight data")
    @JsonProperty(value="shareInsightsData")
    public Boolean getShareInsightsData() {
        return this.shareInsightsData;
    }

    public void setShareInsightsData(Boolean shareInsightsData) {
        this.shareInsightsData = shareInsightsData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateCoachingAppointmentRequest createCoachingAppointmentRequest = (CreateCoachingAppointmentRequest)o;
        return Objects.equals(this.name, createCoachingAppointmentRequest.name) && Objects.equals(this.description, createCoachingAppointmentRequest.description) && Objects.equals(this.dateStart, createCoachingAppointmentRequest.dateStart) && Objects.equals(this.lengthInMinutes, createCoachingAppointmentRequest.lengthInMinutes) && Objects.equals(this.facilitatorId, createCoachingAppointmentRequest.facilitatorId) && Objects.equals(this.attendeeIds, createCoachingAppointmentRequest.attendeeIds) && Objects.equals(this.conversationIds, createCoachingAppointmentRequest.conversationIds) && Objects.equals(this.documentIds, createCoachingAppointmentRequest.documentIds) && Objects.equals(this.wfmSchedule, createCoachingAppointmentRequest.wfmSchedule) && Objects.equals(this.externalLinks, createCoachingAppointmentRequest.externalLinks) && Objects.equals(this.location, createCoachingAppointmentRequest.location) && Objects.equals(this.shareInsightsData, createCoachingAppointmentRequest.shareInsightsData);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.dateStart, this.lengthInMinutes, this.facilitatorId, this.attendeeIds, this.conversationIds, this.documentIds, this.wfmSchedule, this.externalLinks, this.location, this.shareInsightsData);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateCoachingAppointmentRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    dateStart: ").append(this.toIndentedString(this.dateStart)).append("\n");
        sb.append("    lengthInMinutes: ").append(this.toIndentedString(this.lengthInMinutes)).append("\n");
        sb.append("    facilitatorId: ").append(this.toIndentedString(this.facilitatorId)).append("\n");
        sb.append("    attendeeIds: ").append(this.toIndentedString(this.attendeeIds)).append("\n");
        sb.append("    conversationIds: ").append(this.toIndentedString(this.conversationIds)).append("\n");
        sb.append("    documentIds: ").append(this.toIndentedString(this.documentIds)).append("\n");
        sb.append("    wfmSchedule: ").append(this.toIndentedString(this.wfmSchedule)).append("\n");
        sb.append("    externalLinks: ").append(this.toIndentedString(this.externalLinks)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    shareInsightsData: ").append(this.toIndentedString(this.shareInsightsData)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

