/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AssessmentQuestionGroupScore;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AssessmentScoringSet
implements Serializable {
    private Float totalScore = null;
    private Float totalCriticalScore = null;
    private Float totalNonCriticalScore = null;
    private List<AssessmentQuestionGroupScore> questionGroupScores = null;
    private List<FailureReasonsEnum> failureReasons = null;
    private String comments = null;
    private String agentComments = null;
    private Boolean isPassed = null;

    public AssessmentScoringSet() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.questionGroupScores = new ArrayList<AssessmentQuestionGroupScore>();
            this.failureReasons = new ArrayList<FailureReasonsEnum>();
        }
    }

    @ApiModelProperty(example="null", value="The total score of the answers")
    @JsonProperty(value="totalScore")
    public Float getTotalScore() {
        return this.totalScore;
    }

    @ApiModelProperty(example="null", value="The total score for the critical questions")
    @JsonProperty(value="totalCriticalScore")
    public Float getTotalCriticalScore() {
        return this.totalCriticalScore;
    }

    @ApiModelProperty(example="null", value="The total score for the non-critical questions")
    @JsonProperty(value="totalNonCriticalScore")
    public Float getTotalNonCriticalScore() {
        return this.totalNonCriticalScore;
    }

    public AssessmentScoringSet questionGroupScores(List<AssessmentQuestionGroupScore> questionGroupScores) {
        this.questionGroupScores = questionGroupScores;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The individual scores for each question group")
    @JsonProperty(value="questionGroupScores")
    public List<AssessmentQuestionGroupScore> getQuestionGroupScores() {
        return this.questionGroupScores;
    }

    public void setQuestionGroupScores(List<AssessmentQuestionGroupScore> questionGroupScores) {
        this.questionGroupScores = questionGroupScores;
    }

    @ApiModelProperty(example="null", value="If the assessment was not passed, the reasons for failure.")
    @JsonProperty(value="failureReasons")
    public List<FailureReasonsEnum> getFailureReasons() {
        return this.failureReasons;
    }

    public AssessmentScoringSet comments(String comments) {
        this.comments = comments;
        return this;
    }

    @ApiModelProperty(example="null", value="Comments provided for these answers.")
    @JsonProperty(value="comments")
    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public AssessmentScoringSet agentComments(String agentComments) {
        this.agentComments = agentComments;
        return this;
    }

    @ApiModelProperty(example="null", value="Comments provided by agent.")
    @JsonProperty(value="agentComments")
    public String getAgentComments() {
        return this.agentComments;
    }

    public void setAgentComments(String agentComments) {
        this.agentComments = agentComments;
    }

    @ApiModelProperty(example="null", value="True if the assessment was passed")
    @JsonProperty(value="isPassed")
    public Boolean getIsPassed() {
        return this.isPassed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssessmentScoringSet assessmentScoringSet = (AssessmentScoringSet)o;
        return Objects.equals(this.totalScore, assessmentScoringSet.totalScore) && Objects.equals(this.totalCriticalScore, assessmentScoringSet.totalCriticalScore) && Objects.equals(this.totalNonCriticalScore, assessmentScoringSet.totalNonCriticalScore) && Objects.equals(this.questionGroupScores, assessmentScoringSet.questionGroupScores) && Objects.equals(this.failureReasons, assessmentScoringSet.failureReasons) && Objects.equals(this.comments, assessmentScoringSet.comments) && Objects.equals(this.agentComments, assessmentScoringSet.agentComments) && Objects.equals(this.isPassed, assessmentScoringSet.isPassed);
    }

    public int hashCode() {
        return Objects.hash(this.totalScore, this.totalCriticalScore, this.totalNonCriticalScore, this.questionGroupScores, this.failureReasons, this.comments, this.agentComments, this.isPassed);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AssessmentScoringSet {\n");
        sb.append("    totalScore: ").append(this.toIndentedString(this.totalScore)).append("\n");
        sb.append("    totalCriticalScore: ").append(this.toIndentedString(this.totalCriticalScore)).append("\n");
        sb.append("    totalNonCriticalScore: ").append(this.toIndentedString(this.totalNonCriticalScore)).append("\n");
        sb.append("    questionGroupScores: ").append(this.toIndentedString(this.questionGroupScores)).append("\n");
        sb.append("    failureReasons: ").append(this.toIndentedString(this.failureReasons)).append("\n");
        sb.append("    comments: ").append(this.toIndentedString(this.comments)).append("\n");
        sb.append("    agentComments: ").append(this.toIndentedString(this.agentComments)).append("\n");
        sb.append("    isPassed: ").append(this.toIndentedString(this.isPassed)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=FailureReasonsEnumDeserializer.class)
    public static enum FailureReasonsEnum {
        SCORE("Score"),
        CRITICALSCORE("CriticalScore"),
        KILLQUESTION("KillQuestion");

        private String value;

        private FailureReasonsEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FailureReasonsEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (FailureReasonsEnum value : FailureReasonsEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return FailureReasonsEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class FailureReasonsEnumDeserializer
    extends StdDeserializer<FailureReasonsEnum> {
        public FailureReasonsEnumDeserializer() {
            super(FailureReasonsEnumDeserializer.class);
        }

        public FailureReasonsEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return FailureReasonsEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

