/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.DocumentQuery;
import com.mypurecloud.sdk.v2.model.DocumentQueryInterval;
import com.mypurecloud.sdk.v2.model.KnowledgeConversationContext;
import com.mypurecloud.sdk.v2.model.KnowledgeSearchClientApplication;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class KnowledgeDocumentSearchRequest
implements Serializable {
    private String query = null;
    private Integer pageSize = null;
    private Integer pageNumber = null;
    private String searchId = null;
    private Integer total = null;
    private Integer pageCount = null;
    private QueryTypeEnum queryType = null;
    private Boolean includeDraftDocuments = null;
    private DocumentQueryInterval interval = null;
    private DocumentQuery filter = null;
    private SortOrderEnum sortOrder = null;
    private SortByEnum sortBy = null;
    private KnowledgeSearchClientApplication application = null;
    private KnowledgeConversationContext conversationContext = null;
    private Float confidenceThreshold = null;
    private Integer answerHighlightTopResults = null;
    private List<AnswerModeEnum> answerMode = null;

    public KnowledgeDocumentSearchRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.answerMode = new ArrayList<AnswerModeEnum>();
        }
    }

    public KnowledgeDocumentSearchRequest query(String query) {
        this.query = query;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Query to search content in the knowledge base. Maximum of 30 records per query can be fetched.")
    @JsonProperty(value="query")
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public KnowledgeDocumentSearchRequest pageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @ApiModelProperty(example="null", value="Page size of the returned results.")
    @JsonProperty(value="pageSize")
    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public KnowledgeDocumentSearchRequest pageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    @ApiModelProperty(example="null", value="Page number of the returned results.")
    @JsonProperty(value="pageNumber")
    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the search.")
    @JsonProperty(value="searchId")
    public String getSearchId() {
        return this.searchId;
    }

    @ApiModelProperty(example="null", value="The total number of documents matching the query.")
    @JsonProperty(value="total")
    public Integer getTotal() {
        return this.total;
    }

    @ApiModelProperty(example="null", value="Number of pages returned in the result calculated according to the pageSize and the total")
    @JsonProperty(value="pageCount")
    public Integer getPageCount() {
        return this.pageCount;
    }

    public KnowledgeDocumentSearchRequest queryType(QueryTypeEnum queryType) {
        this.queryType = queryType;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of the query that initiates the search.")
    @JsonProperty(value="queryType")
    public QueryTypeEnum getQueryType() {
        return this.queryType;
    }

    public void setQueryType(QueryTypeEnum queryType) {
        this.queryType = queryType;
    }

    public KnowledgeDocumentSearchRequest includeDraftDocuments(Boolean includeDraftDocuments) {
        this.includeDraftDocuments = includeDraftDocuments;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates whether the search results would also include draft documents.")
    @JsonProperty(value="includeDraftDocuments")
    public Boolean getIncludeDraftDocuments() {
        return this.includeDraftDocuments;
    }

    public void setIncludeDraftDocuments(Boolean includeDraftDocuments) {
        this.includeDraftDocuments = includeDraftDocuments;
    }

    public KnowledgeDocumentSearchRequest interval(DocumentQueryInterval interval) {
        this.interval = interval;
        return this;
    }

    @ApiModelProperty(example="null", value="Retrieves the documents created/modified/published in specified date and time range.")
    @JsonProperty(value="interval")
    public DocumentQueryInterval getInterval() {
        return this.interval;
    }

    public void setInterval(DocumentQueryInterval interval) {
        this.interval = interval;
    }

    public KnowledgeDocumentSearchRequest filter(DocumentQuery filter) {
        this.filter = filter;
        return this;
    }

    @ApiModelProperty(example="null", value="Filter for the document search.")
    @JsonProperty(value="filter")
    public DocumentQuery getFilter() {
        return this.filter;
    }

    public void setFilter(DocumentQuery filter) {
        this.filter = filter;
    }

    public KnowledgeDocumentSearchRequest sortOrder(SortOrderEnum sortOrder) {
        this.sortOrder = sortOrder;
        return this;
    }

    @ApiModelProperty(example="null", value="The sort order for search results.")
    @JsonProperty(value="sortOrder")
    public SortOrderEnum getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(SortOrderEnum sortOrder) {
        this.sortOrder = sortOrder;
    }

    public KnowledgeDocumentSearchRequest sortBy(SortByEnum sortBy) {
        this.sortBy = sortBy;
        return this;
    }

    @ApiModelProperty(example="null", value="The field in the documents that you want to sort the search results by.")
    @JsonProperty(value="sortBy")
    public SortByEnum getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(SortByEnum sortBy) {
        this.sortBy = sortBy;
    }

    public KnowledgeDocumentSearchRequest application(KnowledgeSearchClientApplication application) {
        this.application = application;
        return this;
    }

    @ApiModelProperty(example="null", value="The client application details from which search request was sent.")
    @JsonProperty(value="application")
    public KnowledgeSearchClientApplication getApplication() {
        return this.application;
    }

    public void setApplication(KnowledgeSearchClientApplication application) {
        this.application = application;
    }

    public KnowledgeDocumentSearchRequest conversationContext(KnowledgeConversationContext conversationContext) {
        this.conversationContext = conversationContext;
        return this;
    }

    @ApiModelProperty(example="null", value="Conversation context information if the search is initiated in the context of a conversation.")
    @JsonProperty(value="conversationContext")
    public KnowledgeConversationContext getConversationContext() {
        return this.conversationContext;
    }

    public void setConversationContext(KnowledgeConversationContext conversationContext) {
        this.conversationContext = conversationContext;
    }

    public KnowledgeDocumentSearchRequest confidenceThreshold(Float confidenceThreshold) {
        this.confidenceThreshold = confidenceThreshold;
        return this;
    }

    @ApiModelProperty(example="null", value="The confidence threshold for the search results. If applied, the returned results will have an equal or higher confidence than the threshold. The value should be between 0 to 1.")
    @JsonProperty(value="confidenceThreshold")
    public Float getConfidenceThreshold() {
        return this.confidenceThreshold;
    }

    public void setConfidenceThreshold(Float confidenceThreshold) {
        this.confidenceThreshold = confidenceThreshold;
    }

    public KnowledgeDocumentSearchRequest answerHighlightTopResults(Integer answerHighlightTopResults) {
        this.answerHighlightTopResults = answerHighlightTopResults;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of articles to be sent for answer-highlighting. Can range from 1-5.")
    @JsonProperty(value="answerHighlightTopResults")
    public Integer getAnswerHighlightTopResults() {
        return this.answerHighlightTopResults;
    }

    public void setAnswerHighlightTopResults(Integer answerHighlightTopResults) {
        this.answerHighlightTopResults = answerHighlightTopResults;
    }

    public KnowledgeDocumentSearchRequest answerMode(List<AnswerModeEnum> answerMode) {
        this.answerMode = answerMode;
        return this;
    }

    @ApiModelProperty(example="null", value="Allows extracted answers from an article (AnswerHighlight) and/or AI-generated answers (AnswerGeneration). Default mode: AnswerHighlight. Use this property with answerHighlightTopResults.")
    @JsonProperty(value="answerMode")
    public List<AnswerModeEnum> getAnswerMode() {
        return this.answerMode;
    }

    public void setAnswerMode(List<AnswerModeEnum> answerMode) {
        this.answerMode = answerMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KnowledgeDocumentSearchRequest knowledgeDocumentSearchRequest = (KnowledgeDocumentSearchRequest)o;
        return Objects.equals(this.query, knowledgeDocumentSearchRequest.query) && Objects.equals(this.pageSize, knowledgeDocumentSearchRequest.pageSize) && Objects.equals(this.pageNumber, knowledgeDocumentSearchRequest.pageNumber) && Objects.equals(this.searchId, knowledgeDocumentSearchRequest.searchId) && Objects.equals(this.total, knowledgeDocumentSearchRequest.total) && Objects.equals(this.pageCount, knowledgeDocumentSearchRequest.pageCount) && Objects.equals((Object)this.queryType, (Object)knowledgeDocumentSearchRequest.queryType) && Objects.equals(this.includeDraftDocuments, knowledgeDocumentSearchRequest.includeDraftDocuments) && Objects.equals(this.interval, knowledgeDocumentSearchRequest.interval) && Objects.equals(this.filter, knowledgeDocumentSearchRequest.filter) && Objects.equals((Object)this.sortOrder, (Object)knowledgeDocumentSearchRequest.sortOrder) && Objects.equals((Object)this.sortBy, (Object)knowledgeDocumentSearchRequest.sortBy) && Objects.equals(this.application, knowledgeDocumentSearchRequest.application) && Objects.equals(this.conversationContext, knowledgeDocumentSearchRequest.conversationContext) && Objects.equals(this.confidenceThreshold, knowledgeDocumentSearchRequest.confidenceThreshold) && Objects.equals(this.answerHighlightTopResults, knowledgeDocumentSearchRequest.answerHighlightTopResults) && Objects.equals(this.answerMode, knowledgeDocumentSearchRequest.answerMode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.query, this.pageSize, this.pageNumber, this.searchId, this.total, this.pageCount, this.queryType, this.includeDraftDocuments, this.interval, this.filter, this.sortOrder, this.sortBy, this.application, this.conversationContext, this.confidenceThreshold, this.answerHighlightTopResults, this.answerMode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KnowledgeDocumentSearchRequest {\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    pageSize: ").append(this.toIndentedString(this.pageSize)).append("\n");
        sb.append("    pageNumber: ").append(this.toIndentedString(this.pageNumber)).append("\n");
        sb.append("    searchId: ").append(this.toIndentedString(this.searchId)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("    pageCount: ").append(this.toIndentedString(this.pageCount)).append("\n");
        sb.append("    queryType: ").append(this.toIndentedString((Object)this.queryType)).append("\n");
        sb.append("    includeDraftDocuments: ").append(this.toIndentedString(this.includeDraftDocuments)).append("\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    sortOrder: ").append(this.toIndentedString((Object)this.sortOrder)).append("\n");
        sb.append("    sortBy: ").append(this.toIndentedString((Object)this.sortBy)).append("\n");
        sb.append("    application: ").append(this.toIndentedString(this.application)).append("\n");
        sb.append("    conversationContext: ").append(this.toIndentedString(this.conversationContext)).append("\n");
        sb.append("    confidenceThreshold: ").append(this.toIndentedString(this.confidenceThreshold)).append("\n");
        sb.append("    answerHighlightTopResults: ").append(this.toIndentedString(this.answerHighlightTopResults)).append("\n");
        sb.append("    answerMode: ").append(this.toIndentedString(this.answerMode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=QueryTypeEnumDeserializer.class)
    public static enum QueryTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        AUTOSEARCH("AutoSearch"),
        MANUALSEARCH("ManualSearch"),
        SUGGESTION("Suggestion");

        private String value;

        private QueryTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static QueryTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (QueryTypeEnum value : QueryTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return QueryTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=SortOrderEnumDeserializer.class)
    public static enum SortOrderEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ASC("Asc"),
        DESC("Desc");

        private String value;

        private SortOrderEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SortOrderEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SortOrderEnum value : SortOrderEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SortOrderEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=SortByEnumDeserializer.class)
    public static enum SortByEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CONFIDENCESCORE("ConfidenceScore"),
        DATECREATED("DateCreated"),
        DATEMODIFIED("DateModified"),
        CATEGORYNAME("CategoryName"),
        LABELNAME("LabelName");

        private String value;

        private SortByEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SortByEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SortByEnum value : SortByEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SortByEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=AnswerModeEnumDeserializer.class)
    public static enum AnswerModeEnum {
        ANSWERHIGHLIGHT("AnswerHighlight"),
        ANSWERGENERATION("AnswerGeneration");

        private String value;

        private AnswerModeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AnswerModeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (AnswerModeEnum value : AnswerModeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return AnswerModeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class AnswerModeEnumDeserializer
    extends StdDeserializer<AnswerModeEnum> {
        public AnswerModeEnumDeserializer() {
            super(AnswerModeEnumDeserializer.class);
        }

        public AnswerModeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return AnswerModeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class SortByEnumDeserializer
    extends StdDeserializer<SortByEnum> {
        public SortByEnumDeserializer() {
            super(SortByEnumDeserializer.class);
        }

        public SortByEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SortByEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class SortOrderEnumDeserializer
    extends StdDeserializer<SortOrderEnum> {
        public SortOrderEnumDeserializer() {
            super(SortOrderEnumDeserializer.class);
        }

        public SortOrderEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SortOrderEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class QueryTypeEnumDeserializer
    extends StdDeserializer<QueryTypeEnum> {
        public QueryTypeEnumDeserializer() {
            super(QueryTypeEnumDeserializer.class);
        }

        public QueryTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return QueryTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

