/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.ConfusionDetails;
import com.mypurecloud.sdk.v2.model.OutlierInfo;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class FlowHealthUtterance
implements Serializable {
    private String id = null;
    private String text = null;
    private Long issueCount = null;
    private LanguageEnum language = null;
    private List<StaticValidationResultsEnum> staticValidationResults = null;
    private OutlierInfo outlierInfo = null;
    private ConfusionDetails confusionInfo = null;
    private String selfUri = null;

    public FlowHealthUtterance() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.staticValidationResults = new ArrayList<StaticValidationResultsEnum>();
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public FlowHealthUtterance text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(example="null", value="Utterance Text.")
    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public FlowHealthUtterance issueCount(Long issueCount) {
        this.issueCount = issueCount;
        return this;
    }

    @ApiModelProperty(example="null", value="Number of issues found for this utterance.")
    @JsonProperty(value="issueCount")
    public Long getIssueCount() {
        return this.issueCount;
    }

    public void setIssueCount(Long issueCount) {
        this.issueCount = issueCount;
    }

    public FlowHealthUtterance language(LanguageEnum language) {
        this.language = language;
        return this;
    }

    @ApiModelProperty(example="null", value="Language provided for this utterance's health.")
    @JsonProperty(value="language")
    public LanguageEnum getLanguage() {
        return this.language;
    }

    public void setLanguage(LanguageEnum language) {
        this.language = language;
    }

    public FlowHealthUtterance staticValidationResults(List<StaticValidationResultsEnum> staticValidationResults) {
        this.staticValidationResults = staticValidationResults;
        return this;
    }

    @ApiModelProperty(example="null", value="Validation results for the utterance.")
    @JsonProperty(value="staticValidationResults")
    public List<StaticValidationResultsEnum> getStaticValidationResults() {
        return this.staticValidationResults;
    }

    public void setStaticValidationResults(List<StaticValidationResultsEnum> staticValidationResults) {
        this.staticValidationResults = staticValidationResults;
    }

    public FlowHealthUtterance outlierInfo(OutlierInfo outlierInfo) {
        this.outlierInfo = outlierInfo;
        return this;
    }

    @ApiModelProperty(example="null", value="Details about this utterance being an outlier or not.")
    @JsonProperty(value="outlierInfo")
    public OutlierInfo getOutlierInfo() {
        return this.outlierInfo;
    }

    public void setOutlierInfo(OutlierInfo outlierInfo) {
        this.outlierInfo = outlierInfo;
    }

    public FlowHealthUtterance confusionInfo(ConfusionDetails confusionInfo) {
        this.confusionInfo = confusionInfo;
        return this;
    }

    @ApiModelProperty(example="null", value="Confusion details with other utterances.")
    @JsonProperty(value="confusionInfo")
    public ConfusionDetails getConfusionInfo() {
        return this.confusionInfo;
    }

    public void setConfusionInfo(ConfusionDetails confusionInfo) {
        this.confusionInfo = confusionInfo;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlowHealthUtterance flowHealthUtterance = (FlowHealthUtterance)o;
        return Objects.equals(this.id, flowHealthUtterance.id) && Objects.equals(this.text, flowHealthUtterance.text) && Objects.equals(this.issueCount, flowHealthUtterance.issueCount) && Objects.equals((Object)this.language, (Object)flowHealthUtterance.language) && Objects.equals(this.staticValidationResults, flowHealthUtterance.staticValidationResults) && Objects.equals(this.outlierInfo, flowHealthUtterance.outlierInfo) && Objects.equals(this.confusionInfo, flowHealthUtterance.confusionInfo) && Objects.equals(this.selfUri, flowHealthUtterance.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.text, this.issueCount, this.language, this.staticValidationResults, this.outlierInfo, this.confusionInfo, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FlowHealthUtterance {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    issueCount: ").append(this.toIndentedString(this.issueCount)).append("\n");
        sb.append("    language: ").append(this.toIndentedString((Object)this.language)).append("\n");
        sb.append("    staticValidationResults: ").append(this.toIndentedString(this.staticValidationResults)).append("\n");
        sb.append("    outlierInfo: ").append(this.toIndentedString(this.outlierInfo)).append("\n");
        sb.append("    confusionInfo: ").append(this.toIndentedString(this.confusionInfo)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=LanguageEnumDeserializer.class)
    public static enum LanguageEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        EN_US("en-us"),
        EN_GB("en-gb"),
        EN_AU("en-au"),
        EN_ZA("en-za"),
        EN_NZ("en-nz"),
        EN_IE("en-ie"),
        FR_CA("fr-ca"),
        FR_FR("fr-fr"),
        ES_US("es-us"),
        ES_ES("es-es"),
        ES_MX("es-mx"),
        DE_DE("de-de"),
        IT_IT("it-it"),
        PT_BR("pt-br"),
        PT_PT("pt-pt"),
        NL_NL("nl-nl");

        private String value;

        private LanguageEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static LanguageEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (LanguageEnum value : LanguageEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return LanguageEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=StaticValidationResultsEnumDeserializer.class)
    public static enum StaticValidationResultsEnum {
        TOOFEWUTTERANCES("TooFewUtterances"),
        TOOMANYUTTERANCES("TooManyUtterances"),
        UTTERANCETOOSHORT("UtteranceTooShort"),
        UTTERANCETOOLONG("UtteranceTooLong");

        private String value;

        private StaticValidationResultsEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StaticValidationResultsEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StaticValidationResultsEnum value : StaticValidationResultsEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StaticValidationResultsEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StaticValidationResultsEnumDeserializer
    extends StdDeserializer<StaticValidationResultsEnum> {
        public StaticValidationResultsEnumDeserializer() {
            super(StaticValidationResultsEnumDeserializer.class);
        }

        public StaticValidationResultsEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StaticValidationResultsEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class LanguageEnumDeserializer
    extends StdDeserializer<LanguageEnum> {
        public LanguageEnumDeserializer() {
            super(LanguageEnumDeserializer.class);
        }

        public LanguageEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return LanguageEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

