/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.CreateShareRequestMember;
import com.mypurecloud.sdk.v2.model.SharedEntity;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CreateShareRequest
implements Serializable {
    private SharedEntityTypeEnum sharedEntityType = null;
    private SharedEntity sharedEntity = null;
    private MemberTypeEnum memberType = null;
    private SharedEntity member = null;
    private List<CreateShareRequestMember> members = null;

    public CreateShareRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.members = new ArrayList<CreateShareRequestMember>();
        }
    }

    public CreateShareRequest sharedEntityType(SharedEntityTypeEnum sharedEntityType) {
        this.sharedEntityType = sharedEntityType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The share entity type")
    @JsonProperty(value="sharedEntityType")
    public SharedEntityTypeEnum getSharedEntityType() {
        return this.sharedEntityType;
    }

    public void setSharedEntityType(SharedEntityTypeEnum sharedEntityType) {
        this.sharedEntityType = sharedEntityType;
    }

    public CreateShareRequest sharedEntity(SharedEntity sharedEntity) {
        this.sharedEntity = sharedEntity;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The entity that will be shared")
    @JsonProperty(value="sharedEntity")
    public SharedEntity getSharedEntity() {
        return this.sharedEntity;
    }

    public void setSharedEntity(SharedEntity sharedEntity) {
        this.sharedEntity = sharedEntity;
    }

    public CreateShareRequest memberType(MemberTypeEnum memberType) {
        this.memberType = memberType;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="memberType")
    public MemberTypeEnum getMemberType() {
        return this.memberType;
    }

    public void setMemberType(MemberTypeEnum memberType) {
        this.memberType = memberType;
    }

    public CreateShareRequest member(SharedEntity member) {
        this.member = member;
        return this;
    }

    @ApiModelProperty(example="null", value="The member that will have access to this share. Only required if a list of members is not provided.")
    @JsonProperty(value="member")
    public SharedEntity getMember() {
        return this.member;
    }

    public void setMember(SharedEntity member) {
        this.member = member;
    }

    public CreateShareRequest members(List<CreateShareRequestMember> members) {
        this.members = members;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="members")
    public List<CreateShareRequestMember> getMembers() {
        return this.members;
    }

    public void setMembers(List<CreateShareRequestMember> members) {
        this.members = members;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateShareRequest createShareRequest = (CreateShareRequest)o;
        return Objects.equals((Object)this.sharedEntityType, (Object)createShareRequest.sharedEntityType) && Objects.equals(this.sharedEntity, createShareRequest.sharedEntity) && Objects.equals((Object)this.memberType, (Object)createShareRequest.memberType) && Objects.equals(this.member, createShareRequest.member) && Objects.equals(this.members, createShareRequest.members);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sharedEntityType, this.sharedEntity, this.memberType, this.member, this.members});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateShareRequest {\n");
        sb.append("    sharedEntityType: ").append(this.toIndentedString((Object)this.sharedEntityType)).append("\n");
        sb.append("    sharedEntity: ").append(this.toIndentedString(this.sharedEntity)).append("\n");
        sb.append("    memberType: ").append(this.toIndentedString((Object)this.memberType)).append("\n");
        sb.append("    member: ").append(this.toIndentedString(this.member)).append("\n");
        sb.append("    members: ").append(this.toIndentedString(this.members)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=SharedEntityTypeEnumDeserializer.class)
    public static enum SharedEntityTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        DOCUMENT("DOCUMENT");

        private String value;

        private SharedEntityTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SharedEntityTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SharedEntityTypeEnum value : SharedEntityTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SharedEntityTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=MemberTypeEnumDeserializer.class)
    public static enum MemberTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        USER("USER"),
        GROUP("GROUP"),
        PUBLIC("PUBLIC");

        private String value;

        private MemberTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MemberTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MemberTypeEnum value : MemberTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MemberTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MemberTypeEnumDeserializer
    extends StdDeserializer<MemberTypeEnum> {
        public MemberTypeEnumDeserializer() {
            super(MemberTypeEnumDeserializer.class);
        }

        public MemberTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MemberTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class SharedEntityTypeEnumDeserializer
    extends StdDeserializer<SharedEntityTypeEnum> {
        public SharedEntityTypeEnumDeserializer() {
            super(SharedEntityTypeEnumDeserializer.class);
        }

        public SharedEntityTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SharedEntityTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

